/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Text;
using System.Security.Cryptography;

namespace PostgreSql.Data.NPgClient
{
	internal class MD5Authentication
	{
		public static string GetMD5Hash(byte[] salt, string password)
		{
			HashAlgorithm csp = MD5.Create();
			StringBuilder md5 = new StringBuilder();

			int		length = Encoding.Default.GetByteCount(password);
			byte[]	data = new byte[salt.Length + length];

			Encoding.Default.GetBytes(password, 0, length, data, 0);

			salt.CopyTo(data, length);

			// Calculate hash value
			byte[] hash = csp.ComputeHash(data);

			// Calculate MD5 string
			for (int i = 0; i < hash.Length; i++)
			{
				md5.Append(hash[i].ToString("x2"));
			}

			return md5.ToString();
		}
	}
}