/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Collections;
using System.ComponentModel;
using System.Globalization;

namespace PostgreSql.Data.PgSqlClient
{
	[Serializable,
	ListBindable(false)]
	public sealed class PgErrorCollection : ICollection, IEnumerable
	{
		#region Fields

		private ArrayList errors;

		#endregion

		#region Properties

		public PgError this[string errorMessage] 
		{
			get { return (PgError)errors[errors.IndexOf(errorMessage)]; }
			set { errors[errors.IndexOf(errorMessage)] = (PgError)value; }
		}

		public PgError this[int errorIndex] 
		{
			get { return (PgError)errors[errorIndex]; }
			set { errors[errorIndex] = (PgError)value; }
		}

		public int Count
		{
			get { return errors.Count; }
		}

		public bool IsSynchronized
		{
			get { return errors.IsSynchronized; }
		}

		public object SyncRoot
		{
			get { return errors.SyncRoot; }
		}

		#endregion

		#region constructors

		internal PgErrorCollection()
		{
			errors = new ArrayList();
		}

		#endregion

		#region Methods

		public IEnumerator GetEnumerator()
		{
			return errors.GetEnumerator();
		}

		public void CopyTo(Array array, int index)
		{
			errors.CopyTo(array, index);
		}
			
		internal PgError Add(PgError error)
		{
			errors.Add(error);

			return error;
		}

		internal PgError Add(string severity, string message, string code)
		{
			PgError error = new PgError(severity, code, message);

			return Add(error);
		}

		private bool cultureAwareCompare(string strA, string strB)
		{
			return CultureInfo.CurrentCulture.CompareInfo.Compare(
				strA, 
				strB, 
				CompareOptions.IgnoreKanaType | CompareOptions.IgnoreWidth | 
				CompareOptions.IgnoreCase) == 0 ? true : false;
		}

		#endregion
	}
}
