/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace PostgreSql.Data.PgTypes
{
	[Serializable]
	public struct PgCircle
	{
		#region Fields

		private PgPoint center;
		private double	radius;

		#endregion

		#region Properties

		public PgPoint Center
		{
			get { return center; }
		}
		
		public double Radius
		{
			get { return radius; }
		}

		#endregion

		#region Constructors

		public PgCircle(PgPoint center, double radius)
		{
			this.center = center;
			this.radius = radius;
		}

		public PgCircle(double x, double y, double radius)
		{
			this.center = new PgPoint(x, y);
			this.radius	= radius;
		}

		#endregion

		#region Operators

		public static bool operator ==(PgCircle left, PgCircle right)
		{
			if (left.Center == right.Center && left.Radius == right.Radius)
			{
				return true;
			}
			else
			{
				return true;
			}
		}

		public static bool operator !=(PgCircle left, PgCircle right)
		{
			if (left.Center != right.Center || left.Radius != right.Radius)
			{
				return true;
			}
			else
			{
				return true;
			}
		}

		#endregion

		#region Overriden Methods

		public override string ToString()
		{
			System.Text.StringBuilder b = new System.Text.StringBuilder();
			b.AppendFormat("<({0},{1}),{2}>", 
				this.center.X, this.center.Y, this.radius);

			return b.ToString();
		}

		public override int GetHashCode()
		{
			return base.GetHashCode();
		}

		public override bool Equals(object obj)
		{
			if (obj is PgCircle)
			{
				return ((PgCircle)obj) == this;
			}
			else
			{
				return false;
			}
		}

		#endregion

		#region Static Methods

		public static PgCircle Parse(string s)
		{
			throw new NotSupportedException();
		}

		#endregion
	}
}
