/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClientRectList.h"

#include "ClientRect.h"
#include "ClientRectList.h"
#include "ExceptionCode.h"
#include "JSClientRect.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSClientRectList);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSClientRectListTableValues[3] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectListLength), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectListConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSClientRectListTable = { 5, 3, JSClientRectListTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSClientRectListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSClientRectListConstructorTable = { 1, 0, JSClientRectListConstructorTableValues, 0 };
class JSClientRectListConstructor : public DOMConstructorObject {
public:
    JSClientRectListConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSClientRectListConstructor::s_info = { "ClientRectListConstructor", &DOMConstructorObject::s_info, &JSClientRectListConstructorTable, 0 };

JSClientRectListConstructor::JSClientRectListConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSClientRectListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSClientRectListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClientRectListConstructor, JSDOMWrapper>(exec, &JSClientRectListConstructorTable, this, propertyName, slot);
}

bool JSClientRectListConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSClientRectListConstructor, JSDOMWrapper>(exec, &JSClientRectListConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSClientRectListPrototypeTableValues[2] =
{
    { "item", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsClientRectListPrototypeFunctionItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSClientRectListPrototypeTable = { 2, 1, JSClientRectListPrototypeTableValues, 0 };
const ClassInfo JSClientRectListPrototype::s_info = { "ClientRectListPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSClientRectListPrototypeTable, 0 };

JSObject* JSClientRectListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSClientRectList>(exec, globalObject);
}

bool JSClientRectListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSClientRectListPrototypeTable, this, propertyName, slot);
}

bool JSClientRectListPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSClientRectListPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSClientRectList::s_info = { "ClientRectList", &JSDOMWrapper::s_info, &JSClientRectListTable, 0 };

JSClientRectList::JSClientRectList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ClientRectList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSClientRectList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSClientRectListPrototype(exec->globalData(), globalObject, JSClientRectListPrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSClientRectList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSClientRectListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<ClientRectList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSClientRectList, Base>(exec, &JSClientRectListTable, this, propertyName, slot);
}

bool JSClientRectList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    const HashEntry* entry = JSClientRectListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<ClientRectList*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSClientRectList, Base>(exec, &JSClientRectListTable, this, propertyName, descriptor);
}

bool JSClientRectList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<ClientRectList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsClientRectListLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSClientRectList* castedThis = static_cast<JSClientRectList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ClientRectList* imp = static_cast<ClientRectList*>(castedThis->impl());
    JSValue result = jsNumber(imp->length());
    return result;
}


JSValue jsClientRectListConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSClientRectList* domObject = static_cast<JSClientRectList*>(asObject(slotBase));
    return JSClientRectList::getConstructor(exec, domObject->globalObject());
}

void JSClientRectList::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<ClientRectList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSClientRectList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClientRectListConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsClientRectListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSClientRectList::s_info))
        return throwVMTypeError(exec);
    JSClientRectList* castedThis = static_cast<JSClientRectList*>(asObject(thisValue));
    ClientRectList* imp = static_cast<ClientRectList*>(castedThis->impl());
    int index(exec->argument(0).toUInt32(exec));
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->item(index)));
    return JSValue::encode(result);
}


JSValue JSClientRectList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSClientRectList* thisObj = static_cast<JSClientRectList*>(asObject(slotBase));
    return toJS(exec, thisObj->globalObject(), static_cast<ClientRectList*>(thisObj->impl())->item(index));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ClientRectList* impl)
{
    return wrap<JSClientRectList>(exec, globalObject, impl);
}

ClientRectList* toClientRectList(JSC::JSValue value)
{
    return value.inherits(&JSClientRectList::s_info) ? static_cast<JSClientRectList*>(asObject(value))->impl() : 0;
}

}
