/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class SearchFiles {
    private SearchFiles() {
    }

    public static void main(String[] args) throws Exception {
        String usage = "Usage:\tjava org.apache.lucene.demo.SearchFiles [-index dir] [-field f] [-repeat n] [-queries file] [-query string] [-raw] [-paging hitsPerPage]\n\nSee http://lucene.apache.org/core/4_1_0/demo/ for details.";
        if (args.length > 0 && ("-h".equals(args[0]) || "-help".equals(args[0]))) {
            System.out.println(usage);
            System.exit(0);
        }
        String index = "index";
        String field = "contents";
        String queries = null;
        int repeat = 0;
        boolean raw = false;
        String queryString = null;
        int hitsPerPage = 10;
        for (int i = 0; i < args.length; ++i) {
            if ("-index".equals(args[i])) {
                index = args[i + 1];
                ++i;
                continue;
            }
            if ("-field".equals(args[i])) {
                field = args[i + 1];
                ++i;
                continue;
            }
            if ("-queries".equals(args[i])) {
                queries = args[i + 1];
                ++i;
                continue;
            }
            if ("-query".equals(args[i])) {
                queryString = args[i + 1];
                ++i;
                continue;
            }
            if ("-repeat".equals(args[i])) {
                repeat = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if ("-raw".equals(args[i])) {
                raw = true;
                continue;
            }
            if (!"-paging".equals(args[i])) continue;
            hitsPerPage = Integer.parseInt(args[i + 1]);
            if (hitsPerPage <= 0) {
                System.err.println("There must be at least 1 hit per page.");
                System.exit(1);
            }
            ++i;
        }
        DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((File)new File(index)));
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_4_10_0);
        BufferedReader in = null;
        in = queries != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(queries), StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        QueryParser parser = new QueryParser(Version.LUCENE_4_10_0, field, (Analyzer)analyzer);
        do {
            String line;
            if (queries == null && queryString == null) {
                System.out.println("Enter query: ");
            }
            String string = line = queryString != null ? queryString : in.readLine();
            if (line == null || line.length() == -1 || (line = line.trim()).length() == 0) break;
            Query query = parser.parse(line);
            System.out.println("Searching for: " + query.toString(field));
            if (repeat > 0) {
                Date start = new Date();
                for (int i = 0; i < repeat; ++i) {
                    searcher.search(query, null, 100);
                }
                Date end = new Date();
                System.out.println("Time: " + (end.getTime() - start.getTime()) + "ms");
            }
            SearchFiles.doPagingSearch(in, searcher, query, hitsPerPage, raw, queries == null && queryString == null);
        } while (queryString == null);
        reader.close();
    }

    public static void doPagingSearch(BufferedReader in, IndexSearcher searcher, Query query, int hitsPerPage, boolean raw, boolean interactive) throws IOException {
        TopDocs results = searcher.search(query, 5 * hitsPerPage);
        ScoreDoc[] hits = results.scoreDocs;
        int numTotalHits = results.totalHits;
        System.out.println(numTotalHits + " total matching documents");
        int start = 0;
        int end = Math.min(numTotalHits, hitsPerPage);
        while (true) {
            if (end > hits.length) {
                System.out.println("Only results 1 - " + hits.length + " of " + numTotalHits + " total matching documents collected.");
                System.out.println("Collect more (y/n) ?");
                String line = in.readLine();
                if (line.length() == 0 || line.charAt(0) == 'n') break;
                hits = searcher.search((Query)query, (int)numTotalHits).scoreDocs;
            }
            end = Math.min(hits.length, start + hitsPerPage);
            for (int i = start; i < end; ++i) {
                if (raw) {
                    System.out.println("doc=" + hits[i].doc + " score=" + hits[i].score);
                    continue;
                }
                Document doc = searcher.doc(hits[i].doc);
                String path = doc.get("path");
                if (path != null) {
                    System.out.println(i + 1 + ". " + path);
                    String title = doc.get("title");
                    if (title == null) continue;
                    System.out.println("   Title: " + doc.get("title"));
                    continue;
                }
                System.out.println(i + 1 + ". " + "No path for this document");
            }
            if (!interactive || end == 0) break;
            if (numTotalHits < end) continue;
            boolean quit = false;
            while (true) {
                System.out.print("Press ");
                if (start - hitsPerPage >= 0) {
                    System.out.print("(p)revious page, ");
                }
                if (start + hitsPerPage < numTotalHits) {
                    System.out.print("(n)ext page, ");
                }
                System.out.println("(q)uit or enter number to jump to a page.");
                String line = in.readLine();
                if (line.length() == 0 || line.charAt(0) == 'q') {
                    quit = true;
                    break;
                }
                if (line.charAt(0) == 'p') {
                    start = Math.max(0, start - hitsPerPage);
                    break;
                }
                if (line.charAt(0) == 'n') {
                    if (start + hitsPerPage >= numTotalHits) break;
                    start += hitsPerPage;
                    break;
                }
                int page = Integer.parseInt(line);
                if ((page - 1) * hitsPerPage < numTotalHits) {
                    start = (page - 1) * hitsPerPage;
                    break;
                }
                System.out.println("No such page");
            }
            if (quit) break;
            end = Math.min(numTotalHits, start + hitsPerPage);
        }
    }
}

