/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Options;
import org.javacc.parser.Token;

public class CodeGenerator {
    protected StringBuffer mainBuffer = new StringBuffer();
    protected StringBuffer includeBuffer = new StringBuffer();
    protected StringBuffer staticsBuffer = new StringBuffer();
    protected StringBuffer outputBuffer = this.mainBuffer;
    protected int cline;
    protected int ccol;

    public void genStringLiteralArrayCPP(String string, String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            this.genCodeLine("static const JAVACC_CHAR_TYPE " + string + "_arr_" + n + "[] = ");
            this.genStringLiteralInCPP(stringArray[n]);
            this.genCodeLine(";");
        }
        this.genCodeLine("static const JAVACC_STRING_TYPE " + string + "[] = {");
        for (n = 0; n < stringArray.length; ++n) {
            this.genCodeLine(string + "_arr_" + n + ", ");
        }
        this.genCodeLine("};");
    }

    public void genStringLiteralInCPP(String string) {
        this.outputBuffer.append("{");
        for (int i = 0; i < string.length(); ++i) {
            this.outputBuffer.append("0x" + Integer.toHexString(string.charAt(i)) + ", ");
        }
        this.outputBuffer.append("0}");
    }

    public void genCodeLine(Object ... objectArray) {
        this.genCode(objectArray);
        this.genCode("\n");
    }

    public void genCode(Object ... objectArray) {
        for (Object object : objectArray) {
            this.outputBuffer.append(object);
        }
    }

    public void saveOutput(String string) {
        if (!this.isJavaLanguage()) {
            String string2 = string.replace(".cc", ".h");
            this.includeBuffer.insert(0, "#define " + new File(string2).getName().replace('.', '_').toUpperCase() + "\n");
            this.includeBuffer.insert(0, "#ifndef " + new File(string2).getName().replace('.', '_').toUpperCase() + "\n");
            this.mainBuffer.insert(0, this.staticsBuffer);
            if (Options.stringValue("NAMESPACE").length() > 0) {
                this.mainBuffer.insert(0, "namespace " + Options.stringValue("NAMESPACE_OPEN") + "\n");
                this.mainBuffer.append(Options.stringValue("NAMESPACE_CLOSE") + "\n");
                this.includeBuffer.append(Options.stringValue("NAMESPACE_CLOSE") + "\n");
            }
            this.mainBuffer.insert(0, "#include \"" + string2 + "\"\n");
            this.includeBuffer.append("#endif\n");
            this.saveOutput(string2, this.includeBuffer);
        }
        this.mainBuffer.insert(0, "/* " + new File(string).getName() + " */\n");
        this.saveOutput(string, this.mainBuffer);
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private void fixupLongLiterals(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length() - 1; ++i) {
            int n = i;
            char c = stringBuffer.charAt(i);
            char c2 = stringBuffer.charAt(i + 1);
            if (!Character.isDigit(c) && (c != '0' || c2 != 'x')) continue;
            i += c == '0' ? 2 : 1;
            while (CodeGenerator.isHexDigit(stringBuffer.charAt(i))) {
                ++i;
            }
            if (stringBuffer.charAt(i) == 'L') {
                stringBuffer.insert(i, "UL");
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOutput(String string, StringBuffer stringBuffer) {
        PrintWriter printWriter = null;
        if (!this.isJavaLanguage()) {
            this.fixupLongLiterals(stringBuffer);
        }
        try {
            File file = new File(string);
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file), 8092));
            printWriter.print(stringBuffer.toString());
        }
        catch (IOException iOException) {
            JavaCCErrors.fatal("Could not create output file: " + string);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    protected void printTokenSetup(Token token) {
        Token token2 = token;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        this.cline = token2.beginLine;
        this.ccol = token2.beginColumn;
    }

    protected void printTokenList(List list) {
        Token token2 = null;
        for (Token token2 : list) {
            this.printToken(token2);
        }
        if (token2 != null) {
            this.printTrailingComments(token2);
        }
    }

    protected void printTokenOnly(Token token) {
        this.genCode(this.getStringForTokenOnly(token));
    }

    protected String getStringForTokenOnly(Token token) {
        char c;
        String string = "";
        while (this.cline < token.beginLine) {
            string = string + "\n";
            this.ccol = 1;
            ++this.cline;
        }
        while (this.ccol < token.beginColumn) {
            string = string + " ";
            ++this.ccol;
        }
        string = token.kind == 90 || token.kind == 89 ? string + JavaCCGlobals.addUnicodeEscapes(token.image) : string + token.image;
        this.cline = token.endLine;
        this.ccol = token.endColumn + 1;
        if (token.image.length() > 0 && ((c = token.image.charAt(token.image.length() - 1)) == '\n' || c == '\r')) {
            ++this.cline;
            this.ccol = 1;
        }
        return string;
    }

    protected void printToken(Token token) {
        this.genCode(this.getStringToPrint(token));
    }

    protected String getStringToPrint(Token token) {
        String string = "";
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                string = string + this.getStringForTokenOnly(token2);
                token2 = token2.next;
            }
        }
        return string + this.getStringForTokenOnly(token);
    }

    protected void printLeadingComments(Token token) {
        this.genCode(this.getLeadingComments(token));
    }

    protected String getLeadingComments(Token token) {
        String string = "";
        if (token.specialToken == null) {
            return string;
        }
        Token token2 = token.specialToken;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        while (token2 != null) {
            string = string + this.getStringForTokenOnly(token2);
            token2 = token2.next;
        }
        if (this.ccol != 1 && this.cline != token.beginLine) {
            string = string + "\n";
            ++this.cline;
            this.ccol = 1;
        }
        return string;
    }

    protected void printTrailingComments(Token token) {
        this.outputBuffer.append(this.getTrailingComments(token));
    }

    protected String getTrailingComments(Token token) {
        if (token.next == null) {
            return "";
        }
        return this.getLeadingComments(token.next);
    }

    public String getGeneratedCode() {
        return this.outputBuffer.toString() + "\n";
    }

    public void genAnnotation(String string) {
        if (Options.getOutputLanguage().equals("java")) {
            this.genCode("@" + string);
        } else {
            this.genCode("/*" + string + "*/");
        }
    }

    public void genModifier(String string) {
        String string2 = string.toLowerCase();
        if (this.isJavaLanguage()) {
            this.genCode(string);
        } else if (string2.equals("public") || string2.equals("private")) {
            this.genCode(string2 + ": ");
        }
    }

    public void genClassStart(String string, String string2, String[] stringArray, String[] stringArray2) {
        if (this.isJavaLanguage() && string != null) {
            this.genModifier(string);
        }
        this.genCode("class " + string2);
        if (this.isJavaLanguage()) {
            if (stringArray.length == 1 && stringArray[0] != null) {
                this.genCode(" extends " + stringArray[0]);
            }
            if (stringArray2.length != 0) {
                this.genCode(" implements ");
            }
        } else {
            if (stringArray.length > 0 || stringArray2.length > 0) {
                this.genCode(" : ");
            }
            this.genCommaSeperatedString(stringArray);
        }
        this.genCommaSeperatedString(stringArray2);
        this.genCodeLine(" {");
        if (!this.isJavaLanguage()) {
            this.genCodeLine("   public:");
        }
    }

    private void genCommaSeperatedString(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                this.genCode(", ");
            }
            this.genCode(stringArray[i]);
        }
    }

    protected boolean isJavaLanguage() {
        return Options.getOutputLanguage().equals("java");
    }

    public void switchToMainFile() {
        this.outputBuffer = this.mainBuffer;
    }

    public void switchToStaticsFile() {
        if (!this.isJavaLanguage()) {
            this.outputBuffer = this.staticsBuffer;
        }
    }

    public void switchToIncludeFile() {
        if (!this.isJavaLanguage()) {
            this.outputBuffer = this.includeBuffer;
        }
    }

    public void generateMethodDefHeader(String string, String string2, String string3) {
        this.generateMethodDefHeader(string, string2, string3, null);
    }

    public void generateMethodDefHeader(String string, String string2, String string3, String string4) {
        if (this.isJavaLanguage()) {
            this.genCode(string + " " + string3);
            if (string4 != null) {
                this.genCode(" throws " + string4);
            }
            this.genCodeLine("");
        } else {
            this.includeBuffer.append("\n" + string + " " + string3);
            this.includeBuffer.append(";\n");
            int n = string.lastIndexOf(58);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            if ((n = string.lastIndexOf("virtual")) >= 0) {
                string = string.substring(n + "virtual".length());
            }
            this.mainBuffer.append("\n" + string + " " + this.getClassQualifier(string2) + string3);
            this.switchToMainFile();
        }
    }

    protected String getClassQualifier(String string) {
        return string == null ? "" : string + "::";
    }
}

