/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContainerModelTest
extends AbstractJXPathTest {
    @Test
    public void testContainerMapWithCollection() {
        ListContainer container = new ListContainer();
        List list = (List)container.getValue();
        HashMap<String, ListContainer> map = new HashMap<String, ListContainer>();
        map.put("container", container);
        JXPathContext context = JXPathContext.newContext(map);
        this.assertXPathValueAndPointer(context, "/container", list, "/.[@name='container']");
        this.assertXPathValueAndPointer(context, "/container[1]", list.get(0), "/.[@name='container'][1]");
        this.assertXPathValueAndPointer(context, "/container[2]", list.get(1), "/.[@name='container'][2]");
        this.assertXPathSetValue(context, "/container[1]", "baz");
        Assertions.assertEquals((Object)"baz", list.get(0), (String)"Checking setValue(index)");
    }

    @Test
    public void testContainerPropertyWithCollection() {
        Bean bean = new Bean();
        List list = (List)bean.getContainer().getValue();
        JXPathContext context = JXPathContext.newContext((Object)bean);
        this.assertXPathValueAndPointer(context, "/container", list, "/container");
        this.assertXPathValueAndPointer(context, "/container[1]", list.get(0), "/container[1]");
        this.assertXPathValueAndPointer(context, "/container[2]", list.get(1), "/container[2]");
        this.assertXPathSetValue(context, "/container[1]", "baz");
        Assertions.assertEquals((Object)"baz", list.get(0), (String)"Checking setValue(index)");
    }

    @Test
    public void testContainerRootWithCollection() {
        ArrayContainer container = new ArrayContainer();
        String[] array = (String[])container.getValue();
        JXPathContext context = JXPathContext.newContext((Object)container);
        context.getVariables().declareVariable("list", (Object)container);
        this.assertXPathValueAndPointer(context, "/", array, "/");
        this.assertXPathValueAndPointer(context, "/.[1]", "foo", "/.[1]");
        this.assertXPathValueAndPointer(context, "/.[2]", "bar", "/.[2]");
        this.assertXPathSetValue(context, "/.[1]", "baz");
        Assertions.assertEquals((Object)"baz", (Object)array[0], (String)"Checking setValue(index)");
    }

    @Test
    public void testContainerVariableWithCollection() {
        ArrayContainer container = new ArrayContainer();
        String[] array = (String[])container.getValue();
        JXPathContext context = JXPathContext.newContext(null);
        context.getVariables().declareVariable("list", (Object)container);
        this.assertXPathValueAndPointer(context, "$list", array, "$list");
        this.assertXPathValueAndPointer(context, "$list[1]", "foo", "$list[1]");
        this.assertXPathValueAndPointer(context, "$list[2]", "bar", "$list[2]");
        this.assertXPathSetValue(context, "$list[1]", "baz");
        Assertions.assertEquals((Object)"baz", (Object)array[0], (String)"Checking setValue(index)");
    }

    public class ListContainer
    implements Container {
        private static final long serialVersionUID = 1L;
        private final List list = new ArrayList();

        public ListContainer() {
            this.list.add("foo");
            this.list.add("bar");
        }

        public Object getValue() {
            return this.list;
        }

        public void setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    public class Bean {
        private final ListContainer container;

        public Bean() {
            this.container = new ListContainer();
        }

        public ListContainer getContainer() {
            return this.container;
        }
    }

    private static final class ArrayContainer
    implements Container {
        private static final long serialVersionUID = 1L;
        private final String[] array = new String[]{"foo", "bar"};

        private ArrayContainer() {
        }

        public Object getValue() {
            return this.array;
        }

        public void setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

