/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.InfoSetUtil;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.NameAttributeTest;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.LangAttributePointer;
import org.apache.commons.jxpath.ri.model.beans.NullElementPointer;
import org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class SimplePathInterpreter {
    private static final QName QNAME_NAME = new QName(null, "name");
    private static final int PERFECT_MATCH = 1000;

    private static int computeQuality(NodePointer pointer) {
        int quality = 1000;
        while (pointer != null && !pointer.isActual()) {
            --quality;
            pointer = pointer.getImmediateParentPointer();
        }
        return quality;
    }

    private static NodePointer createChildPointerForStep(PropertyOwnerPointer parentPointer, Step step) {
        int axis = step.getAxis();
        if (axis == 2 || axis == 5) {
            QName qName = ((NodeNameTest)step.getNodeTest()).getNodeName();
            if (axis == 5 && SimplePathInterpreter.isLangAttribute(qName)) {
                return new LangAttributePointer(parentPointer);
            }
            if (parentPointer.isValidProperty(qName)) {
                PropertyPointer childPointer = parentPointer.getPropertyPointer();
                childPointer.setPropertyName(qName.toString());
                childPointer.setAttribute(axis == 5);
                return childPointer;
            }
            return null;
        }
        return parentPointer;
    }

    public static NodePointer createNullPointer(EvalContext context, NodePointer parent, Step[] steps, int currentStep) {
        if (currentStep == steps.length) {
            return parent;
        }
        parent = SimplePathInterpreter.valuePointer(parent);
        Step step = steps[currentStep];
        int axis = step.getAxis();
        if (axis == 2 || axis == 5) {
            NullPropertyPointer pointer = new NullPropertyPointer(parent);
            QName qName = ((NodeNameTest)step.getNodeTest()).getNodeName();
            pointer.setPropertyName(qName.toString());
            pointer.setAttribute(axis == 5);
            parent = pointer;
        }
        Expression[] predicates = step.getPredicates();
        return SimplePathInterpreter.createNullPointerForPredicates(context, parent, steps, currentStep, predicates, 0);
    }

    private static NodePointer createNullPointerForPredicates(EvalContext context, NodePointer parent, Step[] steps, int currentStep, Expression[] predicates, int currentPredicate) {
        for (int i = currentPredicate; i < predicates.length; ++i) {
            Expression predicate = predicates[i];
            if (predicate instanceof NameAttributeTest) {
                String key = SimplePathInterpreter.keyFromPredicate(context, predicate);
                parent = SimplePathInterpreter.valuePointer(parent);
                NullPropertyPointer pointer = new NullPropertyPointer(parent);
                pointer.setNameAttributeValue(key);
                parent = pointer;
                continue;
            }
            int index = SimplePathInterpreter.indexFromPredicate(context, predicate);
            if (parent instanceof NullPropertyPointer) {
                parent.setIndex(index);
                continue;
            }
            parent = new NullElementPointer(parent, index);
        }
        return SimplePathInterpreter.createNullPointer(context, parent, steps, currentStep + 1);
    }

    private static NodePointer doPredicate(EvalContext context, NodePointer parent, Step[] steps, int currentStep, Expression[] predicates, int currentPredicate) {
        if (currentPredicate == predicates.length) {
            return SimplePathInterpreter.doStep(context, parent, steps, currentStep + 1);
        }
        Expression predicate = predicates[currentPredicate];
        if (predicate instanceof NameAttributeTest) {
            return SimplePathInterpreter.doPredicateName(context, parent, steps, currentStep, predicates, currentPredicate);
        }
        return SimplePathInterpreter.doPredicateIndex(context, parent, steps, currentStep, predicates, currentPredicate);
    }

    private static NodePointer doPredicateIndex(EvalContext context, NodePointer parent, Step[] steps, int currentStep, Expression[] predicates, int currentPredicate) {
        NodePointer pointer = parent;
        Expression predicate = predicates[currentPredicate];
        int index = SimplePathInterpreter.indexFromPredicate(context, predicate);
        if (SimplePathInterpreter.isCollectionElement(pointer, index)) {
            pointer = (NodePointer)pointer.clone();
            pointer.setIndex(index);
            return SimplePathInterpreter.doPredicate(context, pointer, steps, currentStep, predicates, currentPredicate + 1);
        }
        return SimplePathInterpreter.createNullPointerForPredicates(context, parent, steps, currentStep, predicates, currentPredicate);
    }

    private static NodePointer doPredicateName(EvalContext context, NodePointer parent, Step[] steps, int currentStep, Expression[] predicates, int currentPredicate) {
        Expression predicate = predicates[currentPredicate];
        String key = SimplePathInterpreter.keyFromPredicate(context, predicate);
        NodePointer child = SimplePathInterpreter.valuePointer(parent);
        if (child instanceof PropertyOwnerPointer) {
            PropertyPointer pointer = ((PropertyOwnerPointer)child).getPropertyPointer();
            pointer.setPropertyName(key);
            if (pointer.isActual()) {
                return SimplePathInterpreter.doPredicate(context, pointer, steps, currentStep, predicates, currentPredicate + 1);
            }
        } else if (child.isCollection()) {
            NodePointer bestMatch = null;
            int bestQuality = 0;
            child = (NodePointer)child.clone();
            int count = child.getLength();
            for (int i = 0; i < count; ++i) {
                child.setIndex(i);
                NodePointer valuePointer = SimplePathInterpreter.valuePointer(child);
                NodePointer pointer = valuePointer instanceof PropertyOwnerPointer || valuePointer.isCollection() ? SimplePathInterpreter.doPredicateName(context, valuePointer, steps, currentStep, predicates, currentPredicate) : (SimplePathInterpreter.isNameAttributeEqual(valuePointer, key) ? SimplePathInterpreter.doPredicate(context, valuePointer, steps, currentStep, predicates, currentPredicate + 1) : null);
                if (pointer == null) continue;
                int quality = SimplePathInterpreter.computeQuality(pointer);
                if (quality == 1000) {
                    return pointer;
                }
                if (quality <= bestQuality) continue;
                bestMatch = (NodePointer)pointer.clone();
                bestQuality = quality;
            }
            if (bestMatch != null) {
                return bestMatch;
            }
        } else {
            NodePointer found = SimplePathInterpreter.doPredicatesStandard(context, Collections.singletonList(child), steps, currentStep, predicates, currentPredicate);
            if (found != null) {
                return found;
            }
        }
        return SimplePathInterpreter.createNullPointerForPredicates(context, child, steps, currentStep, predicates, currentPredicate);
    }

    private static NodePointer doPredicatesStandard(EvalContext context, List<NodePointer> parents, Step[] steps, int currentStep, Expression[] predicates, int currentPredicate) {
        if (parents.isEmpty()) {
            return null;
        }
        if (currentPredicate == predicates.length) {
            NodePointer pointer = parents.get(0);
            return SimplePathInterpreter.doStep(context, pointer, steps, currentStep + 1);
        }
        Expression predicate = predicates[currentPredicate];
        if (predicate instanceof NameAttributeTest) {
            String key = SimplePathInterpreter.keyFromPredicate(context, predicate);
            ArrayList<NodePointer> newList = new ArrayList<NodePointer>();
            for (int i = 0; i < parents.size(); ++i) {
                NodePointer pointer = parents.get(i);
                if (!SimplePathInterpreter.isNameAttributeEqual(pointer, key)) continue;
                newList.add(pointer);
            }
            if (newList.isEmpty()) {
                return null;
            }
            return SimplePathInterpreter.doPredicatesStandard(context, newList, steps, currentStep, predicates, currentPredicate + 1);
        }
        int index = SimplePathInterpreter.indexFromPredicate(context, predicate);
        if (index < 0 || index >= parents.size()) {
            return null;
        }
        NodePointer ptr = parents.get(index);
        return SimplePathInterpreter.doPredicate(context, ptr, steps, currentStep, predicates, currentPredicate + 1);
    }

    private static NodePointer doStep(EvalContext context, NodePointer parent, Step[] steps, int currentStep) {
        if (parent == null) {
            return null;
        }
        if (currentStep == steps.length) {
            return parent;
        }
        parent = SimplePathInterpreter.valuePointer(parent);
        Step step = steps[currentStep];
        Expression[] predicates = step.getPredicates();
        if (parent instanceof PropertyOwnerPointer) {
            if (predicates == null || predicates.length == 0) {
                return SimplePathInterpreter.doStepNoPredicatesPropertyOwner(context, (PropertyOwnerPointer)parent, steps, currentStep);
            }
            return SimplePathInterpreter.doStepPredicatesPropertyOwner(context, (PropertyOwnerPointer)parent, steps, currentStep);
        }
        if (predicates == null || predicates.length == 0) {
            return SimplePathInterpreter.doStepNoPredicatesStandard(context, parent, steps, currentStep);
        }
        return SimplePathInterpreter.doStepPredicatesStandard(context, parent, steps, currentStep);
    }

    private static NodePointer doStepNoPredicatesPropertyOwner(EvalContext context, PropertyOwnerPointer parentPointer, Step[] steps, int currentStep) {
        Step step = steps[currentStep];
        NodePointer childPointer = SimplePathInterpreter.createChildPointerForStep(parentPointer, step);
        if (childPointer == null) {
            return null;
        }
        if (!childPointer.isActual()) {
            return SimplePathInterpreter.createNullPointer(context, parentPointer, steps, currentStep);
        }
        if (currentStep == steps.length - 1) {
            return childPointer;
        }
        if (childPointer.isCollection()) {
            int bestQuality = 0;
            childPointer = (NodePointer)childPointer.clone();
            NodePointer bestMatch = null;
            int count = childPointer.getLength();
            for (int i = 0; i < count; ++i) {
                childPointer.setIndex(i);
                NodePointer pointer = SimplePathInterpreter.doStep(context, childPointer, steps, currentStep + 1);
                int quality = SimplePathInterpreter.computeQuality(pointer);
                if (quality == 1000) {
                    return pointer;
                }
                if (quality <= bestQuality) continue;
                bestQuality = quality;
                bestMatch = (NodePointer)pointer.clone();
            }
            if (bestMatch != null) {
                return bestMatch;
            }
            return SimplePathInterpreter.createNullPointer(context, childPointer, steps, currentStep);
        }
        return SimplePathInterpreter.doStep(context, childPointer, steps, currentStep + 1);
    }

    private static NodePointer doStepNoPredicatesStandard(EvalContext context, NodePointer parentPointer, Step[] steps, int currentStep) {
        Step step = steps[currentStep];
        if (step.getAxis() == 1) {
            return SimplePathInterpreter.doStep(context, parentPointer, steps, currentStep + 1);
        }
        int bestQuality = 0;
        NodePointer bestMatch = null;
        NodeIterator it = SimplePathInterpreter.getNodeIterator(context, parentPointer, step);
        if (it != null) {
            int i = 1;
            while (it.setPosition(i)) {
                NodePointer childPointer = it.getNodePointer();
                if (steps.length == currentStep + 1) {
                    return childPointer;
                }
                NodePointer pointer = SimplePathInterpreter.doStep(context, childPointer, steps, currentStep + 1);
                int quality = SimplePathInterpreter.computeQuality(pointer);
                if (quality == 1000) {
                    return pointer;
                }
                if (quality > bestQuality) {
                    bestQuality = quality;
                    bestMatch = (NodePointer)pointer.clone();
                }
                ++i;
            }
        }
        return bestMatch != null ? bestMatch : SimplePathInterpreter.createNullPointer(context, parentPointer, steps, currentStep);
    }

    private static NodePointer doStepPredicatesPropertyOwner(EvalContext context, PropertyOwnerPointer parentPointer, Step[] steps, int currentStep) {
        Step step = steps[currentStep];
        Expression[] predicates = step.getPredicates();
        NodePointer childPointer = SimplePathInterpreter.createChildPointerForStep(parentPointer, step);
        if (!childPointer.isActual()) {
            return SimplePathInterpreter.createNullPointer(context, parentPointer, steps, currentStep);
        }
        return SimplePathInterpreter.doPredicate(context, childPointer, steps, currentStep, predicates, 0);
    }

    private static NodePointer doStepPredicatesStandard(EvalContext context, NodePointer parent, Step[] steps, int currentStep) {
        Step step = steps[currentStep];
        Expression[] predicates = step.getPredicates();
        int axis = step.getAxis();
        if (axis == 1) {
            return SimplePathInterpreter.doPredicate(context, parent, steps, currentStep, predicates, 0);
        }
        Expression predicate = predicates[0];
        if (predicates.length == 1) {
            NodeIterator it = SimplePathInterpreter.getNodeIterator(context, parent, step);
            NodePointer pointer = null;
            if (it != null) {
                if (predicate instanceof NameAttributeTest) {
                    String key = SimplePathInterpreter.keyFromPredicate(context, predicate);
                    int i = 1;
                    while (it.setPosition(i)) {
                        NodePointer ptr = it.getNodePointer();
                        if (SimplePathInterpreter.isNameAttributeEqual(ptr, key)) {
                            pointer = ptr;
                            break;
                        }
                        ++i;
                    }
                } else {
                    int index = SimplePathInterpreter.indexFromPredicate(context, predicate);
                    if (it.setPosition(index + 1)) {
                        pointer = it.getNodePointer();
                    }
                }
            }
            if (pointer != null) {
                return SimplePathInterpreter.doStep(context, pointer, steps, currentStep + 1);
            }
        } else {
            NodeIterator it = SimplePathInterpreter.getNodeIterator(context, parent, step);
            if (it != null) {
                ArrayList<NodePointer> list = new ArrayList<NodePointer>();
                int i = 1;
                while (it.setPosition(i)) {
                    list.add(it.getNodePointer());
                    ++i;
                }
                NodePointer pointer = SimplePathInterpreter.doPredicatesStandard(context, list, steps, currentStep, predicates, 0);
                if (pointer != null) {
                    return pointer;
                }
            }
        }
        return SimplePathInterpreter.createNullPointer(context, parent, steps, currentStep);
    }

    private static NodeIterator getNodeIterator(EvalContext context, NodePointer pointer, Step step) {
        if (step.getAxis() == 2) {
            NodeTest nodeTest = step.getNodeTest();
            QName qname = ((NodeNameTest)nodeTest).getNodeName();
            String prefix = qname.getPrefix();
            if (prefix != null) {
                String namespaceURI = context.getJXPathContext().getNamespaceURI(prefix);
                nodeTest = new NodeNameTest(qname, namespaceURI);
            }
            return pointer.childIterator(nodeTest, false, null);
        }
        if (!(step.getNodeTest() instanceof NodeNameTest)) {
            throw new UnsupportedOperationException("Not supported node test for attributes: " + step.getNodeTest());
        }
        return pointer.attributeIterator(((NodeNameTest)step.getNodeTest()).getNodeName());
    }

    private static int indexFromPredicate(EvalContext context, Expression predicate) {
        Object value = predicate.computeValue(context);
        if (value instanceof EvalContext) {
            value = ((EvalContext)value).getSingleNodePointer();
        }
        if (value instanceof NodePointer) {
            value = ((NodePointer)value).getValue();
        }
        if (value == null) {
            throw new JXPathException("Predicate value is null: " + predicate);
        }
        if (value instanceof Number) {
            double round = 0.5;
            return (int)(InfoSetUtil.doubleValue(value) + 0.5) - 1;
        }
        return InfoSetUtil.booleanValue(value) ? 0 : -1;
    }

    public static NodePointer interpretSimpleExpressionPath(EvalContext context, NodePointer root, Expression[] predicates, Step[] steps) {
        NodePointer pointer = SimplePathInterpreter.doPredicate(context, root, steps, -1, predicates, 0);
        return pointer;
    }

    public static NodePointer interpretSimpleLocationPath(EvalContext context, NodePointer root, Step[] steps) {
        NodePointer pointer = SimplePathInterpreter.doStep(context, root, steps, 0);
        return pointer;
    }

    private static boolean isCollectionElement(NodePointer pointer, int index) {
        return pointer.isActual() && (index == 0 || pointer.isCollection() && index >= 0 && index < pointer.getLength());
    }

    private static boolean isLangAttribute(QName qName) {
        return qName.getPrefix() != null && qName.getPrefix().equals("xml") && qName.getName().equals("lang");
    }

    private static boolean isNameAttributeEqual(NodePointer pointer, String name) {
        NodeIterator it = pointer.attributeIterator(QNAME_NAME);
        return it != null && it.setPosition(1) && name.equals(it.getNodePointer().getValue());
    }

    private static String keyFromPredicate(EvalContext context, Expression predicate) {
        Expression expr = ((NameAttributeTest)predicate).getNameTestExpression();
        return InfoSetUtil.stringValue(expr.computeValue(context));
    }

    private static NodePointer valuePointer(NodePointer pointer) {
        return pointer == null ? null : pointer.getValuePointer();
    }

    @Deprecated
    public SimplePathInterpreter() {
    }
}

