/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.generic;

import java.lang.reflect.Method;
import java.util.WeakHashMap;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.Filter;
import org.apache.commons.chain.generic.LookupCommand;

public class DispatchLookupCommand
extends LookupCommand
implements Filter {
    private static final Class[] DEFAULT_SIGNATURE = new Class[]{class$org$apache$commons$chain$Context == null ? (class$org$apache$commons$chain$Context = DispatchLookupCommand.class$("org.apache.commons.chain.Context")) : class$org$apache$commons$chain$Context};
    private WeakHashMap methods = new WeakHashMap();
    private String method = null;
    private String methodKey = null;
    static /* synthetic */ Class class$org$apache$commons$chain$Context;

    public DispatchLookupCommand() {
    }

    public DispatchLookupCommand(CatalogFactory factory) {
        super(factory);
    }

    public String getMethod() {
        return this.method;
    }

    public String getMethodKey() {
        return this.methodKey;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setMethodKey(String methodKey) {
        this.methodKey = methodKey;
    }

    public boolean execute(Context context) throws Exception {
        if (this.getMethod() == null && this.getMethodKey() == null) {
            throw new IllegalStateException("Neither 'method' nor 'methodKey' properties are defined ");
        }
        Command command = this.getCommand(context);
        if (command != null) {
            Method methodObject = this.extractMethod(command, context);
            Object obj = methodObject.invoke((Object)command, this.getArguments(context));
            Boolean result = (Boolean)obj;
            return result != null && result != false;
        }
        return false;
    }

    protected Class[] getSignature() {
        return DEFAULT_SIGNATURE;
    }

    protected Object[] getArguments(Context context) {
        return new Object[]{context};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method extractMethod(Command command, Context context) throws NoSuchMethodException {
        String methodName = this.getMethod();
        if (methodName == null) {
            Object methodContextObj = context.get(this.getMethodKey());
            if (methodContextObj == null) {
                throw new NullPointerException("No value found in context under " + this.getMethodKey());
            }
            methodName = methodContextObj.toString();
        }
        Method theMethod = null;
        WeakHashMap weakHashMap = this.methods;
        synchronized (weakHashMap) {
            theMethod = (Method)this.methods.get(methodName);
            if (theMethod == null) {
                theMethod = command.getClass().getMethod(methodName, this.getSignature());
                this.methods.put(methodName, theMethod);
            }
        }
        return theMethod;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

