/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles.filter;

import java.io.File;
import java.io.FileFilter;
import org.apache.creadur.tentacles.filter.AndFilter;
import org.apache.creadur.tentacles.filter.DeclaredFilter;
import org.apache.creadur.tentacles.filter.FilesOnlyFilter;
import org.apache.creadur.tentacles.filter.IsArchiveInPathFilter;
import org.apache.creadur.tentacles.filter.LegalFilter;
import org.apache.creadur.tentacles.filter.LicenseFilter;
import org.apache.creadur.tentacles.filter.NotFilter;
import org.apache.creadur.tentacles.filter.NoticeFilter;

public class Filters {
    private final FilesOnlyFilter filesOnly = new FilesOnlyFilter();
    private final LicenseFilter licensesOnly = new LicenseFilter();
    private final NoticeFilter noticesOnly = new NoticeFilter();
    private final LegalFilter legalOnly = new LegalFilter();

    public FileFilter filesOnly() {
        return this.filesOnly;
    }

    public FileFilter licensesOnly() {
        return this.licensesOnly;
    }

    public FileFilter noticesOnly() {
        return this.noticesOnly;
    }

    public FileFilter legalOnly() {
        return this.legalOnly;
    }

    public FileFilter licensesDeclaredIn(File contents) {
        return new AndFilter(new DeclaredFilter(contents), new LicenseFilter());
    }

    public FileFilter noticesDeclaredIn(File contents) {
        return new AndFilter(new DeclaredFilter(contents), new NoticeFilter());
    }

    public FileFilter legalDocumentsUndeclaredIn(File contents) {
        return new AndFilter(new NotFilter(new DeclaredFilter(contents)), new LegalFilter());
    }

    public FileFilter legalDocumentsDeclaredIn(File contents) {
        return new AndFilter(new DeclaredFilter(contents), new LegalFilter());
    }

    public FileFilter archivesInPath(String repositoryPathNameFilter) {
        return new IsArchiveInPathFilter(repositoryPathNameFilter);
    }
}

