/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Properties;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.logging.SystemStreamLog;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.manager.MacroManager;
import org.apache.maven.doxia.macro.manager.MacroNotFoundException;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Requirement;

public abstract class AbstractParser
implements Parser {
    private boolean secondParsing = false;
    @Requirement
    private MacroManager macroManager;
    private Log logger;
    private static final String DOXIA_VERSION;

    public int getType() {
        return 0;
    }

    public void executeMacro(String macroId, MacroRequest request, Sink sink) throws MacroExecutionException, MacroNotFoundException {
        Macro macro = this.getMacroManager().getMacro(macroId);
        macro.enableLogging(this.getLog());
        macro.execute(sink, request);
    }

    protected File getBasedir() {
        String basedir = System.getProperty("basedir");
        if (basedir != null) {
            return new File(basedir);
        }
        return new File(new File("").getAbsolutePath());
    }

    public void parse(String string, Sink sink) throws ParseException {
        this.parse(new StringReader(string), sink);
    }

    public void setSecondParsing(boolean second) {
        this.secondParsing = second;
    }

    protected boolean isSecondParsing() {
        return this.secondParsing;
    }

    public void enableLogging(Log log) {
        this.logger = log;
    }

    protected Log getLog() {
        if (this.logger == null) {
            this.logger = new SystemStreamLog();
        }
        return this.logger;
    }

    protected MacroManager getMacroManager() {
        return this.macroManager;
    }

    protected void init() {
    }

    protected static String doxiaVersion() {
        return DOXIA_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties props = new Properties();
        InputStream is = AbstractParser.class.getResourceAsStream("/build-info.properties");
        if (is == null) {
            props.setProperty("version", "unknown");
        } else {
            try {
                props.load(is);
            }
            catch (IOException ex) {
                props.setProperty("version", "unknown");
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        DOXIA_VERSION = props.getProperty("version");
    }
}

