/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.rat.config.SourceCodeManagementSystems;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExclusionHelper {
    static final List<String> MAVEN_DEFAULT_EXCLUDES = Collections.unmodifiableList(Arrays.asList("target/**/*", "cobertura.ser", "release.properties", ".repository", "build.log", ".mvn", "pom.xml.releaseBackup"));
    static final List<String> ECLIPSE_DEFAULT_EXCLUDES = Collections.unmodifiableList(Arrays.asList(".checkstyle", ".classpath", ".project", ".settings/**/*"));
    static final List<String> IDEA_DEFAULT_EXCLUDES = Collections.unmodifiableList(Arrays.asList("*.iml", "*.ipr", "*.iws", ".idea/**/*"));

    public static void addPlexusAndScmDefaults(Log log, boolean useDefaultExcludes, Set<String> excludeList1) {
        if (useDefaultExcludes) {
            log.debug("Adding plexus default exclusions...");
            Collections.addAll(excludeList1, DirectoryScanner.DEFAULTEXCLUDES);
            log.debug("Adding SCM default exclusions...");
            excludeList1.addAll(SourceCodeManagementSystems.getPluginExclusions());
        } else {
            log.debug("rat.useDefaultExcludes set to false. Plexus and SCM default exclusions will not be added");
        }
    }

    public static void addMavenDefaults(Log log, boolean useMavenDefaultExcludes, Set<String> excludeList) {
        if (useMavenDefaultExcludes) {
            log.debug("Adding exclusions often needed by Maven projects...");
            excludeList.addAll(MAVEN_DEFAULT_EXCLUDES);
        } else {
            log.debug("rat.useMavenDefaultExcludes set to false. Exclusions often needed by Maven projects will not be added.");
        }
    }

    public static void addEclipseDefaults(Log log, boolean useEclipseDefaultExcludes, Set<String> excludeList) {
        if (useEclipseDefaultExcludes) {
            log.debug("Adding exclusions often needed by projects developed in Eclipse...");
            excludeList.addAll(ECLIPSE_DEFAULT_EXCLUDES);
        } else {
            log.debug("rat.useEclipseDefaultExcludes set to false. Exclusions often needed by projects developed in Eclipse will not be added.");
        }
    }

    public static void addIdeaDefaults(Log log, boolean useIdeaDefaultExcludes, Set<String> excludeList) {
        if (useIdeaDefaultExcludes) {
            log.debug("Adding exclusions often needed by projects developed in IDEA...");
            excludeList.addAll(IDEA_DEFAULT_EXCLUDES);
        } else {
            log.debug("rat.useIdeaDefaultExcludes set to false. Exclusions often needed by projects developed in IDEA will not be added.");
        }
    }
}

