/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.io.ElementStack;

class PruningElementStack
extends ElementStack {
    private ElementHandler elementHandler;
    private String[] path;
    private int matchingElementIndex;

    public PruningElementStack(String[] path, ElementHandler elementHandler) {
        this.path = path;
        this.elementHandler = elementHandler;
        this.checkPath();
    }

    public PruningElementStack(String[] path, ElementHandler elementHandler, int defaultCapacity) {
        super(defaultCapacity);
        this.path = path;
        this.elementHandler = elementHandler;
        this.checkPath();
    }

    private void checkPath() {
        if (this.path.length < 2) {
            throw new RuntimeException("Invalid path of length: " + this.path.length + " it must be greater than 2");
        }
        this.matchingElementIndex = this.path.length - 2;
    }

    protected void pathMatches(Element parent, Element selectedNode) {
        this.elementHandler.onEnd(this);
        parent.remove(selectedNode);
    }

    public Element popElement() {
        Element answer = super.popElement();
        if (this.lastElementIndex == this.matchingElementIndex && this.lastElementIndex >= 0 && this.validElement(answer, this.lastElementIndex + 1)) {
            Element parent = null;
            int i = 0;
            while (i <= this.lastElementIndex) {
                parent = this.stack[i];
                if (!this.validElement(parent, i)) {
                    parent = null;
                    break;
                }
                ++i;
            }
            if (parent != null) {
                this.pathMatches(parent, answer);
            }
        }
        return answer;
    }

    protected boolean validElement(Element element, int index) {
        String requiredName = this.path[index];
        String name = element.getName();
        if (requiredName == name) {
            return true;
        }
        if (requiredName != null && name != null) {
            return requiredName.equals(name);
        }
        return false;
    }
}

