/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.basicconfig.RateLimitConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class RateLimitConfigImpl
implements RateLimitConfig {
    private final String description;
    private final String configKey;
    private final RateLimit instance;
    private Integer _value;
    private Long _window;
    private ChronoUnit _windowUnit;
    private Long _minSpacing;
    private ChronoUnit _minSpacingUnit;
    private RateLimitType _type;

    private RateLimitConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(RateLimit.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.rateLimit;
    }

    private RateLimitConfigImpl(String id, RateLimit instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static RateLimitConfigImpl create(FaultToleranceMethod method) {
        if (method.rateLimit == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("rate-limit.enabled", "RateLimit/enabled", method.method)) {
            return null;
        }
        return new RateLimitConfigImpl(method);
    }

    public static RateLimitConfigImpl create(String id, Supplier<RateLimit> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("rate-limit.enabled", "RateLimit/enabled", id)) {
            return null;
        }
        return new RateLimitConfigImpl(id, supplier.get());
    }

    public Class<? extends Annotation> annotationType() {
        return RateLimit.class;
    }

    public int value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.value";
            Object oldKey = this.configKey + "/RateLimit/value";
            this._value = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> RateLimitConfigImpl.lambda$value$0(config, (String)oldKey)).orElse(null);
            if (this._value == null) {
                newKey = "smallrye.faulttolerance.global.rate-limit.value";
                oldKey = "RateLimit/value";
                this._value = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> RateLimitConfigImpl.lambda$value$1(config, (String)oldKey)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public long window() {
        if (this._window == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.window";
            Object oldKey = this.configKey + "/RateLimit/window";
            this._window = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> RateLimitConfigImpl.lambda$window$2(config, (String)oldKey)).orElse(null);
            if (this._window == null) {
                newKey = "smallrye.faulttolerance.global.rate-limit.window";
                oldKey = "RateLimit/window";
                this._window = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> RateLimitConfigImpl.lambda$window$3(config, (String)oldKey)).orElse(null);
            }
            if (this._window == null) {
                this._window = this.instance.window();
            }
        }
        return this._window;
    }

    public ChronoUnit windowUnit() {
        if (this._windowUnit == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.window-unit";
            Object oldKey = this.configKey + "/RateLimit/windowUnit";
            this._windowUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> RateLimitConfigImpl.lambda$windowUnit$4(config, (String)oldKey)).orElse(null);
            if (this._windowUnit == null) {
                newKey = "smallrye.faulttolerance.global.rate-limit.window-unit";
                oldKey = "RateLimit/windowUnit";
                this._windowUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> RateLimitConfigImpl.lambda$windowUnit$5(config, (String)oldKey)).orElse(null);
            }
            if (this._windowUnit == null) {
                this._windowUnit = this.instance.windowUnit();
            }
        }
        return this._windowUnit;
    }

    public long minSpacing() {
        if (this._minSpacing == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.min-spacing";
            Object oldKey = this.configKey + "/RateLimit/minSpacing";
            this._minSpacing = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> RateLimitConfigImpl.lambda$minSpacing$6(config, (String)oldKey)).orElse(null);
            if (this._minSpacing == null) {
                newKey = "smallrye.faulttolerance.global.rate-limit.min-spacing";
                oldKey = "RateLimit/minSpacing";
                this._minSpacing = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> RateLimitConfigImpl.lambda$minSpacing$7(config, (String)oldKey)).orElse(null);
            }
            if (this._minSpacing == null) {
                this._minSpacing = this.instance.minSpacing();
            }
        }
        return this._minSpacing;
    }

    public ChronoUnit minSpacingUnit() {
        if (this._minSpacingUnit == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.min-spacing-unit";
            Object oldKey = this.configKey + "/RateLimit/minSpacingUnit";
            this._minSpacingUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> RateLimitConfigImpl.lambda$minSpacingUnit$8(config, (String)oldKey)).orElse(null);
            if (this._minSpacingUnit == null) {
                newKey = "smallrye.faulttolerance.global.rate-limit.min-spacing-unit";
                oldKey = "RateLimit/minSpacingUnit";
                this._minSpacingUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> RateLimitConfigImpl.lambda$minSpacingUnit$9(config, (String)oldKey)).orElse(null);
            }
            if (this._minSpacingUnit == null) {
                this._minSpacingUnit = this.instance.minSpacingUnit();
            }
        }
        return this._minSpacingUnit;
    }

    public RateLimitType type() {
        if (this._type == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.type";
            Object oldKey = this.configKey + "/RateLimit/type";
            this._type = config.getOptionalValue((String)newKey, RateLimitType.class).or(() -> RateLimitConfigImpl.lambda$type$10(config, (String)oldKey)).orElse(null);
            if (this._type == null) {
                newKey = "smallrye.faulttolerance.global.rate-limit.type";
                oldKey = "RateLimit/type";
                this._type = config.getOptionalValue((String)newKey, RateLimitType.class).or(() -> RateLimitConfigImpl.lambda$type$11(config, (String)oldKey)).orElse(null);
            }
            if (this._type == null) {
                this._type = this.instance.type();
            }
        }
        return this._type;
    }

    public void materialize() {
        this.value();
        this.window();
        this.windowUnit();
        this.minSpacing();
        this.minSpacingUnit();
        this.type();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @RateLimit on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @RateLimit." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$type$11(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, RateLimitType.class);
    }

    private static /* synthetic */ Optional lambda$type$10(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, RateLimitType.class);
    }

    private static /* synthetic */ Optional lambda$minSpacingUnit$9(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$minSpacingUnit$8(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$minSpacing$7(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$minSpacing$6(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$windowUnit$5(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$windowUnit$4(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$window$3(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$window$2(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$value$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }

    private static /* synthetic */ Optional lambda$value$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }
}

