/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDefaultDiagServiceImpl;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PrincipalSecretsGenerator;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;
import org.apache.polaris.core.persistence.cache.EntityCache;
import org.apache.polaris.core.persistence.cache.InMemoryEntityCache;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import org.apache.polaris.core.persistence.transactional.TransactionalMetaStoreManagerImpl;
import org.apache.polaris.core.persistence.transactional.TransactionalPersistence;
import org.apache.polaris.core.storage.cache.StorageCredentialCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalPolarisMetaStoreManagerFactory<StoreType>
implements MetaStoreManagerFactory {
    final Map<String, PolarisMetaStoreManager> metaStoreManagerMap = new HashMap<String, PolarisMetaStoreManager>();
    final Map<String, StorageCredentialCache> storageCredentialCacheMap = new HashMap<String, StorageCredentialCache>();
    final Map<String, EntityCache> entityCacheMap = new HashMap<String, EntityCache>();
    final Map<String, StoreType> backingStoreMap = new HashMap<String, StoreType>();
    final Map<String, Supplier<TransactionalPersistence>> sessionSupplierMap = new HashMap<String, Supplier<TransactionalPersistence>>();
    protected final PolarisDiagnostics diagServices = new PolarisDefaultDiagServiceImpl();
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalPolarisMetaStoreManagerFactory.class);
    private final PolarisDiagnostics diagnostics;
    private boolean bootstrap;

    protected LocalPolarisMetaStoreManagerFactory(@Nonnull PolarisDiagnostics diagnostics) {
        this.diagnostics = diagnostics;
    }

    protected abstract StoreType createBackingStore(@Nonnull PolarisDiagnostics var1);

    protected abstract TransactionalPersistence createMetaStoreSession(@Nonnull StoreType var1, @Nonnull RealmContext var2, @Nullable RootCredentialsSet var3, @Nonnull PolarisDiagnostics var4);

    protected PrincipalSecretsGenerator secretsGenerator(RealmContext realmContext, @Nullable RootCredentialsSet rootCredentialsSet) {
        if (rootCredentialsSet != null) {
            return PrincipalSecretsGenerator.bootstrap(realmContext.getRealmIdentifier(), rootCredentialsSet);
        }
        return PrincipalSecretsGenerator.RANDOM_SECRETS;
    }

    protected PolarisMetaStoreManager createNewMetaStoreManager() {
        return new TransactionalMetaStoreManagerImpl();
    }

    private void initializeForRealm(RealmContext realmContext, RootCredentialsSet rootCredentialsSet) {
        StoreType backingStore = this.createBackingStore(this.diagnostics);
        this.sessionSupplierMap.put(realmContext.getRealmIdentifier(), () -> this.createMetaStoreSession(backingStore, realmContext, rootCredentialsSet, this.diagnostics));
        PolarisMetaStoreManager metaStoreManager = this.createNewMetaStoreManager();
        this.metaStoreManagerMap.put(realmContext.getRealmIdentifier(), metaStoreManager);
    }

    @Override
    public synchronized Map<String, PrincipalSecretsResult> bootstrapRealms(Iterable<String> realms, RootCredentialsSet rootCredentialsSet) {
        HashMap<String, PrincipalSecretsResult> results = new HashMap<String, PrincipalSecretsResult>();
        for (String realm : realms) {
            RealmContext realmContext = () -> realm;
            if (this.metaStoreManagerMap.containsKey(realm)) continue;
            this.initializeForRealm(realmContext, rootCredentialsSet);
            PrincipalSecretsResult secretsResult = this.bootstrapServiceAndCreatePolarisPrincipalForRealm(realmContext, this.metaStoreManagerMap.get(realm));
            results.put(realm, secretsResult);
        }
        return Map.copyOf(results);
    }

    @Override
    public Map<String, BaseResult> purgeRealms(Iterable<String> realms) {
        HashMap<String, BaseResult> results = new HashMap<String, BaseResult>();
        for (String realm : realms) {
            RealmContext realmContext = () -> realm;
            PolarisMetaStoreManager metaStoreManager = this.getOrCreateMetaStoreManager(realmContext);
            TransactionalPersistence session = this.getOrCreateSessionSupplier(realmContext).get();
            PolarisCallContext callContext = new PolarisCallContext(realmContext, session, this.diagServices);
            BaseResult result = metaStoreManager.purge(callContext);
            results.put(realm, result);
            this.storageCredentialCacheMap.remove(realm);
            this.backingStoreMap.remove(realm);
            this.sessionSupplierMap.remove(realm);
            this.metaStoreManagerMap.remove(realm);
        }
        return Map.copyOf(results);
    }

    @Override
    public synchronized PolarisMetaStoreManager getOrCreateMetaStoreManager(RealmContext realmContext) {
        if (!this.metaStoreManagerMap.containsKey(realmContext.getRealmIdentifier())) {
            this.initializeForRealm(realmContext, null);
            this.checkPolarisServiceBootstrappedForRealm(realmContext, this.metaStoreManagerMap.get(realmContext.getRealmIdentifier()));
        }
        return this.metaStoreManagerMap.get(realmContext.getRealmIdentifier());
    }

    public synchronized Supplier<TransactionalPersistence> getOrCreateSessionSupplier(RealmContext realmContext) {
        if (!this.sessionSupplierMap.containsKey(realmContext.getRealmIdentifier())) {
            this.initializeForRealm(realmContext, null);
            this.checkPolarisServiceBootstrappedForRealm(realmContext, this.metaStoreManagerMap.get(realmContext.getRealmIdentifier()));
        } else {
            this.checkPolarisServiceBootstrappedForRealm(realmContext, this.metaStoreManagerMap.get(realmContext.getRealmIdentifier()));
        }
        return this.sessionSupplierMap.get(realmContext.getRealmIdentifier());
    }

    @Override
    public synchronized StorageCredentialCache getOrCreateStorageCredentialCache(RealmContext realmContext) {
        if (!this.storageCredentialCacheMap.containsKey(realmContext.getRealmIdentifier())) {
            this.storageCredentialCacheMap.put(realmContext.getRealmIdentifier(), new StorageCredentialCache());
        }
        return this.storageCredentialCacheMap.get(realmContext.getRealmIdentifier());
    }

    @Override
    public synchronized EntityCache getOrCreateEntityCache(RealmContext realmContext) {
        if (!this.entityCacheMap.containsKey(realmContext.getRealmIdentifier())) {
            PolarisMetaStoreManager metaStoreManager = this.getOrCreateMetaStoreManager(realmContext);
            this.entityCacheMap.put(realmContext.getRealmIdentifier(), new InMemoryEntityCache(metaStoreManager));
        }
        return this.entityCacheMap.get(realmContext.getRealmIdentifier());
    }

    private PrincipalSecretsResult bootstrapServiceAndCreatePolarisPrincipalForRealm(RealmContext realmContext, PolarisMetaStoreManager metaStoreManager) {
        EntityResult preliminaryRootPrincipalLookup;
        PolarisCallContext polarisContext = new PolarisCallContext(realmContext, this.sessionSupplierMap.get(realmContext.getRealmIdentifier()).get(), this.diagServices);
        if (CallContext.getCurrentContext() == null) {
            CallContext.setCurrentContext(polarisContext);
        }
        if ((preliminaryRootPrincipalLookup = metaStoreManager.readEntityByName(polarisContext, null, PolarisEntityType.PRINCIPAL, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootPrincipalName())).isSuccess()) {
            String overrideMessage = "It appears this metastore manager has already been bootstrapped. To continue bootstrapping, please first purge the metastore with the `purge` command.";
            LOGGER.error("\n\n {} \n\n", (Object)overrideMessage);
            throw new IllegalArgumentException(overrideMessage);
        }
        metaStoreManager.bootstrapPolarisService(polarisContext);
        EntityResult rootPrincipalLookup = metaStoreManager.readEntityByName(polarisContext, null, PolarisEntityType.PRINCIPAL, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootPrincipalName());
        return metaStoreManager.loadPrincipalSecrets(polarisContext, PolarisEntity.of(rootPrincipalLookup.getEntity()).getInternalPropertiesAsMap().get(PolarisEntityConstants.getClientIdPropertyName()));
    }

    private void checkPolarisServiceBootstrappedForRealm(RealmContext realmContext, PolarisMetaStoreManager metaStoreManager) {
        EntityResult rootPrincipalLookup;
        PolarisCallContext polarisContext = new PolarisCallContext(realmContext, this.sessionSupplierMap.get(realmContext.getRealmIdentifier()).get(), this.diagServices);
        if (CallContext.getCurrentContext() == null) {
            CallContext.setCurrentContext(polarisContext);
        }
        if (!(rootPrincipalLookup = metaStoreManager.readEntityByName(polarisContext, null, PolarisEntityType.PRINCIPAL, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootPrincipalName())).isSuccess()) {
            LOGGER.error("\n\n Realm {} is not bootstrapped, could not load root principal. Please run Bootstrap command. \n\n", (Object)realmContext.getRealmIdentifier());
            throw new IllegalStateException("Realm is not bootstrapped, please run server in bootstrap mode.");
        }
    }
}

