/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.schema;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaTool {
    protected static String host;
    protected static String port;
    protected static String table;
    protected static String database;
    protected static String username;
    protected static String password;
    protected static Session session;
    protected static String queryPath;
    protected static int threadNum;
    protected static String targetPath;
    protected static Boolean sqlDialectTree;
    protected static long timeout;
    protected static String targetDirectory;
    protected static Boolean aligned;
    protected static int linesPerFile;
    protected static String failedFileDirectory;
    protected static int batchPointSize;
    protected static int linesPerFailedFile;
    protected static String targetFile;
    protected static final LongAdder loadFileSuccessfulNum;
    private static final IoTPrinter ioTPrinter;
    private static final Logger LOGGER;

    protected AbstractSchemaTool() {
    }

    protected static String checkRequiredArg(String arg, String name, CommandLine commandLine, String defaultValue) throws ArgsErrorException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                return defaultValue;
            }
            String msg = String.format("Required values for option '%s' not provided", name);
            throw new ArgsErrorException(msg);
        }
        return str;
    }

    protected static void parseBasicParams(CommandLine commandLine) throws ArgsErrorException {
        host = AbstractSchemaTool.checkRequiredArg("h", "host", commandLine, "127.0.0.1");
        port = AbstractSchemaTool.checkRequiredArg("p", "port", commandLine, "6667");
        username = AbstractSchemaTool.checkRequiredArg("u", "username", commandLine, "root");
        password = AbstractSchemaTool.checkRequiredArg("pw", "password", commandLine, "root");
    }

    public static Boolean writeCsvFile(List<List<Object>> records, String filePath) {
        try {
            CSVPrinterWrapper csvPrinterWrapper = new CSVPrinterWrapper(filePath);
            for (List<Object> CsvRecord : records) {
                csvPrinterWrapper.printRecordLn(CsvRecord);
            }
            csvPrinterWrapper.flush();
            csvPrinterWrapper.close();
            return true;
        }
        catch (IOException e) {
            ioTPrinter.printException(e);
            return false;
        }
    }

    static {
        threadNum = 8;
        sqlDialectTree = true;
        timeout = 60000L;
        aligned = false;
        linesPerFile = 10000;
        failedFileDirectory = null;
        batchPointSize = 10000;
        linesPerFailedFile = 10000;
        targetFile = "dump";
        loadFileSuccessfulNum = new LongAdder();
        ioTPrinter = new IoTPrinter(System.out);
        LOGGER = LoggerFactory.getLogger(AbstractSchemaTool.class);
    }

    static class CSVPrinterWrapper {
        private final String filePath;
        private final CSVFormat csvFormat;
        private CSVPrinter csvPrinter;

        public CSVPrinterWrapper(String filePath) {
            this.filePath = filePath;
            this.csvFormat = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).setSkipHeaderRecord(true).setEscape('\\').setQuoteMode(QuoteMode.NONE).build();
        }

        public void printRecord(Iterable<?> values) throws IOException {
            if (this.csvPrinter == null) {
                this.csvPrinter = this.csvFormat.print((Appendable)new PrintWriter(this.filePath));
            }
            this.csvPrinter.printRecord(values);
        }

        public void printRecordLn(Iterable<?> values) throws IOException {
            if (this.csvPrinter == null) {
                this.csvPrinter = this.csvFormat.print((Appendable)new PrintWriter(this.filePath));
            }
            for (Object value : values) {
                this.csvPrinter.print(value);
            }
            this.csvPrinter.println();
        }

        public void print(Object value) {
            if (this.csvPrinter == null) {
                try {
                    this.csvPrinter = this.csvFormat.print((Appendable)new PrintWriter(this.filePath));
                }
                catch (IOException e) {
                    ioTPrinter.printException(e);
                    return;
                }
            }
            try {
                this.csvPrinter.print(value);
            }
            catch (IOException e) {
                ioTPrinter.printException(e);
            }
        }

        public void println() throws IOException {
            this.csvPrinter.println();
        }

        public void close() throws IOException {
            if (this.csvPrinter != null) {
                this.csvPrinter.close();
            }
        }

        public void flush() throws IOException {
            if (this.csvPrinter != null) {
                this.csvPrinter.flush();
            }
        }
    }
}

