/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.utils.matching.pattern;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Match;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.PatternVisitor;

public class FilterPattern<T>
extends Pattern<T> {
    private final BiPredicate<? super T, ?> predicate;

    public FilterPattern(BiPredicate<? super T, ?> predicate, Optional<Pattern<?>> previous) {
        super(previous);
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    public BiPredicate<? super T, ?> predicate() {
        return this.predicate;
    }

    @Override
    public <C> Stream<Match> accept(Object object, Captures captures, C context) {
        BiPredicate predicate = this.predicate;
        return Stream.of(Match.of(captures)).filter(match -> predicate.test(object, context));
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitFilter(this);
    }
}

