/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.BindException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.rmi.server.RMIServerSocketFactory;
import java.security.GeneralSecurityException;
import java.security.Security;
import java.util.Enumeration;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.karaf.jaas.config.KeystoreManager;
import org.apache.karaf.management.KarafMBeanServerGuard;
import org.apache.karaf.management.PlainSaslServer;
import org.apache.karaf.management.internal.MBeanInvocationHandler;

public class ConnectorServerFactory {
    private MBeanServer server;
    private KarafMBeanServerGuard guard;
    private String serviceUrl;
    private boolean jmxmpEnabled;
    private String jmxmpServiceUrl;
    private String rmiServerHost;
    private Map<String, Object> environment;
    private Map<String, Object> jmxmpEnvironment;
    private ObjectName objectName;
    private ObjectName jmxmpObjectName;
    private boolean threaded = false;
    private boolean daemon = false;
    private JMXConnectorServer connectorServer;
    private JMXConnectorServer jmxmpConnectorServer;
    private long keyStoreAvailabilityTimeout = 5000L;
    private AuthenticatorType authenticatorType = AuthenticatorType.PASSWORD;
    private boolean secured;
    private KeystoreManager keystoreManager;
    private String algorithm;
    private String secureProtocol;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;
    private String keyStore;
    private String trustStore;
    private String keyAlias;

    public MBeanServer getServer() {
        return this.server;
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public KarafMBeanServerGuard getGuard() {
        return this.guard;
    }

    public void setGuard(KarafMBeanServerGuard guard) {
        this.guard = guard;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public boolean isJmxmpEnabled() {
        return this.jmxmpEnabled;
    }

    public void setJmxmpEnabled(boolean jmxmpEnabled) {
        this.jmxmpEnabled = jmxmpEnabled;
    }

    public String getJmxmpServiceUrl() {
        return this.jmxmpServiceUrl;
    }

    public void setJmxmpServiceUrl(String jmxmpServiceUrl) {
        this.jmxmpServiceUrl = jmxmpServiceUrl;
    }

    public String getRmiServerHost() {
        return this.rmiServerHost;
    }

    public void setRmiServerHost(String rmiServerHost) {
        this.rmiServerHost = rmiServerHost;
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, Object> environment) {
        this.environment = environment;
    }

    public Map<String, Object> getJmxmpEnvironment() {
        return this.jmxmpEnvironment;
    }

    public void setJmxmpEnvironment(Map<String, Object> jmxmpEnvironment) {
        this.jmxmpEnvironment = jmxmpEnvironment;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public ObjectName getJmxmpObjectName() {
        return this.jmxmpObjectName;
    }

    public void setJmxmpObjectName(ObjectName jmxmpObjectName) {
        this.jmxmpObjectName = jmxmpObjectName;
    }

    public boolean isThreaded() {
        return this.threaded;
    }

    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public String getAuthenticatorType() {
        return this.authenticatorType.name().toLowerCase();
    }

    public void setAuthenticatorType(String value) {
        this.authenticatorType = AuthenticatorType.valueOf(value.toUpperCase());
    }

    public void setKeyStoreAvailabilityTimeout(long keyStoreAvailabilityTimeout) {
        this.keyStoreAvailabilityTimeout = keyStoreAvailabilityTimeout;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public void setKeystoreManager(KeystoreManager keystoreManager) {
        this.keystoreManager = keystoreManager;
    }

    public KeystoreManager getKeystoreManager() {
        return this.keystoreManager;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = "default".equalsIgnoreCase(algorithm) ? KeyManagerFactory.getDefaultAlgorithm() : algorithm;
    }

    public String getSecureProtocol() {
        return this.secureProtocol;
    }

    public void setSecureProtocol(String secureProtocol) {
        this.secureProtocol = secureProtocol;
    }

    private boolean isClientAuth() {
        return this.authenticatorType.equals((Object)AuthenticatorType.CERTIFICATE);
    }

    public void init() throws Exception {
        if (this.server == null) {
            throw new IllegalArgumentException("server must be set");
        }
        JMXServiceURL url = new JMXServiceURL(this.serviceUrl);
        if (this.isClientAuth()) {
            this.secured = true;
        }
        if (this.secured) {
            this.setupSsl();
        } else {
            this.setupKarafRMIServerSocketFactory();
        }
        if (!AuthenticatorType.PASSWORD.equals((Object)this.authenticatorType)) {
            this.environment.remove("jmx.remote.authenticator");
        }
        MBeanInvocationHandler handler = new MBeanInvocationHandler(this.server, this.guard);
        MBeanServer guardedServer = (MBeanServer)Proxy.newProxyInstance(this.server.getClass().getClassLoader(), new Class[]{MBeanServer.class}, (InvocationHandler)handler);
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.environment, guardedServer);
        if (this.objectName != null) {
            this.server.registerMBean(this.connectorServer, this.objectName);
        }
        if (this.jmxmpEnabled) {
            Security.addProvider(new PlainSaslServer.SaslPlainProvider());
            JMXServiceURL jmxmpUrl = new JMXServiceURL(this.jmxmpServiceUrl);
            this.jmxmpConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jmxmpUrl, this.jmxmpEnvironment, guardedServer);
            if (this.jmxmpObjectName != null) {
                this.server.registerMBean(this.jmxmpConnectorServer, this.jmxmpObjectName);
            }
        }
        try {
            if (this.threaded) {
                Thread connectorThread = new Thread(() -> {
                    try {
                        Thread.currentThread().setContextClassLoader(ConnectorServerFactory.class.getClassLoader());
                        this.connectorServer.start();
                        if (this.jmxmpEnabled && this.jmxmpConnectorServer != null) {
                            this.jmxmpConnectorServer.start();
                        }
                    }
                    catch (IOException ex) {
                        if (ex.getCause() instanceof BindException) {
                            int endIndex = ex.getMessage().indexOf("nested exception is");
                            if (endIndex > ex.getMessage().length() || endIndex < 0) {
                                endIndex = ex.getMessage().length();
                            }
                            throw new RuntimeException("\n" + ex.getMessage().substring(0, endIndex) + "\nYou may have started two containers.  If you need to start a second container or the default ports are already in use update the config file etc/org.apache.karaf.management.cfg and change the Registry Port and Server Port to unused ports");
                        }
                        throw new RuntimeException("Could not start JMX connector server", ex);
                    }
                });
                connectorThread.setName("JMX Connector Thread [" + this.serviceUrl + "]");
                connectorThread.setDaemon(this.daemon);
                connectorThread.start();
            } else {
                this.connectorServer.start();
                if (this.jmxmpEnabled && this.jmxmpConnectorServer != null) {
                    this.jmxmpConnectorServer.start();
                }
            }
        }
        catch (Exception ex) {
            if (this.objectName != null) {
                this.doUnregister(this.objectName);
            }
            if (this.jmxmpEnabled && this.jmxmpObjectName != null) {
                this.doUnregister(this.jmxmpObjectName);
            }
            throw ex;
        }
    }

    public void destroy() throws Exception {
        try {
            if (this.connectorServer != null) {
                this.connectorServer.stop();
            }
            if (this.jmxmpEnabled && this.jmxmpConnectorServer != null) {
                this.jmxmpConnectorServer.stop();
            }
        }
        finally {
            if (this.objectName != null) {
                this.doUnregister(this.objectName);
            }
            if (this.jmxmpEnabled && this.jmxmpObjectName != null) {
                this.doUnregister(this.jmxmpObjectName);
            }
        }
    }

    protected void doUnregister(ObjectName objectName) {
        try {
            if (this.objectName != null && this.server.isRegistered(objectName)) {
                this.server.unregisterMBean(objectName);
            }
            if (this.jmxmpObjectName != null && this.server.isRegistered(this.jmxmpObjectName)) {
                this.server.unregisterMBean(this.jmxmpObjectName);
            }
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    private void setupSsl() throws GeneralSecurityException {
        SSLServerSocketFactory sssf = this.keystoreManager.createSSLServerFactory(null, this.secureProtocol, this.algorithm, this.keyStore, this.keyAlias, this.trustStore, this.keyStoreAvailabilityTimeout);
        KarafSslRMIServerSocketFactory rssf = new KarafSslRMIServerSocketFactory(sssf, this.isClientAuth(), this.getRmiServerHost(), this.getEnabledProtocols(), this.getEnabledCipherSuites());
        SslRMIClientSocketFactory rcsf = new SslRMIClientSocketFactory();
        this.environment.put("jmx.remote.rmi.server.socket.factory", rssf);
        this.environment.put("jmx.remote.rmi.client.socket.factory", rcsf);
    }

    private void setupKarafRMIServerSocketFactory() {
        KarafRMIServerSocketFactory rssf = new KarafRMIServerSocketFactory(this.getRmiServerHost());
        this.environment.put("jmx.remote.rmi.server.socket.factory", rssf);
    }

    private static Socket checkLocal(Socket socket) throws IOException {
        InetAddress addr = socket.getInetAddress();
        if (addr != null) {
            if (addr.isLoopbackAddress()) {
                return socket;
            }
            try {
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                while (nis.hasMoreElements()) {
                    NetworkInterface ni = nis.nextElement();
                    Enumeration<InetAddress> ads = ni.getInetAddresses();
                    while (ads.hasMoreElements()) {
                        InetAddress ad = ads.nextElement();
                        if (!ad.equals(addr)) continue;
                        return socket;
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IOException("Only connections from clients running on the host where the RMI remote objects have been exported are accepted.");
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    private static class LocalOnlySSLServerSocket
    extends SSLServerSocket {
        private final SSLServerSocket ss;

        public LocalOnlySSLServerSocket(SSLServerSocket ss) throws IOException {
            this.ss = ss;
        }

        @Override
        public void bind(SocketAddress endpoint) throws IOException {
            this.ss.bind(endpoint);
        }

        @Override
        public void bind(SocketAddress endpoint, int backlog) throws IOException {
            this.ss.bind(endpoint, backlog);
        }

        @Override
        public InetAddress getInetAddress() {
            return this.ss.getInetAddress();
        }

        @Override
        public int getLocalPort() {
            return this.ss.getLocalPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.ss.getLocalSocketAddress();
        }

        @Override
        public Socket accept() throws IOException {
            return ConnectorServerFactory.checkLocal(this.ss.accept());
        }

        @Override
        public void close() throws IOException {
            this.ss.close();
        }

        @Override
        public ServerSocketChannel getChannel() {
            return this.ss.getChannel();
        }

        @Override
        public boolean isBound() {
            return this.ss.isBound();
        }

        @Override
        public boolean isClosed() {
            return this.ss.isClosed();
        }

        @Override
        public void setSoTimeout(int timeout) throws SocketException {
            this.ss.setSoTimeout(timeout);
        }

        @Override
        public int getSoTimeout() throws IOException {
            return this.ss.getSoTimeout();
        }

        @Override
        public void setReuseAddress(boolean on) throws SocketException {
            this.ss.setReuseAddress(on);
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.ss.getReuseAddress();
        }

        @Override
        public String toString() {
            return this.ss.toString();
        }

        @Override
        public void setReceiveBufferSize(int size) throws SocketException {
            this.ss.setReceiveBufferSize(size);
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return this.ss.getReceiveBufferSize();
        }

        @Override
        public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
            this.ss.setPerformancePreferences(connectionTime, latency, bandwidth);
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return this.ss.getEnabledCipherSuites();
        }

        @Override
        public void setEnabledCipherSuites(String[] strings) {
            this.ss.setEnabledCipherSuites(strings);
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.ss.getSupportedCipherSuites();
        }

        @Override
        public String[] getSupportedProtocols() {
            return this.ss.getSupportedProtocols();
        }

        @Override
        public String[] getEnabledProtocols() {
            return this.ss.getEnabledProtocols();
        }

        @Override
        public void setEnabledProtocols(String[] strings) {
            this.ss.setEnabledProtocols(strings);
        }

        @Override
        public void setNeedClientAuth(boolean b) {
            this.ss.setNeedClientAuth(b);
        }

        @Override
        public boolean getNeedClientAuth() {
            return this.ss.getNeedClientAuth();
        }

        @Override
        public void setWantClientAuth(boolean b) {
            this.ss.setWantClientAuth(b);
        }

        @Override
        public boolean getWantClientAuth() {
            return this.ss.getWantClientAuth();
        }

        @Override
        public void setUseClientMode(boolean b) {
            this.ss.setUseClientMode(b);
        }

        @Override
        public boolean getUseClientMode() {
            return this.ss.getUseClientMode();
        }

        @Override
        public void setEnableSessionCreation(boolean b) {
            this.ss.setEnableSessionCreation(b);
        }

        @Override
        public boolean getEnableSessionCreation() {
            return this.ss.getEnableSessionCreation();
        }

        @Override
        public SSLParameters getSSLParameters() {
            return this.ss.getSSLParameters();
        }

        @Override
        public void setSSLParameters(SSLParameters sslParameters) {
            this.ss.setSSLParameters(sslParameters);
        }
    }

    private static class LocalOnlyServerSocket
    extends ServerSocket {
        private final ServerSocket ss;

        public LocalOnlyServerSocket(ServerSocket ss) throws IOException {
            this.ss = ss;
        }

        @Override
        public void bind(SocketAddress endpoint) throws IOException {
            this.ss.bind(endpoint);
        }

        @Override
        public void bind(SocketAddress endpoint, int backlog) throws IOException {
            this.ss.bind(endpoint, backlog);
        }

        @Override
        public InetAddress getInetAddress() {
            return this.ss.getInetAddress();
        }

        @Override
        public int getLocalPort() {
            return this.ss.getLocalPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.ss.getLocalSocketAddress();
        }

        @Override
        public Socket accept() throws IOException {
            return ConnectorServerFactory.checkLocal(this.ss.accept());
        }

        @Override
        public void close() throws IOException {
            this.ss.close();
        }

        @Override
        public ServerSocketChannel getChannel() {
            return this.ss.getChannel();
        }

        @Override
        public boolean isBound() {
            return this.ss.isBound();
        }

        @Override
        public boolean isClosed() {
            return this.ss.isClosed();
        }

        @Override
        public void setSoTimeout(int timeout) throws SocketException {
            this.ss.setSoTimeout(timeout);
        }

        @Override
        public int getSoTimeout() throws IOException {
            return this.ss.getSoTimeout();
        }

        @Override
        public void setReuseAddress(boolean on) throws SocketException {
            this.ss.setReuseAddress(on);
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.ss.getReuseAddress();
        }

        @Override
        public String toString() {
            return this.ss.toString();
        }

        @Override
        public void setReceiveBufferSize(int size) throws SocketException {
            this.ss.setReceiveBufferSize(size);
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return this.ss.getReceiveBufferSize();
        }

        @Override
        public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
            this.ss.setPerformancePreferences(connectionTime, latency, bandwidth);
        }
    }

    private static class KarafRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private String rmiServerHost;

        public KarafRMIServerSocketFactory(String rmiServerHost) {
            this.rmiServerHost = rmiServerHost;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            InetAddress host = InetAddress.getByName(this.rmiServerHost);
            if (host.isLoopbackAddress()) {
                ServerSocket ss = ServerSocketFactory.getDefault().createServerSocket(port, 50, host);
                return new LocalOnlyServerSocket(ss);
            }
            ServerSocket ss = ServerSocketFactory.getDefault().createServerSocket(port, 50, InetAddress.getByName(this.rmiServerHost));
            return ss;
        }
    }

    private static class KarafSslRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private SSLServerSocketFactory sssf;
        private boolean clientAuth;
        private String rmiServerHost;
        private String[] enabledProtocols;
        private String[] enabledCipherSuites;

        public KarafSslRMIServerSocketFactory(SSLServerSocketFactory sssf, boolean clientAuth, String rmiServerHost, String[] enabledProtocols, String[] enabledCipherSuites) {
            this.sssf = sssf;
            this.clientAuth = clientAuth;
            this.rmiServerHost = rmiServerHost;
            this.enabledProtocols = enabledProtocols;
            this.enabledCipherSuites = enabledCipherSuites;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            InetAddress host = InetAddress.getByName(this.rmiServerHost);
            if (host.isLoopbackAddress()) {
                SSLServerSocket ss = (SSLServerSocket)this.sssf.createServerSocket(port, 50, host);
                ss.setNeedClientAuth(this.clientAuth);
                if (this.enabledProtocols != null && this.enabledProtocols.length > 0) {
                    ss.setEnabledProtocols(this.enabledProtocols);
                }
                if (this.enabledCipherSuites != null && this.enabledCipherSuites.length > 0) {
                    ss.setEnabledCipherSuites(this.enabledCipherSuites);
                }
                return new LocalOnlySSLServerSocket(ss);
            }
            SSLServerSocket ss = (SSLServerSocket)this.sssf.createServerSocket(port, 50, InetAddress.getByName(this.rmiServerHost));
            ss.setNeedClientAuth(this.clientAuth);
            if (this.enabledProtocols != null && this.enabledProtocols.length > 0) {
                ss.setEnabledProtocols(this.enabledProtocols);
            }
            if (this.enabledCipherSuites != null && this.enabledCipherSuites.length > 0) {
                ss.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            return ss;
        }
    }

    private static enum AuthenticatorType {
        NONE,
        PASSWORD,
        CERTIFICATE;

    }
}

