/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DIBDeviceInfo is the corresponding interface of DIBDeviceInfo
type DIBDeviceInfo interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetDescriptionType returns DescriptionType (property field)
	GetDescriptionType() uint8
	// GetKnxMedium returns KnxMedium (property field)
	GetKnxMedium() KnxMedium
	// GetDeviceStatus returns DeviceStatus (property field)
	GetDeviceStatus() DeviceStatus
	// GetKnxAddress returns KnxAddress (property field)
	GetKnxAddress() KnxAddress
	// GetProjectInstallationIdentifier returns ProjectInstallationIdentifier (property field)
	GetProjectInstallationIdentifier() ProjectInstallationIdentifier
	// GetKnxNetIpDeviceSerialNumber returns KnxNetIpDeviceSerialNumber (property field)
	GetKnxNetIpDeviceSerialNumber() []byte
	// GetKnxNetIpDeviceMulticastAddress returns KnxNetIpDeviceMulticastAddress (property field)
	GetKnxNetIpDeviceMulticastAddress() IPAddress
	// GetKnxNetIpDeviceMacAddress returns KnxNetIpDeviceMacAddress (property field)
	GetKnxNetIpDeviceMacAddress() MACAddress
	// GetDeviceFriendlyName returns DeviceFriendlyName (property field)
	GetDeviceFriendlyName() []byte
	// IsDIBDeviceInfo is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDIBDeviceInfo()
	// CreateBuilder creates a DIBDeviceInfoBuilder
	CreateDIBDeviceInfoBuilder() DIBDeviceInfoBuilder
}

// _DIBDeviceInfo is the data-structure of this message
type _DIBDeviceInfo struct {
	DescriptionType                uint8
	KnxMedium                      KnxMedium
	DeviceStatus                   DeviceStatus
	KnxAddress                     KnxAddress
	ProjectInstallationIdentifier  ProjectInstallationIdentifier
	KnxNetIpDeviceSerialNumber     []byte
	KnxNetIpDeviceMulticastAddress IPAddress
	KnxNetIpDeviceMacAddress       MACAddress
	DeviceFriendlyName             []byte
}

var _ DIBDeviceInfo = (*_DIBDeviceInfo)(nil)

// NewDIBDeviceInfo factory function for _DIBDeviceInfo
func NewDIBDeviceInfo(descriptionType uint8, knxMedium KnxMedium, deviceStatus DeviceStatus, knxAddress KnxAddress, projectInstallationIdentifier ProjectInstallationIdentifier, knxNetIpDeviceSerialNumber []byte, knxNetIpDeviceMulticastAddress IPAddress, knxNetIpDeviceMacAddress MACAddress, deviceFriendlyName []byte) *_DIBDeviceInfo {
	if deviceStatus == nil {
		panic("deviceStatus of type DeviceStatus for DIBDeviceInfo must not be nil")
	}
	if knxAddress == nil {
		panic("knxAddress of type KnxAddress for DIBDeviceInfo must not be nil")
	}
	if projectInstallationIdentifier == nil {
		panic("projectInstallationIdentifier of type ProjectInstallationIdentifier for DIBDeviceInfo must not be nil")
	}
	if knxNetIpDeviceMulticastAddress == nil {
		panic("knxNetIpDeviceMulticastAddress of type IPAddress for DIBDeviceInfo must not be nil")
	}
	if knxNetIpDeviceMacAddress == nil {
		panic("knxNetIpDeviceMacAddress of type MACAddress for DIBDeviceInfo must not be nil")
	}
	return &_DIBDeviceInfo{DescriptionType: descriptionType, KnxMedium: knxMedium, DeviceStatus: deviceStatus, KnxAddress: knxAddress, ProjectInstallationIdentifier: projectInstallationIdentifier, KnxNetIpDeviceSerialNumber: knxNetIpDeviceSerialNumber, KnxNetIpDeviceMulticastAddress: knxNetIpDeviceMulticastAddress, KnxNetIpDeviceMacAddress: knxNetIpDeviceMacAddress, DeviceFriendlyName: deviceFriendlyName}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DIBDeviceInfoBuilder is a builder for DIBDeviceInfo
type DIBDeviceInfoBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(descriptionType uint8, knxMedium KnxMedium, deviceStatus DeviceStatus, knxAddress KnxAddress, projectInstallationIdentifier ProjectInstallationIdentifier, knxNetIpDeviceSerialNumber []byte, knxNetIpDeviceMulticastAddress IPAddress, knxNetIpDeviceMacAddress MACAddress, deviceFriendlyName []byte) DIBDeviceInfoBuilder
	// WithDescriptionType adds DescriptionType (property field)
	WithDescriptionType(uint8) DIBDeviceInfoBuilder
	// WithKnxMedium adds KnxMedium (property field)
	WithKnxMedium(KnxMedium) DIBDeviceInfoBuilder
	// WithDeviceStatus adds DeviceStatus (property field)
	WithDeviceStatus(DeviceStatus) DIBDeviceInfoBuilder
	// WithDeviceStatusBuilder adds DeviceStatus (property field) which is build by the builder
	WithDeviceStatusBuilder(func(DeviceStatusBuilder) DeviceStatusBuilder) DIBDeviceInfoBuilder
	// WithKnxAddress adds KnxAddress (property field)
	WithKnxAddress(KnxAddress) DIBDeviceInfoBuilder
	// WithKnxAddressBuilder adds KnxAddress (property field) which is build by the builder
	WithKnxAddressBuilder(func(KnxAddressBuilder) KnxAddressBuilder) DIBDeviceInfoBuilder
	// WithProjectInstallationIdentifier adds ProjectInstallationIdentifier (property field)
	WithProjectInstallationIdentifier(ProjectInstallationIdentifier) DIBDeviceInfoBuilder
	// WithProjectInstallationIdentifierBuilder adds ProjectInstallationIdentifier (property field) which is build by the builder
	WithProjectInstallationIdentifierBuilder(func(ProjectInstallationIdentifierBuilder) ProjectInstallationIdentifierBuilder) DIBDeviceInfoBuilder
	// WithKnxNetIpDeviceSerialNumber adds KnxNetIpDeviceSerialNumber (property field)
	WithKnxNetIpDeviceSerialNumber(...byte) DIBDeviceInfoBuilder
	// WithKnxNetIpDeviceMulticastAddress adds KnxNetIpDeviceMulticastAddress (property field)
	WithKnxNetIpDeviceMulticastAddress(IPAddress) DIBDeviceInfoBuilder
	// WithKnxNetIpDeviceMulticastAddressBuilder adds KnxNetIpDeviceMulticastAddress (property field) which is build by the builder
	WithKnxNetIpDeviceMulticastAddressBuilder(func(IPAddressBuilder) IPAddressBuilder) DIBDeviceInfoBuilder
	// WithKnxNetIpDeviceMacAddress adds KnxNetIpDeviceMacAddress (property field)
	WithKnxNetIpDeviceMacAddress(MACAddress) DIBDeviceInfoBuilder
	// WithKnxNetIpDeviceMacAddressBuilder adds KnxNetIpDeviceMacAddress (property field) which is build by the builder
	WithKnxNetIpDeviceMacAddressBuilder(func(MACAddressBuilder) MACAddressBuilder) DIBDeviceInfoBuilder
	// WithDeviceFriendlyName adds DeviceFriendlyName (property field)
	WithDeviceFriendlyName(...byte) DIBDeviceInfoBuilder
	// Build builds the DIBDeviceInfo or returns an error if something is wrong
	Build() (DIBDeviceInfo, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DIBDeviceInfo
}

// NewDIBDeviceInfoBuilder() creates a DIBDeviceInfoBuilder
func NewDIBDeviceInfoBuilder() DIBDeviceInfoBuilder {
	return &_DIBDeviceInfoBuilder{_DIBDeviceInfo: new(_DIBDeviceInfo)}
}

type _DIBDeviceInfoBuilder struct {
	*_DIBDeviceInfo

	collectedErr []error
}

var _ (DIBDeviceInfoBuilder) = (*_DIBDeviceInfoBuilder)(nil)

func (b *_DIBDeviceInfoBuilder) WithMandatoryFields(descriptionType uint8, knxMedium KnxMedium, deviceStatus DeviceStatus, knxAddress KnxAddress, projectInstallationIdentifier ProjectInstallationIdentifier, knxNetIpDeviceSerialNumber []byte, knxNetIpDeviceMulticastAddress IPAddress, knxNetIpDeviceMacAddress MACAddress, deviceFriendlyName []byte) DIBDeviceInfoBuilder {
	return b.WithDescriptionType(descriptionType).WithKnxMedium(knxMedium).WithDeviceStatus(deviceStatus).WithKnxAddress(knxAddress).WithProjectInstallationIdentifier(projectInstallationIdentifier).WithKnxNetIpDeviceSerialNumber(knxNetIpDeviceSerialNumber...).WithKnxNetIpDeviceMulticastAddress(knxNetIpDeviceMulticastAddress).WithKnxNetIpDeviceMacAddress(knxNetIpDeviceMacAddress).WithDeviceFriendlyName(deviceFriendlyName...)
}

func (b *_DIBDeviceInfoBuilder) WithDescriptionType(descriptionType uint8) DIBDeviceInfoBuilder {
	b.DescriptionType = descriptionType
	return b
}

func (b *_DIBDeviceInfoBuilder) WithKnxMedium(knxMedium KnxMedium) DIBDeviceInfoBuilder {
	b.KnxMedium = knxMedium
	return b
}

func (b *_DIBDeviceInfoBuilder) WithDeviceStatus(deviceStatus DeviceStatus) DIBDeviceInfoBuilder {
	b.DeviceStatus = deviceStatus
	return b
}

func (b *_DIBDeviceInfoBuilder) WithDeviceStatusBuilder(builderSupplier func(DeviceStatusBuilder) DeviceStatusBuilder) DIBDeviceInfoBuilder {
	builder := builderSupplier(b.DeviceStatus.CreateDeviceStatusBuilder())
	var err error
	b.DeviceStatus, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "DeviceStatusBuilder failed"))
	}
	return b
}

func (b *_DIBDeviceInfoBuilder) WithKnxAddress(knxAddress KnxAddress) DIBDeviceInfoBuilder {
	b.KnxAddress = knxAddress
	return b
}

func (b *_DIBDeviceInfoBuilder) WithKnxAddressBuilder(builderSupplier func(KnxAddressBuilder) KnxAddressBuilder) DIBDeviceInfoBuilder {
	builder := builderSupplier(b.KnxAddress.CreateKnxAddressBuilder())
	var err error
	b.KnxAddress, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "KnxAddressBuilder failed"))
	}
	return b
}

func (b *_DIBDeviceInfoBuilder) WithProjectInstallationIdentifier(projectInstallationIdentifier ProjectInstallationIdentifier) DIBDeviceInfoBuilder {
	b.ProjectInstallationIdentifier = projectInstallationIdentifier
	return b
}

func (b *_DIBDeviceInfoBuilder) WithProjectInstallationIdentifierBuilder(builderSupplier func(ProjectInstallationIdentifierBuilder) ProjectInstallationIdentifierBuilder) DIBDeviceInfoBuilder {
	builder := builderSupplier(b.ProjectInstallationIdentifier.CreateProjectInstallationIdentifierBuilder())
	var err error
	b.ProjectInstallationIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ProjectInstallationIdentifierBuilder failed"))
	}
	return b
}

func (b *_DIBDeviceInfoBuilder) WithKnxNetIpDeviceSerialNumber(knxNetIpDeviceSerialNumber ...byte) DIBDeviceInfoBuilder {
	b.KnxNetIpDeviceSerialNumber = knxNetIpDeviceSerialNumber
	return b
}

func (b *_DIBDeviceInfoBuilder) WithKnxNetIpDeviceMulticastAddress(knxNetIpDeviceMulticastAddress IPAddress) DIBDeviceInfoBuilder {
	b.KnxNetIpDeviceMulticastAddress = knxNetIpDeviceMulticastAddress
	return b
}

func (b *_DIBDeviceInfoBuilder) WithKnxNetIpDeviceMulticastAddressBuilder(builderSupplier func(IPAddressBuilder) IPAddressBuilder) DIBDeviceInfoBuilder {
	builder := builderSupplier(b.KnxNetIpDeviceMulticastAddress.CreateIPAddressBuilder())
	var err error
	b.KnxNetIpDeviceMulticastAddress, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "IPAddressBuilder failed"))
	}
	return b
}

func (b *_DIBDeviceInfoBuilder) WithKnxNetIpDeviceMacAddress(knxNetIpDeviceMacAddress MACAddress) DIBDeviceInfoBuilder {
	b.KnxNetIpDeviceMacAddress = knxNetIpDeviceMacAddress
	return b
}

func (b *_DIBDeviceInfoBuilder) WithKnxNetIpDeviceMacAddressBuilder(builderSupplier func(MACAddressBuilder) MACAddressBuilder) DIBDeviceInfoBuilder {
	builder := builderSupplier(b.KnxNetIpDeviceMacAddress.CreateMACAddressBuilder())
	var err error
	b.KnxNetIpDeviceMacAddress, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "MACAddressBuilder failed"))
	}
	return b
}

func (b *_DIBDeviceInfoBuilder) WithDeviceFriendlyName(deviceFriendlyName ...byte) DIBDeviceInfoBuilder {
	b.DeviceFriendlyName = deviceFriendlyName
	return b
}

func (b *_DIBDeviceInfoBuilder) Build() (DIBDeviceInfo, error) {
	if b.DeviceStatus == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'deviceStatus' not set"))
	}
	if b.KnxAddress == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'knxAddress' not set"))
	}
	if b.ProjectInstallationIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'projectInstallationIdentifier' not set"))
	}
	if b.KnxNetIpDeviceMulticastAddress == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'knxNetIpDeviceMulticastAddress' not set"))
	}
	if b.KnxNetIpDeviceMacAddress == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'knxNetIpDeviceMacAddress' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._DIBDeviceInfo.deepCopy(), nil
}

func (b *_DIBDeviceInfoBuilder) MustBuild() DIBDeviceInfo {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DIBDeviceInfoBuilder) DeepCopy() any {
	_copy := b.CreateDIBDeviceInfoBuilder().(*_DIBDeviceInfoBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateDIBDeviceInfoBuilder creates a DIBDeviceInfoBuilder
func (b *_DIBDeviceInfo) CreateDIBDeviceInfoBuilder() DIBDeviceInfoBuilder {
	if b == nil {
		return NewDIBDeviceInfoBuilder()
	}
	return &_DIBDeviceInfoBuilder{_DIBDeviceInfo: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DIBDeviceInfo) GetDescriptionType() uint8 {
	return m.DescriptionType
}

func (m *_DIBDeviceInfo) GetKnxMedium() KnxMedium {
	return m.KnxMedium
}

func (m *_DIBDeviceInfo) GetDeviceStatus() DeviceStatus {
	return m.DeviceStatus
}

func (m *_DIBDeviceInfo) GetKnxAddress() KnxAddress {
	return m.KnxAddress
}

func (m *_DIBDeviceInfo) GetProjectInstallationIdentifier() ProjectInstallationIdentifier {
	return m.ProjectInstallationIdentifier
}

func (m *_DIBDeviceInfo) GetKnxNetIpDeviceSerialNumber() []byte {
	return m.KnxNetIpDeviceSerialNumber
}

func (m *_DIBDeviceInfo) GetKnxNetIpDeviceMulticastAddress() IPAddress {
	return m.KnxNetIpDeviceMulticastAddress
}

func (m *_DIBDeviceInfo) GetKnxNetIpDeviceMacAddress() MACAddress {
	return m.KnxNetIpDeviceMacAddress
}

func (m *_DIBDeviceInfo) GetDeviceFriendlyName() []byte {
	return m.DeviceFriendlyName
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastDIBDeviceInfo(structType any) DIBDeviceInfo {
	if casted, ok := structType.(DIBDeviceInfo); ok {
		return casted
	}
	if casted, ok := structType.(*DIBDeviceInfo); ok {
		return *casted
	}
	return nil
}

func (m *_DIBDeviceInfo) GetTypeName() string {
	return "DIBDeviceInfo"
}

func (m *_DIBDeviceInfo) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Implicit Field (structureLength)
	lengthInBits += 8

	// Simple field (descriptionType)
	lengthInBits += 8

	// Simple field (knxMedium)
	lengthInBits += 8

	// Simple field (deviceStatus)
	lengthInBits += m.DeviceStatus.GetLengthInBits(ctx)

	// Simple field (knxAddress)
	lengthInBits += m.KnxAddress.GetLengthInBits(ctx)

	// Simple field (projectInstallationIdentifier)
	lengthInBits += m.ProjectInstallationIdentifier.GetLengthInBits(ctx)

	// Array field
	if len(m.KnxNetIpDeviceSerialNumber) > 0 {
		lengthInBits += 8 * uint16(len(m.KnxNetIpDeviceSerialNumber))
	}

	// Simple field (knxNetIpDeviceMulticastAddress)
	lengthInBits += m.KnxNetIpDeviceMulticastAddress.GetLengthInBits(ctx)

	// Simple field (knxNetIpDeviceMacAddress)
	lengthInBits += m.KnxNetIpDeviceMacAddress.GetLengthInBits(ctx)

	// Array field
	if len(m.DeviceFriendlyName) > 0 {
		lengthInBits += 8 * uint16(len(m.DeviceFriendlyName))
	}

	return lengthInBits
}

func (m *_DIBDeviceInfo) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func DIBDeviceInfoParse(ctx context.Context, theBytes []byte) (DIBDeviceInfo, error) {
	return DIBDeviceInfoParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func DIBDeviceInfoParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (DIBDeviceInfo, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (DIBDeviceInfo, error) {
		return DIBDeviceInfoParseWithBuffer(ctx, readBuffer)
	}
}

func DIBDeviceInfoParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (DIBDeviceInfo, error) {
	v, err := (&_DIBDeviceInfo{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_DIBDeviceInfo) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__dIBDeviceInfo DIBDeviceInfo, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DIBDeviceInfo"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DIBDeviceInfo")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	structureLength, err := ReadImplicitField[uint8](ctx, "structureLength", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'structureLength' field"))
	}
	_ = structureLength

	descriptionType, err := ReadSimpleField(ctx, "descriptionType", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'descriptionType' field"))
	}
	m.DescriptionType = descriptionType

	knxMedium, err := ReadEnumField[KnxMedium](ctx, "knxMedium", "KnxMedium", ReadEnum(KnxMediumByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'knxMedium' field"))
	}
	m.KnxMedium = knxMedium

	deviceStatus, err := ReadSimpleField[DeviceStatus](ctx, "deviceStatus", ReadComplex[DeviceStatus](DeviceStatusParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deviceStatus' field"))
	}
	m.DeviceStatus = deviceStatus

	knxAddress, err := ReadSimpleField[KnxAddress](ctx, "knxAddress", ReadComplex[KnxAddress](KnxAddressParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'knxAddress' field"))
	}
	m.KnxAddress = knxAddress

	projectInstallationIdentifier, err := ReadSimpleField[ProjectInstallationIdentifier](ctx, "projectInstallationIdentifier", ReadComplex[ProjectInstallationIdentifier](ProjectInstallationIdentifierParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'projectInstallationIdentifier' field"))
	}
	m.ProjectInstallationIdentifier = projectInstallationIdentifier

	knxNetIpDeviceSerialNumber, err := readBuffer.ReadByteArray("knxNetIpDeviceSerialNumber", int(int32(6)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'knxNetIpDeviceSerialNumber' field"))
	}
	m.KnxNetIpDeviceSerialNumber = knxNetIpDeviceSerialNumber

	knxNetIpDeviceMulticastAddress, err := ReadSimpleField[IPAddress](ctx, "knxNetIpDeviceMulticastAddress", ReadComplex[IPAddress](IPAddressParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'knxNetIpDeviceMulticastAddress' field"))
	}
	m.KnxNetIpDeviceMulticastAddress = knxNetIpDeviceMulticastAddress

	knxNetIpDeviceMacAddress, err := ReadSimpleField[MACAddress](ctx, "knxNetIpDeviceMacAddress", ReadComplex[MACAddress](MACAddressParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'knxNetIpDeviceMacAddress' field"))
	}
	m.KnxNetIpDeviceMacAddress = knxNetIpDeviceMacAddress

	deviceFriendlyName, err := readBuffer.ReadByteArray("deviceFriendlyName", int(int32(30)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deviceFriendlyName' field"))
	}
	m.DeviceFriendlyName = deviceFriendlyName

	if closeErr := readBuffer.CloseContext("DIBDeviceInfo"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DIBDeviceInfo")
	}

	return m, nil
}

func (m *_DIBDeviceInfo) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DIBDeviceInfo) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("DIBDeviceInfo"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for DIBDeviceInfo")
	}
	structureLength := uint8(uint8(m.GetLengthInBytes(ctx)))
	if err := WriteImplicitField(ctx, "structureLength", structureLength, WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'structureLength' field")
	}

	if err := WriteSimpleField[uint8](ctx, "descriptionType", m.GetDescriptionType(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'descriptionType' field")
	}

	if err := WriteSimpleEnumField[KnxMedium](ctx, "knxMedium", "KnxMedium", m.GetKnxMedium(), WriteEnum[KnxMedium, uint8](KnxMedium.GetValue, KnxMedium.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'knxMedium' field")
	}

	if err := WriteSimpleField[DeviceStatus](ctx, "deviceStatus", m.GetDeviceStatus(), WriteComplex[DeviceStatus](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'deviceStatus' field")
	}

	if err := WriteSimpleField[KnxAddress](ctx, "knxAddress", m.GetKnxAddress(), WriteComplex[KnxAddress](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'knxAddress' field")
	}

	if err := WriteSimpleField[ProjectInstallationIdentifier](ctx, "projectInstallationIdentifier", m.GetProjectInstallationIdentifier(), WriteComplex[ProjectInstallationIdentifier](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'projectInstallationIdentifier' field")
	}

	if err := WriteByteArrayField(ctx, "knxNetIpDeviceSerialNumber", m.GetKnxNetIpDeviceSerialNumber(), WriteByteArray(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'knxNetIpDeviceSerialNumber' field")
	}

	if err := WriteSimpleField[IPAddress](ctx, "knxNetIpDeviceMulticastAddress", m.GetKnxNetIpDeviceMulticastAddress(), WriteComplex[IPAddress](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'knxNetIpDeviceMulticastAddress' field")
	}

	if err := WriteSimpleField[MACAddress](ctx, "knxNetIpDeviceMacAddress", m.GetKnxNetIpDeviceMacAddress(), WriteComplex[MACAddress](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'knxNetIpDeviceMacAddress' field")
	}

	if err := WriteByteArrayField(ctx, "deviceFriendlyName", m.GetDeviceFriendlyName(), WriteByteArray(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'deviceFriendlyName' field")
	}

	if popErr := writeBuffer.PopContext("DIBDeviceInfo"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for DIBDeviceInfo")
	}
	return nil
}

func (m *_DIBDeviceInfo) IsDIBDeviceInfo() {}

func (m *_DIBDeviceInfo) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DIBDeviceInfo) deepCopy() *_DIBDeviceInfo {
	if m == nil {
		return nil
	}
	_DIBDeviceInfoCopy := &_DIBDeviceInfo{
		m.DescriptionType,
		m.KnxMedium,
		utils.DeepCopy[DeviceStatus](m.DeviceStatus),
		utils.DeepCopy[KnxAddress](m.KnxAddress),
		utils.DeepCopy[ProjectInstallationIdentifier](m.ProjectInstallationIdentifier),
		utils.DeepCopySlice[byte, byte](m.KnxNetIpDeviceSerialNumber),
		utils.DeepCopy[IPAddress](m.KnxNetIpDeviceMulticastAddress),
		utils.DeepCopy[MACAddress](m.KnxNetIpDeviceMacAddress),
		utils.DeepCopySlice[byte, byte](m.DeviceFriendlyName),
	}
	return _DIBDeviceInfoCopy
}

func (m *_DIBDeviceInfo) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
