/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetReliability {
  NO_FAULT_DETECTED((int) 0),
  NO_SENSOR((int) 1),
  OVER_RANGE((int) 2),
  UNDER_RANGE((int) 3),
  OPEN_LOOP((int) 4),
  SHORTED_LOOP((int) 5),
  NO_OUTPUT((int) 6),
  UNRELIABLE_OTHER((int) 7),
  PROCESS_ERROR((int) 8),
  MULTI_STATE_FAULT((int) 9),
  CONFIGURATION_ERROR((int) 10),
  COMMUNICATION_FAILURE((int) 12),
  MEMBER_FAULT((int) 13),
  MONITORED_OBJECT_FAULT((int) 14),
  TRIPPED((int) 15),
  LAMP_FAILURE((int) 16),
  ACTIVATION_FAILURE((int) 17),
  RENEW_DHCP_FAILURE((int) 18),
  RENEW_FD_REGISTRATION_FAILURE((int) 19),
  RESTART_AUTO_NEGOTIATION_FAILURE((int) 20),
  RESTART_FAILURE((int) 21),
  PROPRIETARY_COMMAND_FAILURE((int) 22),
  FAULTS_LISTED((int) 23),
  REFERENCED_OBJECT_FAULT((int) 24),
  VENDOR_PROPRIETARY_VALUE((int) 0XFFFF);
  private static final Map<Integer, BACnetReliability> map;

  static {
    map = new HashMap<>();
    for (BACnetReliability value : BACnetReliability.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  BACnetReliability(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static BACnetReliability enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
