/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class LevelInformationNormal extends LevelInformation implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final LevelInformationNibblePair pair1;
  protected final LevelInformationNibblePair pair2;

  public LevelInformationNormal(
      int raw, LevelInformationNibblePair pair1, LevelInformationNibblePair pair2) {
    super(raw);
    this.pair1 = pair1;
    this.pair2 = pair2;
  }

  public LevelInformationNibblePair getPair1() {
    return pair1;
  }

  public LevelInformationNibblePair getPair2() {
    return pair2;
  }

  public short getActualLevel() {
    return (short) (((getPair2().getNibbleValue()) << (4)) | (getPair1().getNibbleValue()));
  }

  public float getActualLevelInPercent() {
    return (float) (((100F) * (((getActualLevel()) + (2F)))) / (255F));
  }

  @Override
  protected void serializeLevelInformationChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("LevelInformationNormal");

    // Simple Field (pair1)
    writeSimpleEnumField(
        "pair1",
        "LevelInformationNibblePair",
        pair1,
        writeEnum(
            LevelInformationNibblePair::getValue,
            LevelInformationNibblePair::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (pair2)
    writeSimpleEnumField(
        "pair2",
        "LevelInformationNibblePair",
        pair2,
        writeEnum(
            LevelInformationNibblePair::getValue,
            LevelInformationNibblePair::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    short actualLevel = getActualLevel();
    writeBuffer.writeVirtual("actualLevel", actualLevel);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    float actualLevelInPercent = getActualLevelInPercent();
    writeBuffer.writeVirtual("actualLevelInPercent", actualLevelInPercent);

    writeBuffer.popContext("LevelInformationNormal");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    LevelInformationNormal _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (pair1)
    lengthInBits += 8;

    // Simple field (pair2)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static LevelInformationBuilder staticParseLevelInformationBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("LevelInformationNormal");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    LevelInformationNibblePair pair1 =
        readEnumField(
            "pair1",
            "LevelInformationNibblePair",
            readEnum(LevelInformationNibblePair::enumForValue, readUnsignedShort(readBuffer, 8)));

    LevelInformationNibblePair pair2 =
        readEnumField(
            "pair2",
            "LevelInformationNibblePair",
            readEnum(LevelInformationNibblePair::enumForValue, readUnsignedShort(readBuffer, 8)));
    short actualLevel =
        readVirtualField(
            "actualLevel",
            short.class,
            ((pair2.getNibbleValue()) << (4)) | (pair1.getNibbleValue()));
    float actualLevelInPercent =
        readVirtualField(
            "actualLevelInPercent", float.class, ((100F) * (((actualLevel) + (2F)))) / (255F));

    readBuffer.closeContext("LevelInformationNormal");
    // Create the instance
    return new LevelInformationNormalBuilderImpl(pair1, pair2);
  }

  public static class LevelInformationNormalBuilderImpl
      implements LevelInformation.LevelInformationBuilder {
    private final LevelInformationNibblePair pair1;
    private final LevelInformationNibblePair pair2;

    public LevelInformationNormalBuilderImpl(
        LevelInformationNibblePair pair1, LevelInformationNibblePair pair2) {
      this.pair1 = pair1;
      this.pair2 = pair2;
    }

    public LevelInformationNormal build(int raw) {
      LevelInformationNormal levelInformationNormal = new LevelInformationNormal(raw, pair1, pair2);
      return levelInformationNormal;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof LevelInformationNormal)) {
      return false;
    }
    LevelInformationNormal that = (LevelInformationNormal) o;
    return (getPair1() == that.getPair1())
        && (getPair2() == that.getPair2())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPair1(), getPair2());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
