/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class MediaTransportControlDataRepeatOnOff extends MediaTransportControlData
    implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte repeatType;

  public MediaTransportControlDataRepeatOnOff(
      MediaTransportControlCommandTypeContainer commandTypeContainer,
      byte mediaLinkGroup,
      byte repeatType) {
    super(commandTypeContainer, mediaLinkGroup);
    this.repeatType = repeatType;
  }

  public byte getRepeatType() {
    return repeatType;
  }

  public boolean getIsOff() {
    return (boolean) ((getRepeatType()) == (0x00));
  }

  public boolean getIsRepeatCurrent() {
    return (boolean) (((getRepeatType()) > (0x00)) && ((getRepeatType()) <= (0xFE)));
  }

  public boolean getIsRepeatTracks() {
    return (boolean) ((getRepeatType()) >= (0xFE));
  }

  @Override
  protected void serializeMediaTransportControlDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("MediaTransportControlDataRepeatOnOff");

    // Simple Field (repeatType)
    writeSimpleField("repeatType", repeatType, writeByte(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isOff = getIsOff();
    writeBuffer.writeVirtual("isOff", isOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isRepeatCurrent = getIsRepeatCurrent();
    writeBuffer.writeVirtual("isRepeatCurrent", isRepeatCurrent);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isRepeatTracks = getIsRepeatTracks();
    writeBuffer.writeVirtual("isRepeatTracks", isRepeatTracks);

    writeBuffer.popContext("MediaTransportControlDataRepeatOnOff");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    MediaTransportControlDataRepeatOnOff _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (repeatType)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static MediaTransportControlDataBuilder staticParseMediaTransportControlDataBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("MediaTransportControlDataRepeatOnOff");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte repeatType = readSimpleField("repeatType", readByte(readBuffer, 8));
    boolean isOff = readVirtualField("isOff", boolean.class, (repeatType) == (0x00));
    boolean isRepeatCurrent =
        readVirtualField(
            "isRepeatCurrent", boolean.class, ((repeatType) > (0x00)) && ((repeatType) <= (0xFE)));
    boolean isRepeatTracks =
        readVirtualField("isRepeatTracks", boolean.class, (repeatType) >= (0xFE));

    readBuffer.closeContext("MediaTransportControlDataRepeatOnOff");
    // Create the instance
    return new MediaTransportControlDataRepeatOnOffBuilderImpl(repeatType);
  }

  public static class MediaTransportControlDataRepeatOnOffBuilderImpl
      implements MediaTransportControlData.MediaTransportControlDataBuilder {
    private final byte repeatType;

    public MediaTransportControlDataRepeatOnOffBuilderImpl(byte repeatType) {
      this.repeatType = repeatType;
    }

    public MediaTransportControlDataRepeatOnOff build(
        MediaTransportControlCommandTypeContainer commandTypeContainer, byte mediaLinkGroup) {
      MediaTransportControlDataRepeatOnOff mediaTransportControlDataRepeatOnOff =
          new MediaTransportControlDataRepeatOnOff(
              commandTypeContainer, mediaLinkGroup, repeatType);
      return mediaTransportControlDataRepeatOnOff;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MediaTransportControlDataRepeatOnOff)) {
      return false;
    }
    MediaTransportControlDataRepeatOnOff that = (MediaTransportControlDataRepeatOnOff) o;
    return (getRepeatType() == that.getRepeatType()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getRepeatType());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
