/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DatagramWriterGroupTransport2DataType extends ExtensionObjectDefinition
    implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 23615;
  }

  // Properties.
  protected final short messageRepeatCount;
  protected final double messageRepeatDelay;
  protected final ExtensionObject address;
  protected final PascalString qosCategory;
  protected final List<ExtensionObject> datagramQos;
  protected final long discoveryAnnounceRate;
  protected final PascalString topic;

  public DatagramWriterGroupTransport2DataType(
      short messageRepeatCount,
      double messageRepeatDelay,
      ExtensionObject address,
      PascalString qosCategory,
      List<ExtensionObject> datagramQos,
      long discoveryAnnounceRate,
      PascalString topic) {
    super();
    this.messageRepeatCount = messageRepeatCount;
    this.messageRepeatDelay = messageRepeatDelay;
    this.address = address;
    this.qosCategory = qosCategory;
    this.datagramQos = datagramQos;
    this.discoveryAnnounceRate = discoveryAnnounceRate;
    this.topic = topic;
  }

  public short getMessageRepeatCount() {
    return messageRepeatCount;
  }

  public double getMessageRepeatDelay() {
    return messageRepeatDelay;
  }

  public ExtensionObject getAddress() {
    return address;
  }

  public PascalString getQosCategory() {
    return qosCategory;
  }

  public List<ExtensionObject> getDatagramQos() {
    return datagramQos;
  }

  public long getDiscoveryAnnounceRate() {
    return discoveryAnnounceRate;
  }

  public PascalString getTopic() {
    return topic;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DatagramWriterGroupTransport2DataType");

    // Simple Field (messageRepeatCount)
    writeSimpleField("messageRepeatCount", messageRepeatCount, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (messageRepeatDelay)
    writeSimpleField("messageRepeatDelay", messageRepeatDelay, writeDouble(writeBuffer, 64));

    // Simple Field (address)
    writeSimpleField("address", address, writeComplex(writeBuffer));

    // Simple Field (qosCategory)
    writeSimpleField("qosCategory", qosCategory, writeComplex(writeBuffer));

    // Implicit Field (noOfDatagramQos) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDatagramQos = (int) ((((getDatagramQos()) == (null)) ? -(1) : COUNT(getDatagramQos())));
    writeImplicitField("noOfDatagramQos", noOfDatagramQos, writeSignedInt(writeBuffer, 32));

    // Array Field (datagramQos)
    writeComplexTypeArrayField("datagramQos", datagramQos, writeBuffer);

    // Simple Field (discoveryAnnounceRate)
    writeSimpleField(
        "discoveryAnnounceRate", discoveryAnnounceRate, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (topic)
    writeSimpleField("topic", topic, writeComplex(writeBuffer));

    writeBuffer.popContext("DatagramWriterGroupTransport2DataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DatagramWriterGroupTransport2DataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (messageRepeatCount)
    lengthInBits += 8;

    // Simple field (messageRepeatDelay)
    lengthInBits += 64;

    // Simple field (address)
    lengthInBits += address.getLengthInBits();

    // Simple field (qosCategory)
    lengthInBits += qosCategory.getLengthInBits();

    // Implicit Field (noOfDatagramQos)
    lengthInBits += 32;

    // Array field
    if (datagramQos != null) {
      int i = 0;
      for (ExtensionObject element : datagramQos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= datagramQos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (discoveryAnnounceRate)
    lengthInBits += 32;

    // Simple field (topic)
    lengthInBits += topic.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("DatagramWriterGroupTransport2DataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short messageRepeatCount =
        readSimpleField("messageRepeatCount", readUnsignedShort(readBuffer, 8));

    double messageRepeatDelay = readSimpleField("messageRepeatDelay", readDouble(readBuffer, 64));

    ExtensionObject address =
        readSimpleField(
            "address",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    PascalString qosCategory =
        readSimpleField(
            "qosCategory", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfDatagramQos = readImplicitField("noOfDatagramQos", readSignedInt(readBuffer, 32));

    List<ExtensionObject> datagramQos =
        readCountArrayField(
            "datagramQos",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer),
            noOfDatagramQos);

    long discoveryAnnounceRate =
        readSimpleField("discoveryAnnounceRate", readUnsignedLong(readBuffer, 32));

    PascalString topic =
        readSimpleField(
            "topic", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("DatagramWriterGroupTransport2DataType");
    // Create the instance
    return new DatagramWriterGroupTransport2DataTypeBuilderImpl(
        messageRepeatCount,
        messageRepeatDelay,
        address,
        qosCategory,
        datagramQos,
        discoveryAnnounceRate,
        topic);
  }

  public static class DatagramWriterGroupTransport2DataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final short messageRepeatCount;
    private final double messageRepeatDelay;
    private final ExtensionObject address;
    private final PascalString qosCategory;
    private final List<ExtensionObject> datagramQos;
    private final long discoveryAnnounceRate;
    private final PascalString topic;

    public DatagramWriterGroupTransport2DataTypeBuilderImpl(
        short messageRepeatCount,
        double messageRepeatDelay,
        ExtensionObject address,
        PascalString qosCategory,
        List<ExtensionObject> datagramQos,
        long discoveryAnnounceRate,
        PascalString topic) {
      this.messageRepeatCount = messageRepeatCount;
      this.messageRepeatDelay = messageRepeatDelay;
      this.address = address;
      this.qosCategory = qosCategory;
      this.datagramQos = datagramQos;
      this.discoveryAnnounceRate = discoveryAnnounceRate;
      this.topic = topic;
    }

    public DatagramWriterGroupTransport2DataType build() {
      DatagramWriterGroupTransport2DataType datagramWriterGroupTransport2DataType =
          new DatagramWriterGroupTransport2DataType(
              messageRepeatCount,
              messageRepeatDelay,
              address,
              qosCategory,
              datagramQos,
              discoveryAnnounceRate,
              topic);
      return datagramWriterGroupTransport2DataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DatagramWriterGroupTransport2DataType)) {
      return false;
    }
    DatagramWriterGroupTransport2DataType that = (DatagramWriterGroupTransport2DataType) o;
    return (getMessageRepeatCount() == that.getMessageRepeatCount())
        && (getMessageRepeatDelay() == that.getMessageRepeatDelay())
        && (getAddress() == that.getAddress())
        && (getQosCategory() == that.getQosCategory())
        && (getDatagramQos() == that.getDatagramQos())
        && (getDiscoveryAnnounceRate() == that.getDiscoveryAnnounceRate())
        && (getTopic() == that.getTopic())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getMessageRepeatCount(),
        getMessageRepeatDelay(),
        getAddress(),
        getQosCategory(),
        getDatagramQos(),
        getDiscoveryAnnounceRate(),
        getTopic());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
