/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.util.EnumMap;

public enum GeometryEncoding {
    WKB(new String[]{"ST_AsEWKB", "ST_AsBinary", "ST_AsWKB"}),
    WKT(new String[]{"ST_AsText", "ST_AsWKT"});

    private final String[] readers;
    private static final GeometryEncoding[] VALUES;

    private GeometryEncoding(String[] readers) {
        this.readers = readers;
    }

    static String[][] initial() {
        return new String[VALUES.length][];
    }

    static void checkSupport(String[][] accessors, String function) {
        for (int j = 0; j < VALUES.length; ++j) {
            GeometryEncoding encoding = VALUES[j];
            String[] readers = encoding.readers;
            for (int i = 0; i < readers.length; ++i) {
                if (!readers[i].equalsIgnoreCase(function)) continue;
                String[] functions = accessors[j];
                if (functions == null) {
                    functions = new String[readers.length];
                    accessors[j] = functions;
                }
                functions[i] = function;
            }
        }
    }

    static void store(String[][] accessors, EnumMap<GeometryEncoding, String> target) {
        block0: for (int j = 0; j < accessors.length; ++j) {
            GeometryEncoding encoding = VALUES[j];
            String[] functions = accessors[j];
            if (functions != null) {
                for (String function : functions) {
                    if (function == null) continue;
                    target.put(encoding, function);
                    continue block0;
                }
            }
            target.remove((Object)encoding);
        }
    }

    static {
        VALUES = GeometryEncoding.values();
    }
}

