/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import javax.measure.Unit;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultRangeDimension;
import org.apache.sis.xml.bind.gco.GO_Integer;
import org.apache.sis.xml.bind.gco.GO_Real;
import org.apache.sis.xml.bind.gco.GO_Record;
import org.apache.sis.xml.bind.gco.GO_RecordType;
import org.apache.sis.xml.bind.metadata.MI_RangeElementDescription;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="MD_SampleDimension_Type", propOrder={"maxValue", "minValue", "units", "scaleFactor", "offset", "meanValue", "numberOfValues", "standardDeviation", "otherPropertyType", "otherProperty", "bitsPerValue", "rangeElementDescriptions"})
@XmlRootElement(name="MD_SampleDimension")
@XmlSeeAlso(value={DefaultBand.class, DefaultRangeDimension.class})
@UML(identifier="MD_SampleDimension", specification=Specification.ISO_19115)
public class DefaultSampleDimension
extends DefaultRangeDimension {
    private static final long serialVersionUID = 4517148689016920767L;
    private Integer numberOfValues;
    private Double minValue;
    private Double maxValue;
    private Double meanValue;
    private Double standardDeviation;
    private Unit<?> units;
    private Double scaleFactor;
    private Double offset;
    private TransferFunctionType transferFunctionType;
    private Integer bitsPerValue;
    private Collection<RangeElementDescription> rangeElementDescriptions;
    private Double nominalSpatialResolution;
    private RecordType otherPropertyType;
    private Record otherProperty;

    public DefaultSampleDimension() {
    }

    public DefaultSampleDimension(DefaultSampleDimension object) {
        super(object);
        if (object != null) {
            this.init(object);
        }
    }

    private void init(DefaultSampleDimension object) {
        this.minValue = object.getMinValue();
        this.maxValue = object.getMaxValue();
        this.meanValue = object.getMeanValue();
        this.numberOfValues = object.getNumberOfValues();
        this.standardDeviation = object.getStandardDeviation();
        this.units = object.getUnits();
        this.scaleFactor = object.getScaleFactor();
        this.offset = object.getOffset();
        this.transferFunctionType = object.getTransferFunctionType();
        this.bitsPerValue = object.getBitsPerValue();
        this.nominalSpatialResolution = object.getNominalSpatialResolution();
        this.otherPropertyType = object.getOtherPropertyType();
        this.otherProperty = object.getOtherProperty();
    }

    DefaultSampleDimension(Band object) {
        super((RangeDimension)object);
        if (object != null) {
            if (object instanceof DefaultSampleDimension) {
                this.init((DefaultSampleDimension)object);
            } else {
                this.maxValue = object.getMaxValue();
                this.minValue = object.getMinValue();
                this.units = object.getUnits();
                this.scaleFactor = object.getScaleFactor();
                this.offset = object.getOffset();
                this.bitsPerValue = object.getBitsPerValue();
            }
        }
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="numberOfValues")
    @XmlJavaTypeAdapter(value=GO_Integer.Since2014.class)
    @UML(identifier="numberOfValues", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Integer getNumberOfValues() {
        return this.numberOfValues;
    }

    public void setNumberOfValues(Integer newValue) {
        this.checkWritePermission(this.numberOfValues);
        if (ImplementationHelper.ensurePositive(DefaultSampleDimension.class, "numberOfValues", false, newValue)) {
            this.numberOfValues = newValue;
        }
    }

    @XmlElement(name="minValue")
    @UML(identifier="minValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Double newValue) {
        this.checkWritePermission(this.minValue);
        this.minValue = newValue;
    }

    @XmlElement(name="maxValue")
    @UML(identifier="maxValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Double newValue) {
        this.checkWritePermission(this.maxValue);
        this.maxValue = newValue;
    }

    @XmlElement(name="meanValue")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    @UML(identifier="meanValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getMeanValue() {
        return this.meanValue;
    }

    public void setMeanValue(Double newValue) {
        this.checkWritePermission(this.meanValue);
        this.meanValue = newValue;
    }

    @XmlElement(name="standardDeviation")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    @UML(identifier="standardDeviation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(Double newValue) {
        this.checkWritePermission(this.standardDeviation);
        this.standardDeviation = newValue;
    }

    @XmlElement(name="units")
    @UML(identifier="units", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Unit<?> getUnits() {
        return this.units;
    }

    public void setUnits(Unit<?> newValue) {
        this.checkWritePermission(this.units);
        this.units = newValue;
    }

    @XmlElement(name="scaleFactor")
    @UML(identifier="scaleFactor", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(Double newValue) {
        this.checkWritePermission(this.scaleFactor);
        this.scaleFactor = newValue;
    }

    @XmlElement(name="offset")
    @UML(identifier="offset", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getOffset() {
        return this.offset;
    }

    public void setOffset(Double newValue) {
        this.checkWritePermission(this.offset);
        this.offset = newValue;
    }

    public TransferFunctionType getTransferFunctionType() {
        return this.transferFunctionType;
    }

    public void setTransferFunctionType(TransferFunctionType newValue) {
        this.checkWritePermission(this.transferFunctionType);
        this.transferFunctionType = newValue;
    }

    @ValueRange(minimum=1.0)
    @XmlElement(name="bitsPerValue")
    @UML(identifier="bitsPerValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Integer getBitsPerValue() {
        return this.bitsPerValue;
    }

    public void setBitsPerValue(Integer newValue) {
        this.checkWritePermission(this.bitsPerValue);
        if (ImplementationHelper.ensurePositive(DefaultSampleDimension.class, "bitsPerValue", true, newValue)) {
            this.bitsPerValue = newValue;
        }
    }

    @XmlElement(name="rangeElementDescription")
    @XmlJavaTypeAdapter(value=MI_RangeElementDescription.Since2014.class)
    public Collection<RangeElementDescription> getRangeElementDescriptions() {
        this.rangeElementDescriptions = this.nonNullCollection(this.rangeElementDescriptions, RangeElementDescription.class);
        return this.rangeElementDescriptions;
    }

    public void setRangeElementDescriptions(Collection<? extends RangeElementDescription> newValues) {
        this.rangeElementDescriptions = this.writeCollection(newValues, this.rangeElementDescriptions, RangeElementDescription.class);
    }

    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getNominalSpatialResolution() {
        return this.nominalSpatialResolution;
    }

    public void setNominalSpatialResolution(Double newValue) {
        this.checkWritePermission(this.nominalSpatialResolution);
        if (ImplementationHelper.ensurePositive(DefaultSampleDimension.class, "nominalSpatialResolution", true, newValue)) {
            this.nominalSpatialResolution = newValue;
        }
    }

    @XmlElement(name="otherPropertyType")
    @XmlJavaTypeAdapter(value=GO_RecordType.Since2014.class)
    @UML(identifier="otherPropertyType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public RecordType getOtherPropertyType() {
        return this.otherPropertyType;
    }

    public void setOtherPropertyType(RecordType newValue) {
        this.checkWritePermission(this.otherPropertyType);
        this.otherPropertyType = newValue;
    }

    @XmlElement(name="otherProperty")
    @XmlJavaTypeAdapter(value=GO_Record.Since2014.class)
    @UML(identifier="otherProperty", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Record getOtherProperty() {
        return this.otherProperty;
    }

    public void setOtherProperty(Record newValue) {
        this.checkWritePermission(this.otherProperty);
        this.otherProperty = newValue;
    }
}

