/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import ojb.broker.Identity;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.accesslayer.JdbcAccess;
import ojb.broker.accesslayer.StatementsForClass;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.query.Criteria;
import ojb.broker.query.SelectionCriteria;
import ojb.broker.singlevm.PersistenceBrokerImpl;

public class StatementManager {
    private Hashtable statementTable = new Hashtable();
    private PersistenceBrokerImpl broker;

    public StatementManager(PersistenceBrokerImpl pBroker) {
        this.broker = pBroker;
    }

    public void bindDelete(PreparedStatement stmt, Identity oid) throws SQLException {
        int i = 0;
        while (i < oid.getPrimaryKeyValues().length) {
            stmt.setObject(i + 1, oid.getPrimaryKeyValues()[i]);
            ++i;
        }
    }

    public int bindStatement(PreparedStatement stmt, Criteria crit, ClassDescriptor cld, int param) throws SQLException {
        Enumeration e = crit.getElements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Criteria) {
                Criteria pc = (Criteria)o;
                param = this.bindStatement(stmt, pc, cld, param);
                continue;
            }
            SelectionCriteria c = (SelectionCriteria)o;
            Object value = c.getO();
            if (value != null) {
                stmt.setObject(param, value);
            } else {
                stmt.setNull(param, 0);
            }
            ++param;
        }
        return param;
    }

    public void bindInsert(PreparedStatement stmt, ClassDescriptor cld, Object obj) throws SQLException {
        Object[] values = cld.getAllValues(obj);
        int i = 0;
        while (i < values.length) {
            Object val = values[i];
            if (val != null) {
                stmt.setObject(i + 1, val);
            } else {
                stmt.setNull(i + 1, JdbcAccess.getSqlTypeAll(cld, i));
            }
            ++i;
        }
    }

    public void bindSelect(PreparedStatement stmt, Identity oid) throws SQLException {
        int i = 0;
        try {
            i = 0;
            while (i < oid.getPrimaryKeyValues().length) {
                stmt.setObject(i + 1, oid.getPrimaryKeyValues()[i]);
                ++i;
            }
        }
        catch (SQLException e) {
            System.out.println("bindSelect failed for: " + oid.toString() + ", PK: " + i + ", value: " + oid.getPrimaryKeyValues()[i]);
            throw e;
        }
    }

    public void bindUpdate(PreparedStatement stmt, ClassDescriptor cld, Object obj) throws SQLException {
        int index = 1;
        Object[] values = cld.getNonKeyValues(obj);
        int i = 0;
        while (i < values.length) {
            Object val = values[i];
            if (val != null) {
                stmt.setObject(index, val);
            } else {
                stmt.setNull(index, JdbcAccess.getSqlTypeNonPk(cld, i));
            }
            ++index;
            ++i;
        }
        values = cld.getKeyValues(obj);
        int i2 = 0;
        while (i2 < values.length) {
            Object val = values[i2];
            if (val != null) {
                stmt.setObject(index, values[i2]);
            } else {
                stmt.setNull(index, JdbcAccess.getSqlTypePk(cld, i2));
            }
            ++index;
            ++i2;
        }
    }

    public PreparedStatement getDeleteStatement(ClassDescriptor cds) throws PersistenceBrokerException {
        return this.getStatementsForClass(cds).getDeleteStmt();
    }

    public Statement getGenericStatement(ClassDescriptor cds) throws PersistenceBrokerException {
        return this.getStatementsForClass(cds).getGenericStmt();
    }

    public PreparedStatement getInsertStatement(ClassDescriptor cds) throws PersistenceBrokerException {
        return this.getStatementsForClass(cds).getInsertStmt();
    }

    public PreparedStatement getPreparedStatement(ClassDescriptor cds, String sql) throws PersistenceBrokerException {
        return this.getStatementsForClass(cds).getPreparedStmt(sql);
    }

    public PreparedStatement getSelectByPKStatement(ClassDescriptor cds) throws PersistenceBrokerException {
        return this.getStatementsForClass(cds).getSelectByPKkStmt();
    }

    private StatementsForClass getStatementsForClass(ClassDescriptor cds) throws PersistenceBrokerException {
        StatementsForClass sfc = (StatementsForClass)this.statementTable.get(cds);
        if (sfc == null) {
            sfc = new StatementsForClass(cds, this.broker);
            this.statementTable.put(cds, sfc);
        }
        return sfc;
    }

    public PreparedStatement getUpdateStatement(ClassDescriptor cds) throws PersistenceBrokerException {
        return this.getStatementsForClass(cds).getUpdateStmt();
    }
}

