/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.turbine.om.security.SecurityEntity;

public abstract class SecurityObject<T extends SecurityEntity>
implements Comparable<T> {
    private String name;
    private int id;
    private Map<String, Object> attributes;

    public SecurityObject() {
        this("");
    }

    public SecurityObject(String name) {
        this.setName(name);
        this.setId(0);
        this.setAttributes(Collections.synchronizedMap(new HashMap()));
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public Integer getIdAsObj() {
        return new Integer(this.id);
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int compareTo(T obj) {
        if (this.getClass() != obj.getClass()) {
            throw new ClassCastException();
        }
        String name1 = obj.getName();
        String name2 = this.getName();
        return name2.compareTo(name1);
    }

    public String toString() {
        return this.getName() + ':' + this.getAttributes().toString();
    }
}

