/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features.shell;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.cellar.features.FeatureState;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="cluster", name="feature-list", description="List the features in a cluster group")
@Service
public class ListFeaturesCommand
extends CellarCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Option(name="-i", aliases={"--installed"}, description="Display only installed features", required=false, multiValued=false)
    boolean installed;
    @Option(name="-o", aliases={"--ordered"}, description="Display a list using alphabetical order", required=false, multiValued=false)
    boolean ordered;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    @Option(name="--cluster", description="Shows only features on the cluster", required=false, multiValued=false)
    boolean onlyCluster;
    @Option(name="--local", description="Shows only features on the local node", required=false, multiValued=false)
    boolean onlyLocal;
    @Option(name="--blocked", description="Shows only blocked features", required=false, multiValued=false)
    boolean onlyBlocked;
    @Reference
    private FeaturesService featuresService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Map<String, ExtendedFeatureState> features = this.gatherFeatures();
            if (features != null && !features.isEmpty()) {
                ShellTable table = new ShellTable();
                table.column("Name");
                table.column("Version");
                table.column("Installed");
                table.column("Located");
                table.column("Blocked");
                ArrayList<ExtendedFeatureState> featureStates = new ArrayList<ExtendedFeatureState>(features.values());
                if (this.ordered) {
                    Collections.sort(featureStates, new FeatureComparator());
                }
                for (ExtendedFeatureState info : featureStates) {
                    String name = info.getName();
                    String version = info.getVersion();
                    boolean isInstalled = info.getInstalled();
                    String located = "";
                    boolean cluster = info.isCluster();
                    boolean local = info.isLocal();
                    if (cluster && local) {
                        located = "cluster/local";
                    }
                    if (local && !cluster) {
                        located = "local";
                        if (this.onlyCluster) continue;
                    }
                    if (cluster && !local) {
                        located = "cluster";
                        if (this.onlyLocal) continue;
                    }
                    String blocked = "";
                    boolean inbound = support.isAllowed(group, "feature", name, EventType.INBOUND);
                    boolean outbound = support.isAllowed(group, "feature", name, EventType.OUTBOUND);
                    if (inbound && outbound && this.onlyBlocked) continue;
                    if (!inbound && !outbound) {
                        blocked = "in/out";
                    }
                    if (!inbound && outbound) {
                        blocked = "in";
                    }
                    if (!outbound && inbound) {
                        blocked = "out";
                    }
                    if (version == null) {
                        version = "";
                    }
                    if (this.installed && (!this.installed || !isInstalled)) continue;
                    table.addRow().addContent(new Object[]{name, version, isInstalled ? "x" : " ", located, blocked});
                }
                table.print(System.out, !this.noFormat);
            } else {
                System.err.println("No features in cluster group " + this.groupName);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    private Map<String, ExtendedFeatureState> gatherFeatures() throws Exception {
        HashMap<String, ExtendedFeatureState> features = new HashMap<String, ExtendedFeatureState>();
        Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + this.groupName);
        for (String key : clusterFeatures.keySet()) {
            FeatureState state = (FeatureState)clusterFeatures.get(key);
            ExtendedFeatureState extendedState = new ExtendedFeatureState();
            extendedState.setName(state.getName());
            extendedState.setInstalled(state.getInstalled());
            extendedState.setVersion(state.getVersion());
            extendedState.setCluster(true);
            extendedState.setLocal(true);
            features.put(key, extendedState);
        }
        for (Feature feature : this.featuresService.listFeatures()) {
            ExtendedFeatureState extendedState;
            String key = feature.getName() + "/" + feature.getVersion();
            if (features.containsKey(key)) {
                extendedState = (ExtendedFeatureState)features.get(key);
                if (this.featuresService.isInstalled(feature)) {
                    extendedState.setInstalled(true);
                }
                extendedState.setLocal(true);
                continue;
            }
            extendedState = new ExtendedFeatureState();
            extendedState.setCluster(false);
            extendedState.setLocal(true);
            extendedState.setName(feature.getName());
            extendedState.setVersion(feature.getVersion());
            if (this.featuresService.isInstalled(feature)) {
                extendedState.setInstalled(true);
            } else {
                extendedState.setInstalled(false);
            }
            features.put(key, extendedState);
        }
        return features;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    class ExtendedFeatureState
    extends FeatureState {
        private boolean cluster;
        private boolean local;

        ExtendedFeatureState() {
        }

        public boolean isCluster() {
            return this.cluster;
        }

        public void setCluster(boolean cluster) {
            this.cluster = cluster;
        }

        public boolean isLocal() {
            return this.local;
        }

        public void setLocal(boolean local) {
            this.local = local;
        }
    }

    class FeatureComparator
    implements Comparator<FeatureState> {
        FeatureComparator() {
        }

        @Override
        public int compare(FeatureState f1, FeatureState f2) {
            return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
        }
    }
}

