/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.ant;

import java.net.URI;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.woden.ant.NamespaceWriter;
import org.apache.woden.ant.ObjectIdTable;
import org.apache.woden.ant.XMLWriter;

public class CmBaseWriter
extends NamespaceWriter {
    public static final String NS = "http://www.w3.org/2002/ws/desc/wsdl/component-base";
    public static final String PREFIX = "cmbase";
    public static final String LOCAL_NAME = "cmbase:localName";
    public static final String NAMESPACE_NAME = "cmbase:namespaceName";
    public static final String PARENT = "cmbase:parent";
    public static final String REF = "cmbase:ref";
    public static final String REQUIRED = "cmbase:required";
    public static final String URI = "cmbase:uri";
    public static final String VALUE = "cmbase:value";
    public static final String VALUE_CONSTRAINT = "cmbase:valueConstraint";
    private ObjectIdTable oit = new ObjectIdTable();

    public CmBaseWriter(XMLWriter out) {
        super(out, NS, PREFIX);
    }

    public void parent(Object parent) {
        this.writeRef(PARENT, parent);
    }

    public void write(String tag, QName qname) {
        if (qname == null) {
            return;
        }
        this.out.beginElement(tag);
        this.out.element(NAMESPACE_NAME, qname.getNamespaceURI());
        this.out.element(LOCAL_NAME, qname.getLocalPart());
        this.out.endElement();
    }

    public void writeUris(String tag, URI[] uris) {
        if (uris.length == 0) {
            return;
        }
        Arrays.sort(uris);
        this.out.beginElement(tag);
        for (int i = 0; i < uris.length; ++i) {
            this.write(URI, uris[i]);
        }
        this.out.endElement();
    }

    public void writeOptionalRef(String tag, Object o) {
        if (o == null) {
            return;
        }
        this.writeRef(tag, o);
    }

    public void writeRef(String tag, Object o) {
        this.out.emptyElement(tag, this.refAttribute(o));
    }

    private String id(Object o) {
        if (o == null) {
            return "id-null";
        }
        return "id-" + this.oit.id(o);
    }

    public String idAttribute(Object o) {
        return "xml:id='" + this.id(o) + "'";
    }

    public String refAttribute(Object o) {
        return "ref='" + this.id(o) + "'";
    }

    public static int compareQName(QName q1, QName q2) {
        String n2;
        if (q1.equals(q2)) {
            return 0;
        }
        String n1 = q1.getNamespaceURI();
        if (n1.equals(n2 = q2.getNamespaceURI())) {
            String l1 = q1.getLocalPart();
            String l2 = q2.getLocalPart();
            return l1.compareTo(l2);
        }
        return n1.compareTo(n2);
    }
}

