// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigStackSlice(t *testing.T) {
	src := []*otlpprofiles.Stack{}
	dest := []*otlpprofiles.Stack{}
	// Test CopyTo empty
	dest = CopyOrigStackSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.Stack{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestStackSlice()
	dest = CopyOrigStackSlice(dest, src)
	assert.Equal(t, GenerateOrigTestStackSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigStackSlice(dest, src)
	assert.Equal(t, GenerateOrigTestStackSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigStackSlice(dest, []*otlpprofiles.Stack{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigStackSlice(dest, src)
	assert.Equal(t, GenerateOrigTestStackSlice(), dest)
}
