// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1experimental"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestLocation_MoveTo(t *testing.T) {
	ms := generateTestLocation()
	dest := NewLocation()
	ms.MoveTo(dest)
	assert.Equal(t, NewLocation(), ms)
	assert.Equal(t, generateTestLocation(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newLocation(&otlpprofiles.Location{}, &sharedState)) })
	assert.Panics(t, func() { newLocation(&otlpprofiles.Location{}, &sharedState).MoveTo(dest) })
}

func TestLocation_CopyTo(t *testing.T) {
	ms := NewLocation()
	orig := NewLocation()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestLocation()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newLocation(&otlpprofiles.Location{}, &sharedState)) })
}

func TestLocation_ID(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, uint64(0), ms.ID())
	ms.SetID(uint64(1))
	assert.Equal(t, uint64(1), ms.ID())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newLocation(&otlpprofiles.Location{}, &sharedState).SetID(uint64(1)) })
}

func TestLocation_MappingIndex(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, uint64(0), ms.MappingIndex())
	ms.SetMappingIndex(uint64(1))
	assert.Equal(t, uint64(1), ms.MappingIndex())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newLocation(&otlpprofiles.Location{}, &sharedState).SetMappingIndex(uint64(1)) })
}

func TestLocation_Address(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, uint64(0), ms.Address())
	ms.SetAddress(uint64(1))
	assert.Equal(t, uint64(1), ms.Address())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newLocation(&otlpprofiles.Location{}, &sharedState).SetAddress(uint64(1)) })
}

func TestLocation_Line(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, NewLineSlice(), ms.Line())
	fillTestLineSlice(ms.Line())
	assert.Equal(t, generateTestLineSlice(), ms.Line())
}

func TestLocation_IsFolded(t *testing.T) {
	ms := NewLocation()
	assert.False(t, ms.IsFolded())
	ms.SetIsFolded(true)
	assert.True(t, ms.IsFolded())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newLocation(&otlpprofiles.Location{}, &sharedState).SetIsFolded(true) })
}

func TestLocation_TypeIndex(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, uint32(0), ms.TypeIndex())
	ms.SetTypeIndex(uint32(1))
	assert.Equal(t, uint32(1), ms.TypeIndex())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newLocation(&otlpprofiles.Location{}, &sharedState).SetTypeIndex(uint32(1)) })
}

func TestLocation_Attributes(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, pcommon.NewUInt64Slice(), ms.Attributes())
	internal.FillTestUInt64Slice(internal.UInt64Slice(ms.Attributes()))
	assert.Equal(t, pcommon.UInt64Slice(internal.GenerateTestUInt64Slice()), ms.Attributes())
}

func generateTestLocation() Location {
	tv := NewLocation()
	fillTestLocation(tv)
	return tv
}

func fillTestLocation(tv Location) {
	tv.orig.Id = uint64(1)
	tv.orig.MappingIndex = uint64(1)
	tv.orig.Address = uint64(1)
	fillTestLineSlice(newLineSlice(&tv.orig.Line, tv.state))
	tv.orig.IsFolded = true
	tv.orig.TypeIndex = uint32(1)
	internal.FillTestUInt64Slice(internal.NewUInt64Slice(&tv.orig.Attributes, tv.state))
}
