<!-- This file is autogenerated. See CONTRIBUTING.md for instructions to add an entry. -->

# Go API Changelog

This changelog includes only developer-facing changes.
If you are looking for user-facing changes, check out [CHANGELOG.md](./CHANGELOG.md).

<!-- next version -->

## v1.35.0/v0.129.0

### 🛑 Breaking changes 🛑

- `semconv`: Removing deprecated semconv package (#13071)
- `configgrpc,confighttp`: Unify return type of `NewDefault*Config` functions to return a struct instead of a pointer. (#13169)
- `exporterhelper`: QueueBatchEncoding interface is changed to support marshaling and unmarshaling of request context. (#13188)

### 💡 Enhancements 💡

- `pdata/pprofile`: Introduce `Equal` method on the `Mapping` type (#13197)
- `configoptional`: Make unmarshaling into `None[T]` work the same as unmarshaling into `(*T)(nil)`. (#13168)
- `configoptional`: Add a confmap.Marshaler implementation for configoptional.Optional (#13196)
- `pdata/pprofile`: Introduce `Equal` methods on the `Line` and `Location` types (#13150)
- `pdata/pprofile`: Add new helper method `SetMapping` to set a new mapping on a location. (#13197)

### 🧰 Bug fixes 🧰

- `confmap`: Distinguish between empty and nil values when marshaling `confmap.Conf` structs. (#13196)

<!-- previous-version -->

## v1.34.0/v0.128.0

### 🛑 Breaking changes 🛑

- `exporterhelper`: Remove deprecated NewProfilesRequestExporter function from xexporterhelper package (#13157)
- `confighttp`: Remove pointer to field `cookies` in confighttp.ClientConfig (#13116)
- `otlpreceiver`: Use `configoptional.Optional` to define optional configuration sections in the OTLP receiver. Remove `Unmarshal` method. (#13119)
- `confighttp,configgrpc`: Rename `ClientConfig.TLSSetting` and `ServerConfig.TLSSetting` to `ClientConfig.TLS` and `ServerConfig.TLS`. (#13115)
- `pdata/pprofile`: Upgrade the OTLP protobuf definitions to version 1.7.0 (#13075)
  Note that the batcher is temporarily a noop.
- `pipeline`: Remove deprecated MustNewID[WithName] (#13139)

### 🚀 New components 🚀

- `configoptional`: Add a new configoptional module to support optional configuration fields. (#12981)

### 💡 Enhancements 💡

- `pdata`: Introduce `MoveAndAppendTo` methods to the generated primitive slices (#13074)
- `pdata`: Upgrade the OTLP protobuf definitions to version 1.7.0 (#13075)

### 🧰 Bug fixes 🧰

- `confmap`: Correctly distinguish between `nil` and empty map values on the `ToStringMap` method (#13161)
  This means that `ToStringMap()` method can now return a nil map if the original value was `nil`.
  If you were not doing so already, make sure to check for `nil` before writing to the map to avoid panics.
  
- `confighttp`: Make the `NewDefaultServerConfig` function return a nil TLS config by default. (#13129)
  - The previous default was a TLS config with no certificates, which would fail at runtime.
  

<!-- previous-version -->

## v1.33.0/v0.127.0

### 🛑 Breaking changes 🛑

- `mdatagen`: Add context parameter for recording event to set traceID and spanID (#12571)
- `otlpreceiver`: Use wrapper type for URL paths (#13046)

### 🚩 Deprecations 🚩

- `pipeline`: Deprecate MustNewID and MustNewIDWithName (#12831)
- `pdata/profile`: Replace AddAttribute with the PutAttribute helper method to modify the content of attributable records. (#12798)

### 💡 Enhancements 💡

- `consumer/consumertest`: Add context to sinks (#13039)
- `cmd/mdatagen`: Add events in generated documentation (#12571)
- `confmap`: Add a `Conf.Delete` method to remove a path from the configuration map. (#13064)
- `confmap`: Support running Unmarshal hooks on nil values. (#12981)

<!-- previous-version -->

## v1.32.0/v0.126.0

### 🚩 Deprecations 🚩

- `configauth`: Deprecate `configauth.Authentication` in favor of `configauth.Config`. (#12875)

### 💡 Enhancements 💡

- `cmd/mdatagen`: Add type definition for events in mdatagen (#12571)
- `cmd/mdatagen`: Add functions for processing structured events in mdatagen (#12571)

<!-- previous-version -->

## v1.31.0/v0.125.0

### 🚩 Deprecations 🚩

- `extensionauthtest`: Deprecate NewErrorClient in favor of NewErrClient. (#12874)

### 💡 Enhancements 💡

- `xextension/storage`: ErrStorageFull error added to xextension/storage contract (#12925)
- `pdata`: Add MoveTo to pcommon.Value, only type missing this (#12877)

### 🧰 Bug fixes 🧰

- `pdata`: Fix MoveTo when moving to the same destination (#12887)

<!-- previous-version -->

## v1.30.0/v0.124.0

### 🛑 Breaking changes 🛑

- `exporterbatcher`: Remove deprecated package exporterbatcher (#12780)
- `exporterqueue`: Remove deprecated package exporterqueue (#12779)

### 💡 Enhancements 💡

- `mdatagen`: Add variable for metric name in mdatagen (#12459)
  Access metric name via `metadata.MetricsInfo.<metric-variable>.Name`
- `client`: Add support for iterating over client metadata keys (#12804)
- `service`: Adds the GetFactory interface to the hostcapabilities package (#12789)
- `cmd/mdatagen`: Add the foundational changes necessary for supporting logs data in `mdatagen` (#12571)

<!-- previous-version -->

## v1.29.0/v0.123.0

### 🛑 Breaking changes 🛑

- `otlpreceiver/otlpexporter/otlphttpexporter`: Avoid using go embedded messages in Config (#12718)
- `exporterqueue`: Move Queue interface to internal, disallow alternative implementations (#12680)
- `extensionauth, configauth`: Remove deprecated types and functions from `extensionauth` and `configauth` packages. (#12672)
  This includes:
  - `extensionauth.NewClient`,
  - `extensionauth.ClientOption` and all its implementations,
  - `extensionauth.NewServer`,
  - `extensionauth.ServerOption` and all its implementations and
  - `configauth.Authenticator.GetClientAuthenticator`.
  
- `exporterhelper`: Remove deprecated converter types from exporterhelper (#12686)
- `exporterbatch`: Remove deprecated fields `min_size_items` and `max_size_items` from batch config. (#12684)

### 🚩 Deprecations 🚩

- `exporterhelper`: Deprecate BatcherConfig, SizeConfig and WithBatcher in favor of the new QueueBatchConfig. (#12748)
- `exporterbatcher`: Deprecated Config, SizeConfig, SizerType, SizerType[Requests|Items|Bytes], NewDefaultConfig. Use alias from exporterhelper. (#12707)
- `exporterqueue`: Deprecated Config, NewDefaultConfig, Encoding, ErrQueueFull. Use alias from exporterhelper. (#12706)
- `exporterhelper`: Deprecate exporterhelper WithRequestQueue in favor of WithQueueBatch (#12679)
- `exporterhelper`: Deprecate `QueueConfig` in favor of `QueueBatchConfig`. (#12746)

### 💡 Enhancements 💡

- `extensionauth`: Mark module as stable (#11006)
- `processor`: Mark module as stable. (#12677)
- `processorhelper`: Split processorhelper into a separate module. (#12678)

<!-- previous-version -->

## v1.28.1/v0.122.1

<!-- previous-version -->

## v1.28.0/v0.122.0

### 🛑 Breaking changes 🛑

- `auth, authtest`: Remove deprecated modules extension/auth and extension/auth/authtest (#12543)
  Use extension/extensionauth and extension/extensionauth/extensionauthtest instead.
  
- `extensionauth`: Remove deprecated methods from the `Func` types. (#12547)
- `extensiontest, connectortest, processortest, receivertest, scrapertest, exportertest`: Remove deprecated `NewNopSettingsWithType` functions, use `NewNopSettings` instead. (#12221)
- `extensionauthtest`: Remove the `extensionauthtest.MockClient` struct. (#12567)
  - Use `extensionauthtest.NewNopClient` to create a client with a noop implementation. 
  - Use `extensionauthtest.NewErrorClient` to create a client that always returns an error.
  - Implement the `extensionauth` interfaces for custom mock client implementations.
  
- `component/componenttest`: Remove the deprecated componenttest.TestTelemetry in favor of componenttest.Telemetry (#12419)
- `exporterhelper`: Remove the Request.Export function in favor of an equivalent request consume func in the New[Traces|Metrics|Logs|Profiles]Request (#12637)

### 🚩 Deprecations 🚩

- `exporterhelper`: Deprecate per signal converter in favor of generic version (#12631)
- `extensionauth`: Deprecate `extensionauth.NewClient` and `extensionauth.NewServer`. (#12574)
  - Manually implement the interfaces instead.
  
- `configauth`: Deprecate `configauth.Authenticator.GetClientAuthenticator`. (#12574)
  - Use the per-protocol methods instead.
  

### 🚀 New components 🚀

- `receiverhelper`: Split `receiverhelper` into a separate module (#28328)

### 💡 Enhancements 💡

- `cmd/mdatagen`: Add `supportsSignal` func for `Metadata` type in `mdatagen`. (#12640)
- `receiver`: Mark module as stable (#12513)
- `pdata/pcommon`: Introduce `Equal()` method for comparison equality to `Value`, `ByteSlice`, `Float64Slice`, `Int32Slice`, `Int64Slice`, `StringSlice`, `Uint64Slice`, `Map` and `Slice` (#12594)
- `pdata`: Add iterator All method to pdata slices and map types. (#11982)
- `pdata/pprofile`: Introduce AddAttribute helper method to modify the content of attributable records (#12206)

<!-- previous-version -->

## v1.27.0/v0.121.0

### 🛑 Breaking changes 🛑

- `exporterqueue`: Remove exporterqueue.Factory in favor of the NewQueue function, and merge configs for memory and persistent. (#12509)
  As a side effect of this change, no alternative implementation of the queue are supported and the Queue interface will be hidden.
- `exporterhelper`: Update MergeSplit function signature to use the new SizeConfig (#12486)
- `extension, connector, processor, receiver, exporter, scraper`: Remove deprecated `Create*` methods from `Create*Func` types. (#12305)
  The `xconnector.CreateMetricsToProfilesFunc.CreateMetricsToProfiles` method has been removed without a deprecation.
  
- `component`: Remove deprecated function and interface `ConfigValidator` and `ValidateConfig`. (#11524)
  - Use `xconfmap.Validator` and `xconfmap.Validate` instead.
  
- `receiver, scraper, processor, exporter, extension`: Remove deprecated MakeFactoryMap functions in favor of generic implementation (#12222)
- `exporterhelper`: Change the signature of the exporterhelper.WithQueueRequest to accept Encoding instead of the Factory. (#12509)
- `component/componenttest`: Removing the deprecated `CheckReceiverMetrics` and `CheckReceiverTraces` functions. (#12185)

### 🚩 Deprecations 🚩

- `componenttest`: Deprecated componenttest.TestTelemetry in favor of componenttest.Telemetry (#12419)
- `connector, exporter, extension, processor, receiver, scraper`: Add type parameter to `NewNopSettings` and deprecate `NewNopSettingsWithType` (#12305)
- `exporterhelper`: Deprecate MinSizeConfig and MaxSizeItems. (#12486)
- `extension/extensionauth`: Deprecate methods on `*Func` types. (#12480)
- `extension/auth, extension/auth/authtest`: Deprecate extension/auth and the related test module in favor of extension/extensionauth (#12478)

### 🚀 New components 🚀

- `service/hostcapabilities`: create `service/hostcapabilities` module (#12296, #12375)
  Removes getExporters interface in service/internal/graph.
  Removes getModuleInfos interface in service/internal/graph.
  Creates interface ExposeExporters in service/hostcapabilities to expose GetExporters function.
  Creates interface ModuleInfo in service/hostcapabilities to expose GetModuleInfos function.
  

### 💡 Enhancements 💡

- `exporterhelper`: Adds the config API to support serialized bytes based batching (#3262)
- `configauth`: Add the `omitempty` mapstructure tag to struct fields (#12191)
  This results in unset fields not being rendered when marshaling.
- `confighttp`: Add the `omitempty` mapstructure tag to struct fields (#12191)
  This results in unset fields not being rendered when marshaling.
- `otelcol`: Converters are now available in the `components` command. (#11900, #12385)
- `extension`: Mark module as stable (#11005)
- `pcommon.Map`: preallocate go map in Map.AsRaw() (#12406)
- `exporterhelper`: Stabilize exporter.UsePullingBasedExporterQueueBatcher and remove old batch sender (#12425)
- `service`: Add the `omitempty` mapstructure tag to struct fields (#12191)
  This results in unset fields not being rendered when marshaling.

### 🧰 Bug fixes 🧰

- `mdatagen`: Fix broken imports in the generated files. (#12298)
- `processor, connector, exporter, receiver`: Explicitly error out at component creation time if there is a type mismatch. (#12305)

## v1.26.0/v0.120.0

### 🛑 Breaking changes 🛑

- `configauth`: Remove NewDefaultAuthentication (#12223)
  The value returned by this function will always cause an error on startup.
  In `configgrpc.Client/ServerConfig.Auth`, `nil` should be used instead to disable authentication.
  
- `otelcol`: Make the `ConfigProvider` interface a struct (#12297)
  Calls to `NewConfigProvider` will now return `*ConfigProvider`,
  but will otherwise work the same as before.
  
- `extension`: Remove `extension.Settings.ModuleInfo` (#12296)
  - The functionality is now available as an optional, hidden interface on `service`'s implementation of the `Host`
  
- `component`: Remove deprecated field `component.TelemetrySettings.MetricsLevel`. (#11061)
- `confighttp`: Add `ToClientOption` type and add it to signature of `ToClient` method. (#12353)
  - This has no use for now, it may be used in the future.
  
- `mdatagen`: Remove unused not_component config for mdatagen (#12237)

### 🚩 Deprecations 🚩

- `component/componenttest`: Deprecate CheckReceiverMetrics in componenttest (#12185)
  Use the `metadatatest.AssertEqualMetric` series of functions instead of `obsreporttest.CheckReceiverMetrics`
- `component/componenttest`: Deprecate CheckReceiverTraces in componenttest (#12185)
  Use the `metadatatest.AssertEqualMetric` series of functions instead of `obsreporttest.CheckReceiverTraces`
- `component`: Deprecate `ConfigValidator` and `ValidateConfig` (#11524)
  Please use `Validator` and `Validate` respectively from `xconfmap`.
- `receiver, scraper, processor, exporter, extension`: Deprecate existing MakeFactoryMap functions in favor of generic implementation (#12222)
- `extension, connector, processor, receiver, exporter, scraper`: Deprecate `Create*` methods from `Create*Func` types. (#12305)
- `extensiontest, connectortest, processortest, receivertest, exportertest, scrapertest`: Deprecate `*test.NewNopSettings` in favor of `*test.NewNopSettingsWithType` (#12305)

### 🚀 New components 🚀

- `xconfmap`: Create the xconfmap module and add the `Validator` interface and `Validate` function to facilitate config validation (#11524)

### 💡 Enhancements 💡

- `configgrpc`: Add the `omitempty` mapstructure tag to struct fields (#12191)
  This results in unset fields not being rendered when marshaling.
- `confignet`: Add the `omitempty` mapstructure tag to struct fields (#12191)
  This results in unset fields not being rendered when marshaling.
- `configtls`: Add the `omitempty` mapstructure tag to struct fields (#12191)
  This results in unset fields not being rendered when marshaling.
- `consumer`: Clarify that data cannot be accessed after Consume* func is called. (#12284)
- `pdata/pprofile`: Introduce aggregation temporality constants (#12253)

### 🧰 Bug fixes 🧰

- `configgrpc`: Apply configured Headers automatically (#12307)
  configgrpc now calls metadata.AppendToOutgoingContext automatically in an interceptor.
  Components that were manually using metadata.NewOutgoingContext as a workaround no longer need to
  do so, unless they are overwriting or adding header keys.
  
- `configgrpc`: Set Auth to nil in NewDefaultClientConfig/NewDefaultServerConfig (#12223)
  The value that was used previously would always cause an error on startup.
  
- `exporterqueue`: Fix async queue to propagate cancellation all they way to the queue (#12282)
- `otlpreceiver`: Fix OTLP http receiver to correctly set Retry-After (#12367)
- `extension`: Explicitly error out at extension creation time if there is a type mismatch. (#12305)

## v1.25.0/v0.119.0

### 🛑 Breaking changes 🛑

- `exporterhelper`: Change queue to embed the async consumers. (#12242)
- `exporterqueue`: Change Queue interface to return a callback instead of an index (#8122)
- `cmd/mdatagen`: Allow passing OTel Metric SDK options to the generated `SetupTelemetry` function. (#12166)
- `exporterhelper`: Rename exporter span signal specific attributes (e.g. "sent_spans" / "send_failed_span") to "items.sent" / "items.failed". (#12165)
- `component`: Change underlying type for `component.Kind` to be a struct. (#12214)
- `extension`: Change `extension.Extension` to be an interface that embeds `component.Component` instead of an alias (#11443)
- `component/componenttest`: Remove deprecated `CheckScraperMetrics` functions (#12183)
- `scraperhelper`: Remove deprecated ScrapperControllerOption and NewScraperControllerMetrics from scraperhelper. (#12147)

### 🚩 Deprecations 🚩

- `metadatatest`: Deprecate metadatatest.Telemetry in favor of componenttest.Telemetry (#12218)
  metadatatest.Telemetry -> componenttest.Telemetry |
  metadatatest.SetupTelemetry -> componenttest.NewTelemetry |
  metadatatest.Telemetry.NewSettings -> metadatatest.NewSettings |
  metadatatest.Telemetry.AssertMetrics -> metadatatest.AssertEqual* |
  
- `component/componenttest`: Deprecate `CheckExporterEnqueue*` functions in componenttest (#12185)
  Use the `metadatatest.AssertEqualMetric` series of functions instead of `obsreporttest.CheckExporterEnqueue*` functions.
- `component/componenttest`: Deprecate CheckExporterLogs in componenttest (#12185)
  Use the `metadatatest.AssertEqualMetric` series of functions instead of `obsreporttest.CheckExporterLogs`
- `component/componenttest`: Deprecate CheckExporterMetricGauge in componenttest (#12185)
  Use the `metadatatest.AssertEqualMetric` series of functions instead of `obsreporttest.CheckReceiverMetricGauge`
- `component/componenttest`: Deprecate CheckExporterMetrics in componenttest (#12185)
  Use the `metadatatest.AssertEqualMetric` series of functions instead of `obsreporttest.CheckExporterMetrics`
- `component/componenttest`: Deprecate CheckExporterTraces in componenttest (#12185)
  Use the `metadatatest.AssertEqualMetric` series of functions instead of `obsreporttest.CheckExporterTraces`
- `component/componenttest`: Deprecate CheckReceiverLogs in componenttest (#12185)
  Use the `metadatatest.AssertEqualMetric` series of functions instead of `obsreporttest.CheckReceiverLogs`
- `mdatagen`: Make registration of callback for async metric always optional. (#12204)
  Deprecate `metadata.TelemetryBuilder.Init*` and `metadata.With*Callback` in favor of `metadata.TelemetryBuilder.Register*Callback`
- `component`: Deprecate `component.TelemetrySettings.MetricsLevel` in favor of using views and 'Enabled' method. (#12159)
  - Components will temporarily need the service to support using views.
  

### 💡 Enhancements 💡

- `componenttest`: Add helper to get a metric for componenttest.Telemetry (#12215)
- `componenttest`: Extract componenttest.Telemetry as generic struct for telemetry testing (#12151)
- `mdatagen`: Generate assert function for each metric in mdatagen (#12179)
- `metadatatest`: Generate NewSettings that accepts componenttest.Telemetry (#12216)
- `pdata/pprofile`: Add new helper method `FromAttributeIndices` to build a `pcommon.Map` out of `AttributeIndices`. (#12176)
- `scraper`: Support logs scraper (#12116)
- `component`: Allow `component.ValidateConfig` to recurse through all fields in a config object (#11524)
- `component`: Show path to invalid config in errors returned from `component.ValidateConfig` (#12108)

### 🧰 Bug fixes 🧰

- `mdatagen`: All register callbacks to async instruments can now be unregistered by calling `metadata.TelemetryBuilder.Shutdown()` (#12204)
- `mdatagen`: Fix bug where Histograms were marked as not supporting temporal aggregation (#12168)

## v1.24.0/v0.118.0

### 🛑 Breaking changes 🛑

- `exporterqueue`: Change Queue Size and Capacity to return explicit int64. (#12076)
- `receiver/scraperhelper`: Removing the deprecated receiver/scraperhelper package (#12054)
- `processortest`: Revert the nop_processor.NewNopSettings change, as it is no longer needed (#11433)
- `experimental/storage`: Remove deprecated package/module experimental/storage (#12109)
- `mdatagen`: Remove deprecated generated_component_telemetry_test file from being generated and delete it. (#12068)
- `receivertest`: Remove deprecated receivertest.NewNopFactoryForType (#12110)

### 🚩 Deprecations 🚩

- `componenttest`: Deprecate CheckScraperMetrics in componenttest (#12105)
  Use `metadatatest.AssertMetrics` instead of `obsreporttest.CheckScraperMetrics`
- `scraperhelper`: Deprecate `scraperhelper.NewScraperControllerReceiver` and `scraperhelper.ScraperControllerOption`. (#12103)
  Use `scraperhelper.NewMetricsController` instead of `scraperhelper.NewScraperControllerReceiver` | Use `scraperhelper.ScraperControllerOption` instead of `scraperhelper.ControllerOption`

### 💡 Enhancements 💡

- `exporterhelper`: Add capability for memory and persistent queue to block when add items (#12074)
- `scraper/scraperhelper`: Add obs_logs for scraper/scraperhelper (#12036)
  This change adds obs for logs in scraper/scraperhelper, also introduced new metrics for scraping logs.
- `mdatagen`: Add scraper component type support to mdatagen (#12092)
- `mdatagen`: Add tracing support in metadatatest (#12106)
- `exporterhelper`: Change persistent queue to not use sized channel, improve memory usage and simplify sized_channel. (#12060)
- `confighttp`: Added support for configuring compression levels. (#10467)
  A new configuration option called CompressionParams has been added to confighttp. | This allows users to configure the compression levels for the confighttp client.

## v1.23.0/v0.117.0

### 🛑 Breaking changes 🛑

- `pdata/pprofile`: Remove duplicate Attributes field from profile (#11932)
- `connector`: Remove deprecated connectorprofiles module, use xconnector instead. (#11778)
- `consumererror`: Remove deprecated consumererrorprofiles module, use xconsumererror instead. (#11778)
- `consumer`: Remove deprecated consumerprofiles module, use xconsumer instead. (#11778)
- `exporterhelper`: Remove deprecated exporterhelperprofiles module, use xexporterhelper instead. (#11778)
- `exporter`: Remove deprecated exporterprofiles module, use xexporter instead. (#11778)
- `pipeline`: Remove deprecated pipelineprofiles module, use xpipeline instead. (#11778)
- `processorhelper`: Remove deprecated processorhelperprofiles module, use xprocessorhelper instead. (#11778)
- `processor`: Remove deprecated processorprofiles module, use xprocessor instead. (#11778)
- `receiver`: Remove deprecated receiverprofiles module, use xreceiver instead. (#11778)
- `exporterhelper`: Remove Merge function from experimental Request interface (#12012)

### 🚩 Deprecations 🚩

- `mdatagen`: Deprecate component_test in favor of metadatatest (#11812)
- `receivertest`: Deprecate receivertest.NewNopFactoryForType (#11993)
- `extension/experimental`: Deprecate extension/experimental in favor of extension/xextension (#12010)
- `scraperhelper`: Move scraperhelper under scraper and in a separate module. (#11003)

### 💡 Enhancements 💡

- `scrapertest`: Add scrapertest package in a separate module (#11988)
- `pdata`: Upgrade pdata to opentelemetry-proto v1.5.0 (#11932)

## v1.22.0/v0.116.0

### 🛑 Breaking changes 🛑

- `component`: Remove deprecated TelemetrySettings.LeveledMeterProvider (#11811)
- `scraperhelper`: Remove deprecated scraperhelper.Scraper and helpers (#11803)

### 🚩 Deprecations 🚩

- `connector`: Deprecate connectorprofiles module in favor of xconnector to allow adding more experimental data types. (#11778)
- `consumererror`: Deprecate consumererrorprofiles module in favor of xconsumererror to allow adding more experimental data types. (#11778)
- `consumer`: Deprecate consumerprofiles module in favor of xconsumer to allow adding more experimental data types. (#11778)
- `exporterhelper`: Deprecate exporterhelperprofiles module in favor of xexporterhelper to allow adding more experimental data types. (#11778)
- `exporter`: Deprecate exporterprofiles module in favor of xexporter to allow adding more experimental data types. (#11778)
- `pipeline`: Deprecate pipelineprofiles module in favor of xpipeline to allow adding more experimental data types. (#11778)
- `processorhelper`: Deprecate processorhelperprofiles module in favor of xprocessorhelper to allow adding more experimental data types. (#11778)
- `processor`: Deprecate processorprofiles module in favor of xprocessor to allow adding more experimental data types. (#11778)
- `receiver`: Deprecate receiverprofiles module in favor of xreceiver to allow adding more experimental data types. (#11778)
- `receiver/scrapererror`: Remove the receiver/scrapererror alias. (#11003)

### 💡 Enhancements 💡

- `receiver/scraperhelper`: Add scraper for logs (#11238)

## v1.21.0/v0.115.0

### 🛑 Breaking changes 🛑

- `extension/auth/authtest`: `authtest` is now its own module (#11465, #11705)
- `pdata/pprofile`: AttributeTable is now a slice rather than a map (#11706)
- `scraperhelper`: Remove deprecated scraperhelper funcs Scraper.ID, NewScraper, AddScraper. (#11710)
- `mdatagen`: Remove deprecated LeveledMeter from the generated code (#11696)

### 🚩 Deprecations 🚩

- `component`: Mark `TelemetrySettings.LeveledMeterProvider` as deprecated (#11697)
- `receiver/scraper`: Move receiver/scrapererror package to scraper/scrapererror and deprecate original receiver/scrapererror package. (#11003)
- `scraperhelper`: Make Scraper compatible with the new scraper.Metrics (#11682)
  Deprecate scraperhelper.Scraper in favor of scraper.Metrics

## v1.20.0/v0.114.0

### 🛑 Breaking changes 🛑

- `extensiontest`: Make extensiontest into its own module (#11463)
- `component`: Make componenttest into its own module (#11464)
- `expandconverter`: Remove deprecated expandvar converter (#11672)
- `exporter`: Remove deprecated funcs Create[*]Exporter and [*]ExporterStability (#11662)
- `exporterhelper`: Remove deprecated NewLogs[Request]Exporter funcs (#11661)
- `extension`: Remove deprecated funcs CreateExtension and ExtensionStability (#11663)
- `processortest`: Remove deprecated func NewUnhealthyProcessorCreateSettings (#11665)

### 🚩 Deprecations 🚩

- `component`: Deprecate `TelemetrySettings.LeveledMeterProvider` and undo deprecation of `TelemetrySettings.MeterProvider` (#11061)
- `scraperhelper`: Deprecate Scraper.ID func, pass type when register Scraper (#11238)

## v1.19.0/v0.113.0

### 🛑 Breaking changes 🛑

- `builder`: Remove deprecated flags from Builder (#11576)
  Here is the list of flags | --name, --description, --version, --otelcol-version, --go, --module

### 🚀 New components 🚀

- `processorhelperprofiles`: Add processorhelperprofiles to support profiles signal (#11556)

### 💡 Enhancements 💡

- `mdatagen`: Add newTelemetrySettings to be generated all the time even for pkg class (#11535)
- `debugexporter`: Add profiles support to debug exporter (#11155)
- `component`: Add UnmarshalText for StabilityLevel (#11520)

## v1.18.0/v0.112.0

### 🛑 Breaking changes 🛑

- `service`: Change Host to not implement GetExportersWithSignal (#11444)
  Use Host.GetExporters if still needed.
- `componentstatus`: Remove deprecated `NewInstanceIDWithPipelineIDs`, `AllPipelineIDsWithPipelineIDs`, and `WithPipelineIDs`. Use `NewInstanceID`, `AllPipelineIDs` and `WithPipelines` instead. (#11363)
- `configgrpc`: Removed deprecated `ClientConfig.ToClientConnWithOptions`/`ServerConfig.ToServerWithOptions`. (#11359, #9480)
  These methods were renamed to `ClientConfig.ToClientConn`/`ServerConfig.ToServer` in v0.111.0.
- `connector`: Put connectortest in its own module (#11216)
- `exporter`: Disables setting batch option to batch sender directly. (#10368)
  Removed WithRequestBatchFuncs(BatcherOption) in favor of WithBatchFuncs(Option), where | BatcherOption is a function that operates on batch sender and Option is one that operates | on BaseExporter
- `exporter`: Made mergeFunc and mergeSplitFunc required method of exporter.Request (#10368)
  mergeFunc and mergeSplitFunc used to be part of the configuration pass to the exporter. Now it is changed | to be a method function of request.
- `componentprofiles`: Move componentprofiles to pipelineprofiles (#11421)
- `processor`: Put processortest in its own module (#11218)
- `receivertest`: Removed deprecated `NewNopFactoryForTypeWithSignal`. Use `NewNopFactoryForType` instead. (#11362)
- `processor`: Remove deprecated funcs from processor package (#11368)
- `receiver`: Remove deprecated funcs from receiver package (#11367)
- `processorhelper`: Remove deprecated funcs/types from processorhelper & componenttest (#11302)
- `service`: Remove deprecated `pipelines.ConfigWithPipelineID` and `Config.PipelinesWithPipelineID`. Use `pipelines.Config` and `Config.Pipelines` instead. (#11361)

### 🚩 Deprecations 🚩

- `extension`: Deprecate funcs that repeat extension in name (#11413)
  Factory.CreateExtension -> Factory.Create |
  Factory.ExtensionStability -> Factory.Stability
  
- `exporter`: Deprecate funcs that repeat exporter in name (#11370)
  Factory.Create[Traces|Metrics|Logs|Profiles]Exporter -> Factory.Create[Traces|Metrics|Logs|Profiles] |
  Factory.[Traces|Metrics|Logs|Profiles]ExporterStability -> Factory.[Traces|Metrics|Logs|Profiles]Stability
  

### 🚀 New components 🚀

- `consumererrorprofiles`: Add new module consumererrorprofiles for consumer error profiles. (#11131)

### 💡 Enhancements 💡

- `configcompression`: Add support for lz4 compression (#9128)
- `otlpexporter`: Add profiles support to OTLP exporter (#11435)
- `otlphttpexporter`: Add profiles support to OTLP HTTP exporter (#11450)

## v1.17.0/v0.111.0

### 🛑 Breaking changes 🛑

- `service/telemetry`: Change default metrics address to "localhost:8888" instead of ":8888" (#11251)
  This behavior can be disabled by disabling the feature gate 'telemetry.UseLocalHostAsDefaultMetricsAddress'.
- `componentprofiles`: Removed deprecated `DataTypeProfiles`.  Use `SignalProfiles` instead. (#11312)
- `configgrpc`: Replace ToClientConn and ToServer with ToClientConnWithOptions and ToServerWithOptions. (#11271, #9480)
  `ClientConfig.ToClientConn` and `ServerConfig.ToServer` were deprecated in v0.110.0 in favor of
  `ClientConfig.ToClientConnWithOptions` and `ServerConfig.ToServerWithOptions` which use a more
  flexible option type. The original functions are now removed, and the new ones are renamed to the
  old names. The `WithOptions` names are kept as deprecated aliases for now.
  
- `exporterhelper`: Removed deprecated `QueueTimeout`/`TimeoutSettings` aliases in favor of `QueueConfig`/`TimeoutConfig`. (#11264, #6767)
  `NewDefaultQueueSettings` and `NewDefaultTimeoutSettings` have been similarly renamed.
- `exporterqueue`: Remove deprecated `Settings.DataType`. Use `Settings.Signal` instead. (#11305)
- `exportertest`: Remove deprecated `CheckConsumeContractParams.DataType`. Use `CheckConsumeContractParams.Signal` instead. (#11305)
- `component`: Removed deprecated `ErrDataTypeIsNotSupported`, `DataType`, `DataTypeTraces`, `DataTypeMetrics`, and `DataTypeLogs`.  Use `pipeline.ErrSignalNotSupported`, `pipeline.Signal`, `pipeline.SignalTraces`, `pipeline.SignalMetrics`, and `pipeline.SignalLogs` instead. (#11253)
- `pdata/pprofile`: Replace slices of values to slices of pointers for the `Mapping`, `Location`, `Line`, `Function`, `AttributeUnit`, `Link`, `Value`, `Sample` and `Labels` attributes. (#11339)
- `receivertest`: Remove deprecated `CheckConsumeContractParams.DataType`. Use `CheckConsumeContractParams.Signal` instead. (#11304)
- `scraperhelper`: Remove deprecated function `NewScraperWithComponentType`. (#11294)
- `processorhelper`: Remove deprecated funcs form processorhelper.ObsReport (#11289)
  The "otelcol_processor_dropped_log_records", "otelcol_processor_dropped_log_records" | and "otelcol_processor_dropped_spans" metrics are complete removed, before they were always record with 0 values.

### 🚩 Deprecations 🚩

- `componentstatus`: Deprecated `NewInstanceIDWithPipelineIDs`, `AllPipelineIDsWithPipelineIDs`, and `WithPipelineIDs`. Use `NewInstanceID`, `AllPipelineIDs`, and `WithPipelines` instead. (#11313)
- `processorhelper`: Deprecate unused and empty struct processorhelper.ObsReport (#11293)
- `processor`: Deprecate funcs that repeat "processor" in name (#11310)
  Factory.Create[Traces|Metrics|Logs|Profiles]Processor -> Factory.Create[Traces|Metrics|Logs|Profiles]
  Factory.[Traces|Metrics|Logs|Profiles]ProcessorStability -> Factory.[Traces|Metrics|Logs|Profiles]Stability
  
- `receiver`: Deprecate funcs that repeat "receiver" in name (#11287)
  Factory.Create[Traces|Metrics|Logs|Profiles]Receiver -> Factory.Create[Traces|Metrics|Logs|Profiles]
  Factory.[Traces|Metrics|Logs|Profiles]ReceiverStability -> Factory.[Traces|Metrics|Logs|Profiles]Stability
  
- `receivertest`: Deprecated `NewNopFactoryForTypeWithSignal`. Use `NewNopFactoryForType` instead. (#11304)
- `service`: Deprecates `Config.PipelinesWithPipelineID`, `pipelines.ConfigWithPipelineID` and `GetExportersWithSignal` interface implementation. Use `Config.Pipelines`, `pipelines.Config`, and `GetExporters` interface implementation instead. (#11303)

## v1.16.0/v0.110.0

### 🛑 Breaking changes 🛑

- `otlpexporter`: The `TimeoutSettings` field in `otlpexporter.Config` was renamed to `TimeoutConfig`. (#11132)
- `connector`: Change `TracesRouterAndConsumer`, `NewTracesRouter`, `MetricsRouterAndConsumer`, `NewMetricsRouter`, `LogsRouterAndConsumer`, and `NewLogsRouter` to use `pipeline.ID` instead of `component.ID`. (#11204)
- `extension`: Remove deprecated extension interfaces. (#11043)
  They are now available in the `extensioncapabilities` module.
  

### 🚩 Deprecations 🚩

- `exporterhelper`: Deprecate TimeoutSettings/QueueSettings in favor of TimeoutConfig/QueueConfig. (#6767)
- `configgrpc`: Deprecate `ClientConfig.ToClientConn`/`ServerConfig.ToServer` in favor of `ToClientConnWithOptions`/`ToServerWithOptions` (#9480)
  Users providing a grpc.DialOption/grpc.ServerOption should now wrap them into
  a generic option with `WithGrpcDialOption`/`WithGrpcServerOption`.
  
- `componentprofiles`: Deprecates `DataTypeProfiles`. Use `SignalProfiles` instead. (#11204)
- `componentstatus`: Deprecates `NewInstanceID`, `AllPipelineIDs`, and `WithPipelines`. Use `NewInstanceIDWithPipelineIDs`, `AllPipelineIDsWithPipelineIDs`, and `WithPipelineIDs` instead. (#11204)
- `exporterqueue`: Deprecates `Settings.DataType`. Use `Settings.Signal` instead. (#11204)
- `service`: Deprecates `pipelines.Config`. Use `pipelines.ConfigWithPipelineID` instead. (#11204)
- `component`: Deprecates `DataType`, `DataTypeTraces`, `DataTypeMetrics`, and `DataTypeLogs`. Use `pipeline.Signal`, `SignalTraces`, `SignalMetrics`, and `SignalLogs` instead. (#11204)
- `service`: Deprecates service's implementation of `GetExporters` interface.  Use `GetExportersWithSignal` instead. (#11249)
- `scraperhelper`: Deprecate NewScraperWithComponentType, should use NewScraper (#11159)

### 🚀 New components 🚀

- `pipeline`: Adds new `pipeline` module to house the concept of pipeline ID and Signal. (#11209)

### 💡 Enhancements 💡

- `pdata`: Add support to MoveTo for Map, allow avoiding copies (#11175)
- `options`: Avoid using private types in public APIs and also protect options to be implemented outside this module. (#11054)
- `mdatagen`: Avoid using private types in public APIs and also protect options to be implemented outside this module. (#11040)
- `consumertest`: Introduce SampleCount method in ProfilesSink struct. (#11225)
- `otlpreceiver`: Support profiles in the OTLP receiver (#11071)

## v1.15.0/v0.109.0

### 🛑 Breaking changes 🛑

- `Remove `extensiontest` StatusWatcher helpers`: They were unused. They may be added back on a different module or after `componentstatus` is marked 1.0
 (#11044)
- `pprofile`: Change Profile ID field from a byte array to a custom data type (#11048)
- `connector`: Remove deprecated connector builder (#11019)
- `exporter`: Remove deprecated exporter builder (#11019)
- `extension`: Remove deprecated extension builder (#11019)
- `processor`: Remove deprecated processor builder (#11019)
- `receiver`: Remove deprecated receiver builder (#11019)

### 🚩 Deprecations 🚩

- `configtelemetry`: Deprecating `TelemetrySettings.MeterProvider` in favour of `TelemetrySettings.LeveledMeterProvider` (#10912)
- `extension`: Deprecate `extension.ConfigWatcher`, `extension.PipelineWatcher` and `extension.Dependent` in favor of equivalents in the `extensioncapabilities` module. (#11000)
- `scraperhelper`: deprecate NewScraper, should use NewScraperWithComponentType (#11082)

### 🚀 New components 🚀

- `extensioncapabilities`: Create a new module for optional extension capabilities. (#11000)

### 💡 Enhancements 💡

- `connectorprofiles`: Add ProfilesRouterAndConsumer interface, and NewProfilesRouter method. (#11023)
- `pprofileotlp`: Introduce grpc service implementation of pprofileotlp (#11048)
- `pprofile`: Introduce marshalling and unmarshalling of pprofile data (#11048)
- `service`: Support profiles in the service package (#11024)

## v1.14.1/v0.108.1

## v1.14.0/v0.108.0

### 🛑 Breaking changes 🛑

- `extensions`: Remove `StatusWatcher` interface.  Use `componentstatus.Watcher` instead. (#10777)
- `component`: Removed Status related types and functions.  Use `componentstatus` instead. (#10777)
- `component`: Remove `ReportStatus` from `TelemetrySettings`. Use `componentstatus.ReportStatus` instead. (#10777)
- `componentstatus`: Make componentstatus.InstanceID immutable. (#10494)

### 🚩 Deprecations 🚩

- `scraperhelper`: deprecate NewObsReport, ObsReport, ObsReportSettings, scrapers should use NewScraperControllerReceiver (#10959)
- `mdatagen`: Deprecating generated `Meter` func in favour of `LeveledMeter` (#10939)
- `connector`: Deprecate connector.Builder, and move it into an internal package of the service module (#10784)
- `exporter`: Deprecate exporter.Builder, and move it into an internal package of the service module (#10783)
- `extension`: Deprecate extension.Builder, and move it into an internal package of the service module (#10785)
- `processor`: Deprecate processor.Builder, and move it into an internal package of the service module (#10782)
- `receiver`: Deprecate receiver.Builder, and move it into an internal package of the service module (#10781)

## v1.13.0/v0.107.0

### 🛑 Breaking changes 🛑

- `otelcol`: Delete deprecated NewCommandMustSetProvider (#10778)
- `component`: Removes the deprecated `Host.GetFactory` method. (#10771)
- `otelcoltest`: The `otelcol.LoadConfig` method no longer sets the `expandconverter`. (#10510)
- `ocb`: Collectors built with OCB will no longer include the `expandconverter` (#10510)
- `exporterhelper`: Delete deprecated `exporterhelper.ObsReport` and `exporterhelper.NewObsReport` (#10779, #10592)

### 🚩 Deprecations 🚩

- `expandconverter`: Deprecate `expandconverter`. (#10510)

### 🚀 New components 🚀

- `componentstatus`: Adds new componentstatus module that will soon replace status content in component. (#10730)
- `connector/connectorprofiles`: Allow handling profiles in connector. (#10703)
- `exporter/exporterprofiles`: Allow handling profiles in exporter. (#10702)
- `processor/processorprofiles`: Allow handling profiles in processor. (#10691)
- `receiver/receiverprofiles`: Allow handling profiles in receiver. (#10690)

### 💡 Enhancements 💡

- `confmap`: Check that providers have a correct scheme when building a confmap.Resolver. (#10786)
- `confighttp`: Add `NewDefaultCORSConfig` function to initialize the default `confighttp.CORSConfig` (#9655)

## v0.106.0

### 🛑 Breaking changes 🛑

- `configauth`: removing deprecated methods GetServerAuthenticatorContext and GetClientAuthenticatorContext (#9808)
- `connector,exporter,receiver,extension,processor`: Remove deprecated funcs/structs (#10423)
  Remove the following funcs & structs:
  - connector.CreateSettings -> connector.Settings
  - connectortest.NewNopCreateSettings -> connectortest.NewNopSettings
  - exporter.CreateSettings -> exporter.Settings
  - exportertest.NewNopCreateSettings -> exportertest.NewNopSettings
  - extension.CreateSettings -> extension.Settings
  - extensiontest.NewNopCreateSettings -> extensiontest.NewNopSettings
  - processor.CreateSettings -> processor.Settings
  - processortest.NewNopCreateSettings -> processortest.NewNopSettings
  - receiver.CreateSettings -> receiver.Settings
  - receivertest.NewNopCreateSettings -> receivertest.NewNopSettings
  
- `component/componenttest`: Add optional ...attribute.KeyValue argument to TestTelemetry.CheckExporterMetricGauge. (#10593)
- `confighttp`: Auth data type signature has changed (#4806)
  As part of the linked PR, the `auth` attribute was moved from `configauth.Authentication` 
  to a new `AuthConfig`, which contains a `configauth.Authentication`. For end-users, this
  is a non-breaking change. For users of the API, create a new AuthConfig using the
  `configauth.Authentication` instance that was being used before.
  
- `mdatagen`: Remove WithAttributes option from the telemetry builder constructor. (#10608)
  Attribute sets for async instruments now can be set as options to callback setters and async instruments initializers.
  This allows each async instrument to have its own attribute set.
  
- `service/extensions`: Adds `Options` to `extensions.New`. (#10728)
  This is only a breaking change if you are depending on `extensions.New`'s signature. Calls to `extensions.New` are not broken.

### 🚩 Deprecations 🚩

- `component`: Deprecates Host.GetFactory. (#10709)

### 🚀 New components 🚀

- `component/componentprofiles`: Add componentprofiles module. (#10525)

### 💡 Enhancements 💡

- `exporter, processor, receiver`: Document factory functions. (#9323)
- `component`: Document status enums and New constructors (#9822)
- `confighttp, configgrpc`: Remove the experimental comment on `IncludeMetadata` in confighttp and configgrpc (#9381)
- `confighttp`: Add `confighttp.NewDefaultServerConfig()` to instantiate the default HTTP server configuration (#9655)
- `consumer/consumertest`: Allow testing profiles with consumertest. (#10692)

### 🧰 Bug fixes 🧰

- `confmap`: Fix wrong expansion of environment variables escaped with `$$`, e.g. `$${ENV_VAR}` and `$$ENV_VAR`. (#10713)
  This change fixes the issue where environment variables escaped with $$ were expanded. 
  The collector now converts `$${ENV_VAR}` to `${ENV_VAR}` and `$$ENV_VAR` to `$ENV_VAR` without further expansion.
  

## v1.12.0/v0.105.0

### 🛑 Breaking changes 🛑

- `otelcol`: Obtain the Collector's effective config from otelcol.Config (#10139)
  `otelcol.Collector` will now marshal `confmap.Conf` objects from `otelcol.Config` itself.
- `otelcoltest`: Remove deprecated methods `LoadConfigWithSettings` and `LoadConfigAndValidateWithSettings` (#10512)

### 🚩 Deprecations 🚩

- `configauth`: Deprecated `Authentication.GetClientAuthenticatorContext` and `Authentication.GetServerAuthenticatorContext` (#10578)
- `otelcol`: Deprecate `otelcol.ConfmapProvider` (#10139)
  `otelcol.Collector` will now marshal `confmap.Conf` objects from `otelcol.Config` itself.
- `otelcol`: Deprecate `(*otelcol.ConfigProvider).GetConfmap` (#10139)
  Call `(*confmap.Conf).Marshal(*otelcol.Config)` to get the Collector's configuration.
- `exporterhelper`: Deprecate the obsreport API in the exporterhelper package. (#10592)

### 🚀 New components 🚀

- `consumer/consumerprofiles`: Allow handling profiles in consumer. (#10464)

## v1.11.0/v0.104.0

### 🛑 Breaking changes 🛑

- `otelcol`: The `otelcol.NewCommand` now requires at least one provider be set. (#10436)
- `component/componenttest`: Added additional "inserted" count to `TestTelemetry.CheckProcessor*` methods. (#10353)

### 🚩 Deprecations 🚩

- `otelcoltest`: Deprecates `LoadConfigWithSettings` and `LoadConfigAndValidateWithSettings`.  Use `LoadConfig` and `LoadConfigAndValidate` instead. (#10417)
- `otelcol`: The `otelcol.NewCommandMustSetProvider` is deprecated. Use `otelcol.NewCommand` instead. (#10436)

### 🚀 New components 🚀

- `otelcoltest`: Split off go.opentelemetry.io/collector/otelcol/otelcoltest into its own module (#10417)

### 💡 Enhancements 💡

- `pdata/pprofile`: Add pprofile wrapper to convert proto into pprofile. (#10401)
- `pdata/testdata`: Add pdata testdata for profiles. (#10401)

## v1.10.0/v0.103.0

### 🛑 Breaking changes 🛑

- `component`: Remove deprecated `component.UnmarshalConfig` (#7102)
- `confighttp`: Use `confighttp.ServerConfig` as part of zpagesextension.Config. Previously the extension used `confignet.TCPAddrConfig` (#9368)

### 🚩 Deprecations 🚩

- `connector`: Deprecate CreateSettings and NewNopCreateSettings (#9428)
  The following methods are being renamed:
  - connector.CreateSettings -> connector.Settings
  - connector.NewNopCreateSettings -> connector.NewNopSettings
  
- `exporter`: Deprecate CreateSettings and NewNopCreateSettings (#9428)
  The following methods are being renamed:
  - exporter.CreateSettings -> exporter.Settings
  - exporter.NewNopCreateSettings -> exporter.NewNopSettings
  
- `extension`: Deprecate CreateSettings and NewNopCreateSettings (#9428)
  The following methods are being renamed:
  - extension.CreateSettings -> extension.Settings
  - extension.NewNopCreateSettings -> extension.NewNopSettings
  
- `processor`: Deprecate CreateSettings and NewNopCreateSettings (#9428)
  The following methods are being renamed:
  - processor.CreateSettings -> processor.Settings
  - processor.NewNopCreateSettings -> processor.NewNopSettings
  
- `receiver`: Deprecate CreateSettings and NewNopCreateSettings (#9428)
  The following methods are being renamed:
  - receiver.CreateSettings -> receiver.Settings
  - receiver.NewNopCreateSettings -> receiver.NewNopSettings
  
- `configauth`: Deprecate `GetClientAuthenticator` and `GetServerAuthenticator`, use `GetClientAuthenticatorContext` and `GetServerAuthenticatorContext` instead. (#9808)
- `confighttp`: Deprecate `ClientConfig.CustomRoundTripper` (#8627)
  Set the `Transport` field on the `*http.Client` object returned from `(ClientConfig).ToClient` instead.
- `filter`: Deprecate the `filter.CombinedFilter` struct (#10348)
- `otelcol`: Deprecate `otelcol.NewCommand`. Use `otelcol.NewCommandMustProviderSettings` instead. (#10359)
- `otelcoltest`: Deprecate `LoadConfig` and `LoadConfigAndValidate`. Use `LoadConfigWithSettings` and `LoadConfigAndValidateWithSettings` instead (#10359)

### 💡 Enhancements 💡

- `confmap`: Adds `confmap.Retrieved.AsString` method that returns the configuration value as a string (#9532)
- `confmap`: Adds `confmap.NewRetrievedFromYAML` helper to create `confmap.Retrieved` values from YAML bytes (#9532)

## v0.102.1

No API-only changes on this release. **This release addresses [GHSA-c74f-6mfw-mm4v](https://github.com/open-telemetry/opentelemetry-collector/security/advisories/GHSA-c74f-6mfw-mm4v) for `configgrpc`.**

## v1.9.0/v0.102.0

**This release addresses [GHSA-c74f-6mfw-mm4v](https://github.com/open-telemetry/opentelemetry-collector/security/advisories/GHSA-c74f-6mfw-mm4v) for `confighttp`.**

### 🛑 Breaking changes 🛑

- `otelcol`: Remove deprecated `ConfigProvider` field from `CollectorSettings` (#10281)
- `exporterhelper`: remove deprecated RequestMarshaler & RequestUnmarshaler types (#10283)
- `service`: remove deprecated Telemetry struct and New func (#10285)
- `configtls`: remove deprecated LoadTLSConfigContext funcs (#10283)

### 🚩 Deprecations 🚩

- `component`: Deprecate `component.UnmarshalConfig`, use `(*confmap.Conf).Unmarshal(&intoCfg)` instead. (#7102)
- `service/telemetry`: Deprecate telemetry.New in favor of telemetry.NewFactory (#4970)

### 💡 Enhancements 💡

- `confmap`: Allow setting a default Provider on a Resolver to use when `${}` syntax is used without a scheme (#10182)
- `pdata`: Introduce string and int64 slices to pcommon (#10148)
- `pdata`: Introduce generated experimental pdata for profiling signal. (#10195)
- `confmap`: Remove top level condition when considering struct as Unmarshalers (#7101)

### 🧰 Bug fixes 🧰

- `otelcol`: Update validate command to use the new configuration options (#10203)

## v1.8.0/v0.101.0

### 🛑 Breaking changes 🛑

- `confighttp`: Removes deprecated functions `ToClientContext`, `ToListenerContext`, and `ToServerContext`. (#10138)
- `confmap`: Deprecate `NewWithSettings` for all Providers and `New` for all Converters (#10134)
  Use `NewFactory` instead for all affected modules.
- `confmap`: Remove deprecated `Providers` and `Converters` from `confmap.ResolverSettings` (#10173)
  Use `ProviderSettings` and `ConverterSettings` instead.

### 🧰 Bug fixes 🧰

- `otelcol`: Add explicit mapstructure tags to main configuration struct (#10152)
- `confmap`: Support string-like types as map keys when marshaling (#10137)

## v1.7.0/v0.100.0

### 💡 Enhancements 💡

- `configgrpc`: Adds `NewDefault*` functions for all the config structs. (#9654)
- `exporterqueue`: Expose ErrQueueIsFull so upstream components can retry or apply backpressure. (#10070)

### 🧰 Bug fixes 🧰

- `mdatagen`: Call connectors with routers to be the same as the service graph (#10079)

## v1.6.0/v0.99.0

### 🛑 Breaking changes 🛑

- `component`: Removed deprecated function `GetExporters` from `component.Host` interface (#9987)

### 🚩 Deprecations 🚩

- `confighttp`: deprecate ToClientContext, ToServerContext, ToListenerContext, replaced by ToClient, ToServer, ToListener (#9807)
- `configtls`: Deprecates `ClientConfig.LoadTLSConfigContext` and `ServerConfig.LoadTLSConfigContext`, use `ClientConfig.LoadTLSConfig` and `ServerConfig.LoadTLSConfig` instead. (#9945)
- `confmap`: Deprecate the `Providers` and `Converters` fields in `confmap.ResolverSettings` (#9516)
Use the `ProviderFactories` and `ConverterFactories` fields instead.

### 💡 Enhancements 💡

- `configauth`: Adds `NewDefault*` functions for all the config structs. (#9821)
- `configtls`: Adds `NewDefault*` functions for all the config structs. (#9658)
- `pmetric`: Support metric.metadata in pdata/pmetric (#10006)

## v1.5.0/v0.98.0

### 🛑 Breaking changes 🛑

- `component`: Restricts maximum length for `component.Type` to 63 characters. (#9872)
- `configgrpc`: Remove deprecated `ToServerContext`, use `ToServer` instead. (#9836)
- `configgrpc`: Remove deprecated `SanitizedEndpoint`. (#9836)
- `configtls`: Remove Deprecated `TLSSetting`, `TLSClientSetting`, and `TLSServerSetting`. (#9786)
- `configtls`: Rename `TLSSetting` to `Config` on `ClientConfig` and `ServerConfig`. (#9786)

### 🚩 Deprecations 🚩

- `confighttp`: Deprecate `ToClient`,`ToListener`and `ToServer` use `ToClientContext`,`ToListenerContext` and `ToServerContext`instead. (#9807)
- `configtls`: Deprecate `ClientConfig.LoadTLSConfig` and `ServerConfig.LoadTLSConfig`, use `ClientConfig.LoadTLSConfigContext` and `ServerConfig.LoadTLSConfigContext` instead. (#9811)

### 💡 Enhancements 💡

- Introduce new module for generating pdata: pdata/testdata (#9886)
- `exporterhelper`: Make the `WithBatcher` option available for regular exporter helpers based on OTLP data type. (#8122)
  Now, `WithBatcher` can be used with both regular exporter helper (e.g. NewTracesExporter) and the request-based exporter 
  helper (e.g. NewTracesRequestExporter). The request-based exporter helpers require `WithRequestBatchFuncs` option 
  providing batching functions. 
  
- `confmap`: Creates a logger in the confmap.ProviderSettings and uses it to log when there is a missing or blank environment variable referenced in config. For now the noop logger is used everywhere except tests. (#5615)

## v1.4.0/v0.97.0

### 🛑 Breaking changes 🛑

- `configgrpc`: Remove deprecated `ToServer` function. (#9787)
- `confignet`: Change `Transport` field from `string` to `TransportType` (#9385)
- `component`: Change underlying type of `component.Type` to an opaque struct. (#9208)
- `obsreport`: Remove deprecated obsreport/obsreporttest package. (#9724)
- `component`: Remove deprecated error `ErrNilNextConsumer` (#9322)
- `connector`: Remove `LogsRouter`, `MetricsRouter` and `TracesRouter`. Use `LogsRouterAndConsumer`, `MetricsRouterAndConsumer`, `TracesRouterAndConsumer` respectively instead. (#9095)
- `receiver`: Remove deprecated struct `ScraperControllerSettings` and function `NewDefaultScraperControllerSettings` (#6767)
- `confmap`: Remove deprecated `provider.New` methods, use `NewWithSettings` moving forward. (#9443)

### 🚩 Deprecations 🚩

- `configgrpc`: Deprecated `ToServerContext`, use `ToServer` instead. (#9787)
- `configgrpc`: Deprecate `SanitizedEndpoint` (#9788)

### 💡 Enhancements 💡

- `exporterhelper`: Add experimental batching capabilities to the exporter helper (#8122)
- `confignet`: Adds `NewDefault*` functions for all the config structs. (#9656)
- `configtls`: Validates TLS min_version and max_version (#9475)
  Introduces `Validate()` method in TLSSetting.
- `exporterhelper`: Invalid exporterhelper options now make the exporter creation error out instead of panicking. (#9717)
- `components`: Give NoOp components a unique name (#9637)

## v1.3.0/v0.96.0

### 🚩 Deprecations 🚩

- `configgrpc`: Deprecates `ToServer`.  Use `ToServerContext` instead. (#9624)
- `component`: deprecate component.ErrNilNextConsumer (#9526)
- `configtls`: Rename TLSClientSetting, TLSServerSetting, and TLSSetting based on the naming convention used in other config packages. (#9474)

### 💡 Enhancements 💡

- `receivertest`: add support for metrics in contract checker (#9551)

## v1.2.0/v0.95.0

### 🛑 Breaking changes 🛑

- `all`: Bump minimum go version to go 1.21 (#9507)
- `service/telemetry`: Delete generated_config types, use go.opentelemetry.io/contrib/config types instead (#9546)
- `configcompression`: Remove deprecated `configcompression` types, constants and methods. (#9388)
- `component`: Remove `host.ReportFatalError` (#6344)
- `configgrpc`: Remove deprecated `configgrpc.ServerConfig.ToListener` (#9481)
- `confmap`: Remove deprecated `confmap.WithErrorUnused` (#9484)

### 🚩 Deprecations 🚩

- `confignet`: Deprecate `confignet.NetAddr` and `confignet.TCPAddr` in favor of `confignet.AddrConfig` and `confignet.TCPAddrConfig`. (#9509)
- `config/configgrpc`: Deprecate `configgrpc.ClientConfig.SanitizedEndpoint`, `configgrpc.ServerConfig.ToListener` and `configgrpc.ServerConfig.ToListenerContext` (#9481, #9482)
- `scraperhelper`: Deprecate ScraperControllerSettings, use ControllerConfig instead (#6767)

## v1.1.0/v0.94.0

### 🛑 Breaking changes 🛑

- `confignet`: Remove deprecated `DialContext` and `ListenContext` functions (#9363)
- `confmap/converter/expandconverter`: Add `confmap.ConverterSettings` argument to experimental `expandconverter.New` function. (#5615, #9162)
  - The `confmap.ConverterSettings` struct currently has no fields. It will be used to pass a logger.
  
- `component`: Remove deprecated funcs and types (#9283)
- `otlpexporter`: Config struct is moving from embedding the deprecated GRPCClientSettings struct to using ClientConfig instead. (#6767)
- `otlphttpexporter`: otlphttpexporter.Config embeds the struct confighttp.ClientConfig instead of confighttp.HTTPClientSettings (#6767)
- `otlpreceiver`: HTTPConfig struct is moving from embedding the deprecated ServerSettings struct to using HTTPServerConfig instead. (#6767)
- `component`: Validate component.Type at creation and unmarshaling time. (#9208)
  - A component.Type must start with an ASCII alphabetic character and can only contain ASCII alphanumeric characters and '_'.
  

### 🚩 Deprecations 🚩

- `configcompressions`: Deprecate `IsCompressed`.  Use `CompressionType.IsCompressed instead` instead. (#9435)
- `configcompression`: Deprecate `CompressionType`, use `Type` instead. (#9416)
- `confighttp`: Deprecate CORSSettings, use CORSConfig instead (#6767)
- `configgrpc`: Deprecate `ToListener` function in favor of `ToListenerContext` (#9389)
- `configgrpc`: Deprecate GRPCServerSettings, use ServerConfig instead (#6767)
- `confighttp`: Deprecate HTTPClientSettings, use ClientConfig instead (#6767)
- `confighttp`: Deprecate HTTPServerSettings, use ServerConfig instead (#6767)
- `confmap/provider`: Deprecate <provider>.New in favor of <provider>.NewWithSettings for all core providers (#5615, #9162)
  - NewWithSettings now takes an empty confmap.ProviderSettings struct. This will be used to pass a logger in the future.
  

### 💡 Enhancements 💡

- `exporter/exporterhelper`: Add API for enabling queue in the new exporter helpers. (#7874)
  The following experimental API is introduced in exporter package:
    - `exporterhelper.WithRequestQueue`: a new exporter helper option for using a queue.
    - `exporterqueue.Queue`: an interface for queue implementations.
    - `exporterqueue.Factory`: a queue factory interface, implementations of this interface are intended to be used with WithRequestQueue option.
    - `exporterqueue.Settings`: queue factory settings.
    - `exporterqueue.Config`: common configuration for queue implementations.
    - `exporterqueue.NewDefaultConfig`: a function for creating a default queue configuration.
    - `exporterqueue.NewMemoryQueueFactory`: a new factory for creating a memory queue.
    - `exporterqueue.NewPersistentQueueFactory: a factory for creating a persistent queue.
  
- `featuregate`: Add the `featuregate.ErrAlreadyRegistered` error, which is returned by `featuregate.Registry`'s `Register` when adding a feature gate that is already registered. (#8622)
  Use `errors.Is` to check for this error.
  

## v0.93.0

### 🛑 Breaking changes 🛑

- `bug_fix`: Implement `encoding.BinaryMarshaler` interface to prevent `configopaque` -> `[]byte` -> `string` conversions from leaking the value (#9279)
- `configopaque`: configopaque.String implements `fmt.Stringer` and `fmt.GoStringer`, outputting [REDACTED] when formatted with the %s, %q or %#v verbs` (#9213)
  This may break applications that rely on the previous behavior of opaque strings with `fmt.Sprintf` to e.g. build URLs or headers.
  Explicitly cast the opaque string to a string before using it in `fmt.Sprintf` to restore the previous behavior.
  
- `all`: Remove obsolete "// +build" directives (#9304)
- `connectortest`: Remove deprecated connectortest router helpers. (#9278)

### 🚩 Deprecations 🚩

- `obsreporttest`: deprecate test funcs/structs (#8492)
  The following methods/structs have been moved from obsreporttest to componenttest:
  - obsreporttest.TestTelemetry -> componenttest.TestTelemetry
  - obsreporttest.SetupTelemetry -> componenttest.SetupTelemetry
  - obsreporttest.CheckScraperMetrics -> TestTelemetry.CheckScraperMetrics
  - obsreporttest.TestTelemetry.TelemetrySettings -> componenttest.TestTelemetry.TelemetrySettings()
  
- `confignet`: Deprecates `DialContext` and `ListenContext` functions. Use `Dial` and `Listen` instead. (#9258)
  Unlike the previous `Dial` and `Listen` functions, the new `Dial` and `Listen` functions take a `context.Context` like `DialContext` and `ListenContext`.

## v1.0.1/v0.92.0

### 🛑 Breaking changes 🛑

- `otlpexporter`: Change Config members names to use Config suffix. (#9091)
- `component`: Remove deprecated unused TelemetrySettingsBase (#9145)

### 🚩 Deprecations 🚩

- `confignet`: Deprecates the `Dial` and `Listen` functions in favor of `DialContext` and `ListenContext`. (#9163)
- `component`: Deprecate unnecessary type StatusFunc (#9146)

## v0.91.0

## v1.0.0/v0.90.0

### 🛑 Breaking changes 🛑

- `exporterhelper`: Replace converter interface with function in the new experimental exporter helper. (#8122)
- `featuregate`: Remove deprecate function `featuregate.NewFlag` (#8727)
  Use `featuregate.Registry`'s `RegisterFlags` method instead.

### 🚩 Deprecations 🚩

- `telemetry`: deprecate jsonschema generated types (#15009)

### 💡 Enhancements 💡

- `pdata`: Add ZeroThreshold field to exponentialHistogramDataPoint in pmetric package. (#8802)

## v1.0.0-rcv0018/v0.89.0

### 🛑 Breaking changes 🛑

- `otelcol`: CollectorSettings.Factories now expects: `func() (Factories, error)` (#8478)
- `exporter/exporterhelper`: The experimental Request API is updated. (#7874)
  - `Request` interface now includes ItemsCount() method.
  - `RequestItemsCounter` is removed.
  - The following interfaces are added:
    - Added an optional interface for handling errors that occur during request processing `RequestErrorHandler`.
    - Added a function to unmarshal bytes into a Request `RequestUnmarshaler`.
    - Added a function to marshal a Request into bytes `RequestMarshaler`
  

### 🚩 Deprecations 🚩

- `featuregate`: Deprecate `featuregate.NewFlag` in favor of `featuregate.Registry`'s `RegisterFlags` method (#8727)

### 💡 Enhancements 💡

- `featuregate`: Add validation for feature gates ID, URL and versions. (#8766)
  Feature gates IDs are now explicitly restricted to ASCII alphanumerics and dots.
  

## v1.0.0-rcv0017/v0.88.0

### 💡 Enhancements 💡

- `pdata`: Add IsReadOnly() method to p[metrics|logs|traces].[Metrics|Logs|Spans] pdata structs allowing to check if the struct is read-only. (#6794)

## v1.0.0-rcv0016/v0.87.0

### 💡 Enhancements 💡

- `pdata`: Introduce API to control pdata mutability (#6794)
  This change introduces new API pdata methods to control the mutability:
  - p[metric|trace|log].[Metrics|Traces|Logs].MarkReadOnly() - marks the pdata as read-only. Any subsequent
    mutations will result in a panic.
  - p[metric|trace|log].[Metrics|Traces|Logs].IsReadOnly() - returns true if the pdata is marked as read-only.
  Currently, all the data is kept mutable. This API will be used by fanout consumer in the following releases. 

### 🛑 Breaking changes 🛑

- `obsreport`: remove methods/structs deprecated in previous release. (#8492)
- `extension`: remove deprecated Configs and Factories (#8631)

## v1.0.0-rcv0015/v0.86.0

### 🛑 Breaking changes 🛑

- `service`: remove deprecated service.PipelineConfig (#8485)

### 🚩 Deprecations 🚩

- `obsreporttest`: deprecate To*CreateSettings funcs in obsreporttest (#8492)
  The following TestTelemetry methods have been deprecated. Use structs instead:
  -  ToExporterCreateSettings -> exporter.CreateSettings
  -  ToProcessorCreateSettings -> processor.CreateSettings
  -  ToReceiverCreateSettings -> receiver.CreateSettings
  
- `obsreport`: Deprecating `obsreport.Exporter`, `obsreport.ExporterSettings`, `obsreport.NewExporter` (#8492)
  These deprecated methods/structs have been moved to exporterhelper:
  - `obsreport.Exporter` -> `exporterhelper.ObsReport`
  - `obsreport.ExporterSettings` -> `exporterhelper.ObsReportSettings`
  - `obsreport.NewExporter` -> `exporterhelper.NewObsReport`
  
- `obsreport`: Deprecating `obsreport.BuildProcessorCustomMetricName`, `obsreport.Processor`, `obsreport.ProcessorSettings`, `obsreport.NewProcessor` (#8492)
  These deprecated methods/structs have been moved to processorhelper:
  - `obsreport.BuildProcessorCustomMetricName` -> `processorhelper.BuildCustomMetricName`
  - `obsreport.Processor` -> `processorhelper.ObsReport`
  - `obsreport.ProcessorSettings` -> `processorhelper.ObsReportSettings`
  - `obsreport.NewProcessor` -> `processorhelper.NewObsReport`
  
- `obsreport`: Deprecating obsreport scraper and receiver API (#8492)
  These deprecated methods/structs have been moved to receiverhelper and scraperhelper:
  - `obsreport.Receiver` -> `receiverhelper.ObsReport`
  - `obsreport.ReceiverSettings` -> `receiverhelper.ObsReportSettings`
  - `obsreport.NewReceiver` -> `receiverhelper.NewObsReport`
  - `obsreport.Scraper` -> `scraperhelper.ObsReport`
  - `obsreport.ScraperSettings` -> `scraperhelper.ObsReportSettings`
  - `obsreport.NewScraper` -> `scraperhelper.NewObsReport`
  

### 💡 Enhancements 💡

- `otelcol`: Splitting otelcol into its own module. (#7924)
- `service`: Split service into its own module (#7923)

## v0.85.0

## v0.84.0

### 💡 Enhancements 💡

- `exporter/exporterhelper`: Introduce a new exporter helper that operates over client-provided requests instead of pdata (#7874)
  The following experimental API is introduced in exporter/exporterhelper package:
    - `NewLogsRequestExporter`: a new exporter helper for logs.
    - `NewMetricsRequestExporter`: a new exporter helper for metrics.
    - `NewTracesRequestExporter`: a new exporter helper for traces.
    - `Request`: an interface for client-defined requests.
    - `RequestItemsCounter`: an optional interface for counting the number of items in a Request.
    - `LogsConverter`: an interface for converting plog.Logs to Request.
    - `MetricsConverter`: an interface for converting pmetric.Metrics to Request.
    - `TracesConverter`: an interface for converting ptrace.Traces to Request.
    All the new APIs are intended to be used by exporters that need to operate over client-provided requests instead of pdata.
  
- `otlpreceiver`: Export HTTPConfig as part of the API for creating the otlpreceiver configuration. (#8175)
  Changes signature of receiver/otlpreceiver/config.go type httpServerSettings to HTTPConfig.

## v0.83.0

### 🛑 Breaking changes 🛑

- `all`: Remove go 1.19 support, bump minimum to go 1.20 and add testing for 1.21 (#8207)

### 💡 Enhancements 💡

- `changelog`: Generate separate changelogs for end users and package consumers (#8153)
