// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigAttributeUnitSlice(dest, src []*otlpprofiles.AttributeUnit) []*otlpprofiles.AttributeUnit {
	var newDest []*otlpprofiles.AttributeUnit
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.AttributeUnit, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpprofiles.AttributeUnit{}
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpprofiles.AttributeUnit{}
		}
	}
	for i := range src {
		CopyOrigAttributeUnit(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestAttributeUnitSlice() []*otlpprofiles.AttributeUnit {
	orig := make([]*otlpprofiles.AttributeUnit, 7)
	for i := 0; i < 7; i++ {
		orig[i] = &otlpprofiles.AttributeUnit{}
		FillOrigTestAttributeUnit(orig[i])
	}
	return orig
}

// UnmarshalJSONOrigAttributeUnitSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigAttributeUnitSlice(iter *json.Iterator) []*otlpprofiles.AttributeUnit {
	var orig []*otlpprofiles.AttributeUnit
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, &otlpprofiles.AttributeUnit{})
		UnmarshalJSONOrigAttributeUnit(orig[len(orig)-1], iter)
		return true
	})
	return orig
}
