// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigEntityRef(t *testing.T) {
	src := &otlpcommon.EntityRef{}
	dest := &otlpcommon.EntityRef{}
	CopyOrigEntityRef(dest, src)
	assert.Equal(t, &otlpcommon.EntityRef{}, dest)
	FillOrigTestEntityRef(src)
	CopyOrigEntityRef(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigEntityRefUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcommon.EntityRef{}
	UnmarshalJSONOrigEntityRef(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcommon.EntityRef{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigEntityRef(t *testing.T) {
	for name, src := range getEncodingTestValuesEntityRef() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigEntityRef(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcommon.EntityRef{}
			UnmarshalJSONOrigEntityRef(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigEntityRef(t *testing.T) {
	for name, src := range getEncodingTestValuesEntityRef() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigEntityRef(src))
			gotSize := MarshalProtoOrigEntityRef(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcommon.EntityRef{}
			require.NoError(t, UnmarshalProtoOrigEntityRef(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesEntityRef() map[string]*otlpcommon.EntityRef {
	return map[string]*otlpcommon.EntityRef{
		"empty": {},
		"fill_test": func() *otlpcommon.EntityRef {
			src := &otlpcommon.EntityRef{}
			FillOrigTestEntityRef(src)
			return src
		}(),
	}
}
