// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectorlog "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportLogsPartialSuccess(t *testing.T) {
	src := &otlpcollectorlog.ExportLogsPartialSuccess{}
	dest := &otlpcollectorlog.ExportLogsPartialSuccess{}
	CopyOrigExportLogsPartialSuccess(dest, src)
	assert.Equal(t, &otlpcollectorlog.ExportLogsPartialSuccess{}, dest)
	FillOrigTestExportLogsPartialSuccess(src)
	CopyOrigExportLogsPartialSuccess(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportLogsPartialSuccessUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectorlog.ExportLogsPartialSuccess{}
	UnmarshalJSONOrigExportLogsPartialSuccess(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectorlog.ExportLogsPartialSuccess{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportLogsPartialSuccess(t *testing.T) {
	for name, src := range getEncodingTestValuesExportLogsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportLogsPartialSuccess(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectorlog.ExportLogsPartialSuccess{}
			UnmarshalJSONOrigExportLogsPartialSuccess(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportLogsPartialSuccess(t *testing.T) {
	for name, src := range getEncodingTestValuesExportLogsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportLogsPartialSuccess(src))
			gotSize := MarshalProtoOrigExportLogsPartialSuccess(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectorlog.ExportLogsPartialSuccess{}
			require.NoError(t, UnmarshalProtoOrigExportLogsPartialSuccess(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportLogsPartialSuccess() map[string]*otlpcollectorlog.ExportLogsPartialSuccess {
	return map[string]*otlpcollectorlog.ExportLogsPartialSuccess{
		"empty": {},
		"fill_test": func() *otlpcollectorlog.ExportLogsPartialSuccess {
			src := &otlpcollectorlog.ExportLogsPartialSuccess{}
			FillOrigTestExportLogsPartialSuccess(src)
			return src
		}(),
	}
}
