// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcollectorlog "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigExportLogsServiceResponse(dest, src *otlpcollectorlog.ExportLogsServiceResponse) {
	CopyOrigExportLogsPartialSuccess(&dest.PartialSuccess, &src.PartialSuccess)
}

func FillOrigTestExportLogsServiceResponse(orig *otlpcollectorlog.ExportLogsServiceResponse) {
	FillOrigTestExportLogsPartialSuccess(&orig.PartialSuccess)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportLogsServiceResponse(orig *otlpcollectorlog.ExportLogsServiceResponse, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("partialSuccess")
	MarshalJSONOrigExportLogsPartialSuccess(&orig.PartialSuccess, dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExportResponse unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportLogsServiceResponse(orig *otlpcollectorlog.ExportLogsServiceResponse, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "partialSuccess", "partial_success":
			UnmarshalJSONOrigExportLogsPartialSuccess(&orig.PartialSuccess, iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigExportLogsServiceResponse(orig *otlpcollectorlog.ExportLogsServiceResponse) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigExportLogsPartialSuccess(&orig.PartialSuccess)
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func MarshalProtoOrigExportLogsServiceResponse(orig *otlpcollectorlog.ExportLogsServiceResponse, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigExportLogsPartialSuccess(&orig.PartialSuccess, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	return len(buf) - pos
}

func UnmarshalProtoOrigExportLogsServiceResponse(orig *otlpcollectorlog.ExportLogsServiceResponse, buf []byte) error {
	return orig.Unmarshal(buf)
}
