// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectorprofile "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportProfilesServiceResponse(t *testing.T) {
	src := &otlpcollectorprofile.ExportProfilesServiceResponse{}
	dest := &otlpcollectorprofile.ExportProfilesServiceResponse{}
	CopyOrigExportProfilesServiceResponse(dest, src)
	assert.Equal(t, &otlpcollectorprofile.ExportProfilesServiceResponse{}, dest)
	FillOrigTestExportProfilesServiceResponse(src)
	CopyOrigExportProfilesServiceResponse(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportProfilesServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectorprofile.ExportProfilesServiceResponse{}
	UnmarshalJSONOrigExportProfilesServiceResponse(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectorprofile.ExportProfilesServiceResponse{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportProfilesServiceResponse(t *testing.T) {
	for name, src := range getEncodingTestValuesExportProfilesServiceResponse() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportProfilesServiceResponse(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectorprofile.ExportProfilesServiceResponse{}
			UnmarshalJSONOrigExportProfilesServiceResponse(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportProfilesServiceResponse(t *testing.T) {
	for name, src := range getEncodingTestValuesExportProfilesServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportProfilesServiceResponse(src))
			gotSize := MarshalProtoOrigExportProfilesServiceResponse(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectorprofile.ExportProfilesServiceResponse{}
			require.NoError(t, UnmarshalProtoOrigExportProfilesServiceResponse(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportProfilesServiceResponse() map[string]*otlpcollectorprofile.ExportProfilesServiceResponse {
	return map[string]*otlpcollectorprofile.ExportProfilesServiceResponse{
		"empty": {},
		"fill_test": func() *otlpcollectorprofile.ExportProfilesServiceResponse {
			src := &otlpcollectorprofile.ExportProfilesServiceResponse{}
			FillOrigTestExportProfilesServiceResponse(src)
			return src
		}(),
	}
}
