// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type Traces struct {
	orig  *otlpcollectortrace.ExportTraceServiceRequest
	state *State
}

func GetOrigTraces(ms Traces) *otlpcollectortrace.ExportTraceServiceRequest {
	return ms.orig
}

func GetTracesState(ms Traces) *State {
	return ms.state
}

func NewTraces(orig *otlpcollectortrace.ExportTraceServiceRequest, state *State) Traces {
	return Traces{orig: orig, state: state}
}

func GenerateTestTraces() Traces {
	orig := otlpcollectortrace.ExportTraceServiceRequest{}
	FillOrigTestExportTraceServiceRequest(&orig)
	state := StateMutable
	return NewTraces(&orig, &state)
}

func CopyOrigExportTraceServiceRequest(dest, src *otlpcollectortrace.ExportTraceServiceRequest) {
	dest.ResourceSpans = CopyOrigResourceSpansSlice(dest.ResourceSpans, src.ResourceSpans)
}

func FillOrigTestExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest) {
	orig.ResourceSpans = GenerateOrigTestResourceSpansSlice()
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceSpans) > 0 {
		dest.WriteObjectField("resourceSpans")
		dest.WriteArrayStart()
		MarshalJSONOrigResourceSpans(orig.ResourceSpans[0], dest)
		for i := 1; i < len(orig.ResourceSpans); i++ {
			dest.WriteMore()
			MarshalJSONOrigResourceSpans(orig.ResourceSpans[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigTraces unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "resourceSpans", "resource_spans":
			orig.ResourceSpans = UnmarshalJSONOrigResourceSpansSlice(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest) int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceSpans {
		l = SizeProtoOrigResourceSpans(orig.ResourceSpans[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.ResourceSpans {
		l = MarshalProtoOrigResourceSpans(orig.ResourceSpans[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest, buf []byte) error {
	return orig.Unmarshal(buf)
}
