// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	v1 "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigKeyValue(dest, src *v1.KeyValue) {
	dest.Key = src.Key
	CopyOrigAnyValue(&dest.Value, &src.Value)
}

func FillOrigTestKeyValue(orig *v1.KeyValue) {
	orig.Key = "test_key"
	FillOrigTestAnyValue(&orig.Value)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigKeyValue(orig *v1.KeyValue, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Key != "" {
		dest.WriteObjectField("key")
		dest.WriteString(orig.Key)
	}
	dest.WriteObjectField("value")
	MarshalJSONOrigAnyValue(&orig.Value, dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigAttribute unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigKeyValue(orig *v1.KeyValue, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "key":
			orig.Key = iter.ReadString()
		case "value":
			UnmarshalJSONOrigAnyValue(&orig.Value, iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigKeyValue(orig *v1.KeyValue) int {
	var n int
	var l int
	_ = l
	l = len(orig.Key)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = SizeProtoOrigAnyValue(&orig.Value)
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func MarshalProtoOrigKeyValue(orig *v1.KeyValue, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.Key)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Key)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}

	l = MarshalProtoOrigAnyValue(&orig.Value, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	return len(buf) - pos
}

func UnmarshalProtoOrigKeyValue(orig *v1.KeyValue, buf []byte) error {
	return orig.Unmarshal(buf)
}
