// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	v1 "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigKeyValueSlice(dest, src []v1.KeyValue) []v1.KeyValue {
	var newDest []v1.KeyValue
	if cap(dest) < len(src) {
		newDest = make([]v1.KeyValue, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = v1.KeyValue{}
		}
	}
	for i := range src {
		CopyOrigKeyValue(&newDest[i], &src[i])
	}
	return newDest
}

func GenerateOrigTestKeyValueSlice() []v1.KeyValue {
	orig := make([]v1.KeyValue, 7)
	for i := 0; i < 7; i++ {
		orig[i] = v1.KeyValue{}
		FillOrigTestKeyValue(&orig[i])
	}
	return orig
}

// UnmarshalJSONOrigKeyValueSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigKeyValueSlice(iter *json.Iterator) []v1.KeyValue {
	var orig []v1.KeyValue
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, v1.KeyValue{})
		UnmarshalJSONOrigKeyValue(&orig[len(orig)-1], iter)
		return true
	})
	return orig
}
