// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigLink(t *testing.T) {
	src := &otlpprofiles.Link{}
	dest := &otlpprofiles.Link{}
	CopyOrigLink(dest, src)
	assert.Equal(t, &otlpprofiles.Link{}, dest)
	FillOrigTestLink(src)
	CopyOrigLink(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigLinkUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.Link{}
	UnmarshalJSONOrigLink(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.Link{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigLink(t *testing.T) {
	for name, src := range getEncodingTestValuesLink() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigLink(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.Link{}
			UnmarshalJSONOrigLink(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigLink(t *testing.T) {
	for name, src := range getEncodingTestValuesLink() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigLink(src))
			gotSize := MarshalProtoOrigLink(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.Link{}
			require.NoError(t, UnmarshalProtoOrigLink(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesLink() map[string]*otlpprofiles.Link {
	return map[string]*otlpprofiles.Link{
		"empty": {},
		"fill_test": func() *otlpprofiles.Link {
			src := &otlpprofiles.Link{}
			FillOrigTestLink(src)
			return src
		}(),
	}
}
