// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigResourceProfiles(t *testing.T) {
	src := &otlpprofiles.ResourceProfiles{}
	dest := &otlpprofiles.ResourceProfiles{}
	CopyOrigResourceProfiles(dest, src)
	assert.Equal(t, &otlpprofiles.ResourceProfiles{}, dest)
	FillOrigTestResourceProfiles(src)
	CopyOrigResourceProfiles(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigResourceProfilesUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.ResourceProfiles{}
	UnmarshalJSONOrigResourceProfiles(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.ResourceProfiles{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigResourceProfiles(t *testing.T) {
	for name, src := range getEncodingTestValuesResourceProfiles() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigResourceProfiles(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.ResourceProfiles{}
			UnmarshalJSONOrigResourceProfiles(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigResourceProfiles(t *testing.T) {
	for name, src := range getEncodingTestValuesResourceProfiles() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigResourceProfiles(src))
			gotSize := MarshalProtoOrigResourceProfiles(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.ResourceProfiles{}
			require.NoError(t, UnmarshalProtoOrigResourceProfiles(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesResourceProfiles() map[string]*otlpprofiles.ResourceProfiles {
	return map[string]*otlpprofiles.ResourceProfiles{
		"empty": {},
		"fill_test": func() *otlpprofiles.ResourceProfiles {
			src := &otlpprofiles.ResourceProfiles{}
			FillOrigTestResourceProfiles(src)
			return src
		}(),
	}
}
