// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigScopeProfiles(dest, src *otlpprofiles.ScopeProfiles) {
	CopyOrigInstrumentationScope(&dest.Scope, &src.Scope)
	dest.Profiles = CopyOrigProfileSlice(dest.Profiles, src.Profiles)
	dest.SchemaUrl = src.SchemaUrl
}

func FillOrigTestScopeProfiles(orig *otlpprofiles.ScopeProfiles) {
	FillOrigTestInstrumentationScope(&orig.Scope)
	orig.Profiles = GenerateOrigTestProfileSlice()
	orig.SchemaUrl = "test_schemaurl"
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigScopeProfiles(orig *otlpprofiles.ScopeProfiles, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("scope")
	MarshalJSONOrigInstrumentationScope(&orig.Scope, dest)
	if len(orig.Profiles) > 0 {
		dest.WriteObjectField("profiles")
		dest.WriteArrayStart()
		MarshalJSONOrigProfile(orig.Profiles[0], dest)
		for i := 1; i < len(orig.Profiles); i++ {
			dest.WriteMore()
			MarshalJSONOrigProfile(orig.Profiles[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigScopeProfiles unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigScopeProfiles(orig *otlpprofiles.ScopeProfiles, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "scope":
			UnmarshalJSONOrigInstrumentationScope(&orig.Scope, iter)
		case "profiles":
			orig.Profiles = UnmarshalJSONOrigProfileSlice(iter)
		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigScopeProfiles(orig *otlpprofiles.ScopeProfiles) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigInstrumentationScope(&orig.Scope)
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.Profiles {
		l = SizeProtoOrigProfile(orig.Profiles[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigScopeProfiles(orig *otlpprofiles.ScopeProfiles, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigInstrumentationScope(&orig.Scope, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := range orig.Profiles {
		l = MarshalProtoOrigProfile(orig.Profiles[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigScopeProfiles(orig *otlpprofiles.ScopeProfiles, buf []byte) error {
	return orig.Unmarshal(buf)
}
