// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigScopeSpans(t *testing.T) {
	src := &otlptrace.ScopeSpans{}
	dest := &otlptrace.ScopeSpans{}
	CopyOrigScopeSpans(dest, src)
	assert.Equal(t, &otlptrace.ScopeSpans{}, dest)
	FillOrigTestScopeSpans(src)
	CopyOrigScopeSpans(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigScopeSpansUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlptrace.ScopeSpans{}
	UnmarshalJSONOrigScopeSpans(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlptrace.ScopeSpans{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigScopeSpans(t *testing.T) {
	for name, src := range getEncodingTestValuesScopeSpans() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigScopeSpans(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlptrace.ScopeSpans{}
			UnmarshalJSONOrigScopeSpans(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigScopeSpans(t *testing.T) {
	for name, src := range getEncodingTestValuesScopeSpans() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigScopeSpans(src))
			gotSize := MarshalProtoOrigScopeSpans(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlptrace.ScopeSpans{}
			require.NoError(t, UnmarshalProtoOrigScopeSpans(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesScopeSpans() map[string]*otlptrace.ScopeSpans {
	return map[string]*otlptrace.ScopeSpans{
		"empty": {},
		"fill_test": func() *otlptrace.ScopeSpans {
			src := &otlptrace.ScopeSpans{}
			FillOrigTestScopeSpans(src)
			return src
		}(),
	}
}
