// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package entity

import (
	"testing"
	"unsafe"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

func TestEntityRefSlice(t *testing.T) {
	es := NewEntityRefSlice()
	assert.Equal(t, 0, es.Len())
	state := internal.StateMutable
	es = newEntityRefSlice(&[]*otlpcommon.EntityRef{}, &state)
	assert.Equal(t, 0, es.Len())

	emptyVal := NewEntityRef()
	testVal := EntityRef(internal.GenerateTestEntityRef())
	for i := 0; i < 7; i++ {
		es.AppendEmpty()
		assert.Equal(t, emptyVal, es.At(i))
		internal.FillOrigTestEntityRef((*es.getOrig())[i])
		assert.Equal(t, testVal, es.At(i))
	}
	assert.Equal(t, 7, es.Len())
}

func TestEntityRefSliceReadOnly(t *testing.T) {
	sharedState := internal.StateReadOnly
	es := newEntityRefSlice(&[]*otlpcommon.EntityRef{}, &sharedState)
	assert.Equal(t, 0, es.Len())
	assert.Panics(t, func() { es.AppendEmpty() })
	assert.Panics(t, func() { es.EnsureCapacity(2) })
	es2 := NewEntityRefSlice()
	es.CopyTo(es2)
	assert.Panics(t, func() { es2.CopyTo(es) })
	assert.Panics(t, func() { es.MoveAndAppendTo(es2) })
	assert.Panics(t, func() { es2.MoveAndAppendTo(es) })
}

func TestEntityRefSlice_CopyTo(t *testing.T) {
	dest := NewEntityRefSlice()
	src := generateTestEntityRefSlice()
	src.CopyTo(dest)
	assert.Equal(t, generateTestEntityRefSlice(), dest)
}

func TestEntityRefSlice_EnsureCapacity(t *testing.T) {
	es := generateTestEntityRefSlice()

	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	assert.Equal(t, es.Len(), cap(*es.getOrig()))
	assert.Equal(t, generateTestEntityRefSlice(), es)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	es.EnsureCapacity(ensureLargeLen)
	assert.Less(t, generateTestEntityRefSlice().Len(), ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.getOrig()))
	assert.Equal(t, generateTestEntityRefSlice(), es)
}

func TestEntityRefSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestEntityRefSlice()
	dest := NewEntityRefSlice()
	src := generateTestEntityRefSlice()
	src.MoveAndAppendTo(dest)
	assert.Equal(t, generateTestEntityRefSlice(), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, generateTestEntityRefSlice(), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestEntityRefSlice().MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}

	dest.MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestEntityRefSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewEntityRefSlice()
	emptySlice.RemoveIf(func(el EntityRef) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestEntityRefSlice()
	pos := 0
	filtered.RemoveIf(func(el EntityRef) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestEntityRefSlice_RemoveIfAll(t *testing.T) {
	got := generateTestEntityRefSlice()
	got.RemoveIf(func(el EntityRef) bool {
		return true
	})
	assert.Equal(t, 0, got.Len())
}

func TestEntityRefSliceAll(t *testing.T) {
	ms := generateTestEntityRefSlice()
	assert.NotEmpty(t, ms.Len())

	var c int
	for i, v := range ms.All() {
		assert.Equal(t, ms.At(i), v, "element should match")
		c++
	}
	assert.Equal(t, ms.Len(), c, "All elements should have been visited")
}

func TestEntityRefSlice_Sort(t *testing.T) {
	es := generateTestEntityRefSlice()
	es.Sort(func(a, b EntityRef) bool {
		return uintptr(unsafe.Pointer(a.getOrig())) < uintptr(unsafe.Pointer(b.getOrig()))
	})
	for i := 1; i < es.Len(); i++ {
		assert.Less(t, uintptr(unsafe.Pointer(es.At(i-1).getOrig())), uintptr(unsafe.Pointer(es.At(i).getOrig())))
	}
	es.Sort(func(a, b EntityRef) bool {
		return uintptr(unsafe.Pointer(a.getOrig())) > uintptr(unsafe.Pointer(b.getOrig()))
	})
	for i := 1; i < es.Len(); i++ {
		assert.Greater(t, uintptr(unsafe.Pointer(es.At(i-1).getOrig())), uintptr(unsafe.Pointer(es.At(i).getOrig())))
	}
}

func generateTestEntityRefSlice() EntityRefSlice {
	ms := NewEntityRefSlice()
	*ms.getOrig() = internal.GenerateOrigTestEntityRefSlice()
	return ms
}
