// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigAttributeUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesAttributeUnit() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigAttributeUnit()
				CopyOrigAttributeUnit(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigAttributeUnit(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigAttributeUnitUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigAttributeUnit()
	UnmarshalJSONOrigAttributeUnit(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigAttributeUnit(), dest)
}

func TestMarshalAndUnmarshalJSONOrigAttributeUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesAttributeUnit() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigAttributeUnit(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigAttributeUnit()
				UnmarshalJSONOrigAttributeUnit(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigAttributeUnit(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigAttributeUnitFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesAttributeUnit() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigAttributeUnit()
			require.Error(t, UnmarshalProtoOrigAttributeUnit(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigAttributeUnitUnknown(t *testing.T) {
	dest := NewOrigAttributeUnit()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigAttributeUnit(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigAttributeUnit(), dest)
}

func TestMarshalAndUnmarshalProtoOrigAttributeUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesAttributeUnit() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigAttributeUnit(src))
				gotSize := MarshalProtoOrigAttributeUnit(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigAttributeUnit()
				require.NoError(t, UnmarshalProtoOrigAttributeUnit(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigAttributeUnit(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufAttributeUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesAttributeUnit() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigAttributeUnit(src))
			gotSize := MarshalProtoOrigAttributeUnit(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.AttributeUnit{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigAttributeUnit()
			require.NoError(t, UnmarshalProtoOrigAttributeUnit(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesAttributeUnit() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                        {0x02},
		"AttributeKeyStrindex/wrong_wire_type": {0xc},
		"AttributeKeyStrindex/missing_value":   {0x8},
		"UnitStrindex/wrong_wire_type":         {0x14},
		"UnitStrindex/missing_value":           {0x10},
	}
}

func genTestEncodingValuesAttributeUnit() map[string]*otlpprofiles.AttributeUnit {
	return map[string]*otlpprofiles.AttributeUnit{
		"empty":                     NewOrigAttributeUnit(),
		"AttributeKeyStrindex/test": {AttributeKeyStrindex: int32(13)},
		"UnitStrindex/test":         {UnitStrindex: int32(13)},
	}
}
