// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run cmd/pdatagen/main.go".

package pdata

import (
	otlpmetrics "go.opentelemetry.io/collector/internal/data/opentelemetry-proto-gen/metrics/v1"
)

// ResourceMetricsSlice logically represents a slice of ResourceMetrics.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewResourceMetricsSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ResourceMetricsSlice struct {
	// orig points to the slice otlpmetrics.ResourceMetrics field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.ResourceMetrics
}

func newResourceMetricsSlice(orig *[]*otlpmetrics.ResourceMetrics) ResourceMetricsSlice {
	return ResourceMetricsSlice{orig}
}

// NewResourceMetricsSlice creates a ResourceMetricsSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewResourceMetricsSlice() ResourceMetricsSlice {
	orig := []*otlpmetrics.ResourceMetrics(nil)
	return ResourceMetricsSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewResourceMetricsSlice()".
func (es ResourceMetricsSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es ResourceMetricsSlice) At(ix int) ResourceMetrics {
	return newResourceMetrics(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es ResourceMetricsSlice) MoveAndAppendTo(dest ResourceMetricsSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es ResourceMetricsSlice) CopyTo(dest ResourceMetricsSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.ResourceMetrics(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newResourceMetrics(&el).CopyTo(newResourceMetrics(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.ResourceMetrics, newLen)
	wrappers := make([]*otlpmetrics.ResourceMetrics, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newResourceMetrics(&el).CopyTo(newResourceMetrics(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new ResourceMetricsSlice can be initialized:
// es := NewResourceMetricsSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es ResourceMetricsSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.ResourceMetrics(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.ResourceMetrics, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// InstrumentationLibraryMetrics is a collection of metrics from a LibraryInstrumentation.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewResourceMetrics function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ResourceMetrics struct {
	// orig points to the pointer otlpmetrics.ResourceMetrics field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.ResourceMetrics
}

func newResourceMetrics(orig **otlpmetrics.ResourceMetrics) ResourceMetrics {
	return ResourceMetrics{orig}
}

// NewResourceMetrics creates a new "nil" ResourceMetrics.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewResourceMetrics() ResourceMetrics {
	orig := (*otlpmetrics.ResourceMetrics)(nil)
	return newResourceMetrics(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms ResourceMetrics) InitEmpty() {
	*ms.orig = &otlpmetrics.ResourceMetrics{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms ResourceMetrics) IsNil() bool {
	return *ms.orig == nil
}

// Resource returns the resource associated with this ResourceMetrics.
// If no resource available, it creates an empty message and associates it with this ResourceMetrics.
//
//  Empty initialized ResourceMetrics will return "nil" Resource.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms ResourceMetrics) Resource() Resource {
	return newResource(&(*ms.orig).Resource)
}

// InstrumentationLibraryMetrics returns the InstrumentationLibraryMetrics associated with this ResourceMetrics.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms ResourceMetrics) InstrumentationLibraryMetrics() InstrumentationLibraryMetricsSlice {
	return newInstrumentationLibraryMetricsSlice(&(*ms.orig).InstrumentationLibraryMetrics)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms ResourceMetrics) CopyTo(dest ResourceMetrics) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.Resource().CopyTo(dest.Resource())
	ms.InstrumentationLibraryMetrics().CopyTo(dest.InstrumentationLibraryMetrics())
}

// InstrumentationLibraryMetricsSlice logically represents a slice of InstrumentationLibraryMetrics.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInstrumentationLibraryMetricsSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type InstrumentationLibraryMetricsSlice struct {
	// orig points to the slice otlpmetrics.InstrumentationLibraryMetrics field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.InstrumentationLibraryMetrics
}

func newInstrumentationLibraryMetricsSlice(orig *[]*otlpmetrics.InstrumentationLibraryMetrics) InstrumentationLibraryMetricsSlice {
	return InstrumentationLibraryMetricsSlice{orig}
}

// NewInstrumentationLibraryMetricsSlice creates a InstrumentationLibraryMetricsSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewInstrumentationLibraryMetricsSlice() InstrumentationLibraryMetricsSlice {
	orig := []*otlpmetrics.InstrumentationLibraryMetrics(nil)
	return InstrumentationLibraryMetricsSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewInstrumentationLibraryMetricsSlice()".
func (es InstrumentationLibraryMetricsSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es InstrumentationLibraryMetricsSlice) At(ix int) InstrumentationLibraryMetrics {
	return newInstrumentationLibraryMetrics(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es InstrumentationLibraryMetricsSlice) MoveAndAppendTo(dest InstrumentationLibraryMetricsSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es InstrumentationLibraryMetricsSlice) CopyTo(dest InstrumentationLibraryMetricsSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.InstrumentationLibraryMetrics(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newInstrumentationLibraryMetrics(&el).CopyTo(newInstrumentationLibraryMetrics(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.InstrumentationLibraryMetrics, newLen)
	wrappers := make([]*otlpmetrics.InstrumentationLibraryMetrics, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newInstrumentationLibraryMetrics(&el).CopyTo(newInstrumentationLibraryMetrics(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new InstrumentationLibraryMetricsSlice can be initialized:
// es := NewInstrumentationLibraryMetricsSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es InstrumentationLibraryMetricsSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.InstrumentationLibraryMetrics(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.InstrumentationLibraryMetrics, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// InstrumentationLibraryMetrics is a collection of metrics from a LibraryInstrumentation.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInstrumentationLibraryMetrics function to create new instances.
// Important: zero-initialized instance is not valid for use.
type InstrumentationLibraryMetrics struct {
	// orig points to the pointer otlpmetrics.InstrumentationLibraryMetrics field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.InstrumentationLibraryMetrics
}

func newInstrumentationLibraryMetrics(orig **otlpmetrics.InstrumentationLibraryMetrics) InstrumentationLibraryMetrics {
	return InstrumentationLibraryMetrics{orig}
}

// NewInstrumentationLibraryMetrics creates a new "nil" InstrumentationLibraryMetrics.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewInstrumentationLibraryMetrics() InstrumentationLibraryMetrics {
	orig := (*otlpmetrics.InstrumentationLibraryMetrics)(nil)
	return newInstrumentationLibraryMetrics(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms InstrumentationLibraryMetrics) InitEmpty() {
	*ms.orig = &otlpmetrics.InstrumentationLibraryMetrics{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms InstrumentationLibraryMetrics) IsNil() bool {
	return *ms.orig == nil
}

// InstrumentationLibrary returns the instrumentationlibrary associated with this InstrumentationLibraryMetrics.
// If no instrumentationlibrary available, it creates an empty message and associates it with this InstrumentationLibraryMetrics.
//
//  Empty initialized InstrumentationLibraryMetrics will return "nil" InstrumentationLibrary.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms InstrumentationLibraryMetrics) InstrumentationLibrary() InstrumentationLibrary {
	return newInstrumentationLibrary(&(*ms.orig).InstrumentationLibrary)
}

// Metrics returns the Metrics associated with this InstrumentationLibraryMetrics.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms InstrumentationLibraryMetrics) Metrics() MetricSlice {
	return newMetricSlice(&(*ms.orig).Metrics)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms InstrumentationLibraryMetrics) CopyTo(dest InstrumentationLibraryMetrics) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.InstrumentationLibrary().CopyTo(dest.InstrumentationLibrary())
	ms.Metrics().CopyTo(dest.Metrics())
}

// MetricSlice logically represents a slice of Metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetricSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type MetricSlice struct {
	// orig points to the slice otlpmetrics.Metric field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.Metric
}

func newMetricSlice(orig *[]*otlpmetrics.Metric) MetricSlice {
	return MetricSlice{orig}
}

// NewMetricSlice creates a MetricSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewMetricSlice() MetricSlice {
	orig := []*otlpmetrics.Metric(nil)
	return MetricSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewMetricSlice()".
func (es MetricSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es MetricSlice) At(ix int) Metric {
	return newMetric(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es MetricSlice) MoveAndAppendTo(dest MetricSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es MetricSlice) CopyTo(dest MetricSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.Metric(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newMetric(&el).CopyTo(newMetric(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.Metric, newLen)
	wrappers := make([]*otlpmetrics.Metric, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newMetric(&el).CopyTo(newMetric(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new MetricSlice can be initialized:
// es := NewMetricSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es MetricSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.Metric(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.Metric, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// Metric represents one metric as a collection of datapoints.
// See Metric definition in OTLP: https://github.com/open-telemetry/opentelemetry-proto/blob/master/opentelemetry/proto/metrics/v1/metrics.proto#L96
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetric function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Metric struct {
	// orig points to the pointer otlpmetrics.Metric field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.Metric
}

func newMetric(orig **otlpmetrics.Metric) Metric {
	return Metric{orig}
}

// NewMetric creates a new "nil" Metric.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewMetric() Metric {
	orig := (*otlpmetrics.Metric)(nil)
	return newMetric(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms Metric) InitEmpty() {
	*ms.orig = &otlpmetrics.Metric{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms Metric) IsNil() bool {
	return *ms.orig == nil
}

// MetricDescriptor returns the metricdescriptor associated with this Metric.
// If no metricdescriptor available, it creates an empty message and associates it with this Metric.
//
//  Empty initialized Metric will return "nil" MetricDescriptor.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Metric) MetricDescriptor() MetricDescriptor {
	return newMetricDescriptor(&(*ms.orig).MetricDescriptor)
}

// Int64DataPoints returns the Int64DataPoints associated with this Metric.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Metric) Int64DataPoints() Int64DataPointSlice {
	return newInt64DataPointSlice(&(*ms.orig).Int64DataPoints)
}

// DoubleDataPoints returns the DoubleDataPoints associated with this Metric.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Metric) DoubleDataPoints() DoubleDataPointSlice {
	return newDoubleDataPointSlice(&(*ms.orig).DoubleDataPoints)
}

// HistogramDataPoints returns the HistogramDataPoints associated with this Metric.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Metric) HistogramDataPoints() HistogramDataPointSlice {
	return newHistogramDataPointSlice(&(*ms.orig).HistogramDataPoints)
}

// SummaryDataPoints returns the SummaryDataPoints associated with this Metric.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Metric) SummaryDataPoints() SummaryDataPointSlice {
	return newSummaryDataPointSlice(&(*ms.orig).SummaryDataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms Metric) CopyTo(dest Metric) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.MetricDescriptor().CopyTo(dest.MetricDescriptor())
	ms.Int64DataPoints().CopyTo(dest.Int64DataPoints())
	ms.DoubleDataPoints().CopyTo(dest.DoubleDataPoints())
	ms.HistogramDataPoints().CopyTo(dest.HistogramDataPoints())
	ms.SummaryDataPoints().CopyTo(dest.SummaryDataPoints())
}

// MetricDescriptor is the descriptor of a metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetricDescriptor function to create new instances.
// Important: zero-initialized instance is not valid for use.
type MetricDescriptor struct {
	// orig points to the pointer otlpmetrics.MetricDescriptor field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.MetricDescriptor
}

func newMetricDescriptor(orig **otlpmetrics.MetricDescriptor) MetricDescriptor {
	return MetricDescriptor{orig}
}

// NewMetricDescriptor creates a new "nil" MetricDescriptor.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewMetricDescriptor() MetricDescriptor {
	orig := (*otlpmetrics.MetricDescriptor)(nil)
	return newMetricDescriptor(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms MetricDescriptor) InitEmpty() {
	*ms.orig = &otlpmetrics.MetricDescriptor{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms MetricDescriptor) IsNil() bool {
	return *ms.orig == nil
}

// Name returns the name associated with this MetricDescriptor.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms MetricDescriptor) Name() string {
	return (*ms.orig).Name
}

// SetName replaces the name associated with this MetricDescriptor.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms MetricDescriptor) SetName(v string) {
	(*ms.orig).Name = v
}

// Description returns the description associated with this MetricDescriptor.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms MetricDescriptor) Description() string {
	return (*ms.orig).Description
}

// SetDescription replaces the description associated with this MetricDescriptor.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms MetricDescriptor) SetDescription(v string) {
	(*ms.orig).Description = v
}

// Unit returns the unit associated with this MetricDescriptor.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms MetricDescriptor) Unit() string {
	return (*ms.orig).Unit
}

// SetUnit replaces the unit associated with this MetricDescriptor.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms MetricDescriptor) SetUnit(v string) {
	(*ms.orig).Unit = v
}

// Type returns the type associated with this MetricDescriptor.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms MetricDescriptor) Type() MetricType {
	return MetricType((*ms.orig).Type)
}

// SetType replaces the type associated with this MetricDescriptor.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms MetricDescriptor) SetType(v MetricType) {
	(*ms.orig).Type = otlpmetrics.MetricDescriptor_Type(v)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms MetricDescriptor) CopyTo(dest MetricDescriptor) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	dest.SetName(ms.Name())
	dest.SetDescription(ms.Description())
	dest.SetUnit(ms.Unit())
	dest.SetType(ms.Type())
}

// Int64DataPointSlice logically represents a slice of Int64DataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInt64DataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Int64DataPointSlice struct {
	// orig points to the slice otlpmetrics.Int64DataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.Int64DataPoint
}

func newInt64DataPointSlice(orig *[]*otlpmetrics.Int64DataPoint) Int64DataPointSlice {
	return Int64DataPointSlice{orig}
}

// NewInt64DataPointSlice creates a Int64DataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewInt64DataPointSlice() Int64DataPointSlice {
	orig := []*otlpmetrics.Int64DataPoint(nil)
	return Int64DataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewInt64DataPointSlice()".
func (es Int64DataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es Int64DataPointSlice) At(ix int) Int64DataPoint {
	return newInt64DataPoint(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es Int64DataPointSlice) MoveAndAppendTo(dest Int64DataPointSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es Int64DataPointSlice) CopyTo(dest Int64DataPointSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.Int64DataPoint(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newInt64DataPoint(&el).CopyTo(newInt64DataPoint(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.Int64DataPoint, newLen)
	wrappers := make([]*otlpmetrics.Int64DataPoint, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newInt64DataPoint(&el).CopyTo(newInt64DataPoint(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new Int64DataPointSlice can be initialized:
// es := NewInt64DataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es Int64DataPointSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.Int64DataPoint(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.Int64DataPoint, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// Int64DataPoint is a single data point in a timeseries that describes the time-varying values of a int64 metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInt64DataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Int64DataPoint struct {
	// orig points to the pointer otlpmetrics.Int64DataPoint field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.Int64DataPoint
}

func newInt64DataPoint(orig **otlpmetrics.Int64DataPoint) Int64DataPoint {
	return Int64DataPoint{orig}
}

// NewInt64DataPoint creates a new "nil" Int64DataPoint.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewInt64DataPoint() Int64DataPoint {
	orig := (*otlpmetrics.Int64DataPoint)(nil)
	return newInt64DataPoint(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms Int64DataPoint) InitEmpty() {
	*ms.orig = &otlpmetrics.Int64DataPoint{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms Int64DataPoint) IsNil() bool {
	return *ms.orig == nil
}

// LabelsMap returns the Labels associated with this Int64DataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Int64DataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this Int64DataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Int64DataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this Int64DataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Int64DataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this Int64DataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Int64DataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this Int64DataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Int64DataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Value returns the value associated with this Int64DataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Int64DataPoint) Value() int64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this Int64DataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Int64DataPoint) SetValue(v int64) {
	(*ms.orig).Value = v
}

// CopyTo copies all properties from the current struct to the dest.
func (ms Int64DataPoint) CopyTo(dest Int64DataPoint) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetValue(ms.Value())
}

// DoubleDataPointSlice logically represents a slice of DoubleDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleDataPointSlice struct {
	// orig points to the slice otlpmetrics.DoubleDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.DoubleDataPoint
}

func newDoubleDataPointSlice(orig *[]*otlpmetrics.DoubleDataPoint) DoubleDataPointSlice {
	return DoubleDataPointSlice{orig}
}

// NewDoubleDataPointSlice creates a DoubleDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewDoubleDataPointSlice() DoubleDataPointSlice {
	orig := []*otlpmetrics.DoubleDataPoint(nil)
	return DoubleDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewDoubleDataPointSlice()".
func (es DoubleDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es DoubleDataPointSlice) At(ix int) DoubleDataPoint {
	return newDoubleDataPoint(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es DoubleDataPointSlice) MoveAndAppendTo(dest DoubleDataPointSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es DoubleDataPointSlice) CopyTo(dest DoubleDataPointSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.DoubleDataPoint(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newDoubleDataPoint(&el).CopyTo(newDoubleDataPoint(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.DoubleDataPoint, newLen)
	wrappers := make([]*otlpmetrics.DoubleDataPoint, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newDoubleDataPoint(&el).CopyTo(newDoubleDataPoint(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new DoubleDataPointSlice can be initialized:
// es := NewDoubleDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es DoubleDataPointSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.DoubleDataPoint(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.DoubleDataPoint, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// DoubleDataPoint is a single data point in a timeseries that describes the time-varying value of a double metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleDataPoint struct {
	// orig points to the pointer otlpmetrics.DoubleDataPoint field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.DoubleDataPoint
}

func newDoubleDataPoint(orig **otlpmetrics.DoubleDataPoint) DoubleDataPoint {
	return DoubleDataPoint{orig}
}

// NewDoubleDataPoint creates a new "nil" DoubleDataPoint.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleDataPoint() DoubleDataPoint {
	orig := (*otlpmetrics.DoubleDataPoint)(nil)
	return newDoubleDataPoint(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms DoubleDataPoint) InitEmpty() {
	*ms.orig = &otlpmetrics.DoubleDataPoint{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms DoubleDataPoint) IsNil() bool {
	return *ms.orig == nil
}

// LabelsMap returns the Labels associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Value returns the value associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) Value() float64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) SetValue(v float64) {
	(*ms.orig).Value = v
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleDataPoint) CopyTo(dest DoubleDataPoint) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetValue(ms.Value())
}

// HistogramDataPointSlice logically represents a slice of HistogramDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogramDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramDataPointSlice struct {
	// orig points to the slice otlpmetrics.HistogramDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.HistogramDataPoint
}

func newHistogramDataPointSlice(orig *[]*otlpmetrics.HistogramDataPoint) HistogramDataPointSlice {
	return HistogramDataPointSlice{orig}
}

// NewHistogramDataPointSlice creates a HistogramDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewHistogramDataPointSlice() HistogramDataPointSlice {
	orig := []*otlpmetrics.HistogramDataPoint(nil)
	return HistogramDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewHistogramDataPointSlice()".
func (es HistogramDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es HistogramDataPointSlice) At(ix int) HistogramDataPoint {
	return newHistogramDataPoint(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es HistogramDataPointSlice) MoveAndAppendTo(dest HistogramDataPointSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es HistogramDataPointSlice) CopyTo(dest HistogramDataPointSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.HistogramDataPoint(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newHistogramDataPoint(&el).CopyTo(newHistogramDataPoint(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.HistogramDataPoint, newLen)
	wrappers := make([]*otlpmetrics.HistogramDataPoint, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newHistogramDataPoint(&el).CopyTo(newHistogramDataPoint(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new HistogramDataPointSlice can be initialized:
// es := NewHistogramDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es HistogramDataPointSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.HistogramDataPoint(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.HistogramDataPoint, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// HistogramDataPoint is a single data point in a timeseries that describes the time-varying values of a Histogram.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogramDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramDataPoint struct {
	// orig points to the pointer otlpmetrics.HistogramDataPoint field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.HistogramDataPoint
}

func newHistogramDataPoint(orig **otlpmetrics.HistogramDataPoint) HistogramDataPoint {
	return HistogramDataPoint{orig}
}

// NewHistogramDataPoint creates a new "nil" HistogramDataPoint.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewHistogramDataPoint() HistogramDataPoint {
	orig := (*otlpmetrics.HistogramDataPoint)(nil)
	return newHistogramDataPoint(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms HistogramDataPoint) InitEmpty() {
	*ms.orig = &otlpmetrics.HistogramDataPoint{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms HistogramDataPoint) IsNil() bool {
	return *ms.orig == nil
}

// LabelsMap returns the Labels associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Count returns the count associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) Count() uint64 {
	return (*ms.orig).Count
}

// SetCount replaces the count associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) SetCount(v uint64) {
	(*ms.orig).Count = v
}

// Sum returns the sum associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) Sum() float64 {
	return (*ms.orig).Sum
}

// SetSum replaces the sum associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) SetSum(v float64) {
	(*ms.orig).Sum = v
}

// Buckets returns the Buckets associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) Buckets() HistogramBucketSlice {
	return newHistogramBucketSlice(&(*ms.orig).Buckets)
}

// ExplicitBounds returns the explicitbounds associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) ExplicitBounds() []float64 {
	return (*ms.orig).ExplicitBounds
}

// SetExplicitBounds replaces the explicitbounds associated with this HistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramDataPoint) SetExplicitBounds(v []float64) {
	(*ms.orig).ExplicitBounds = v
}

// CopyTo copies all properties from the current struct to the dest.
func (ms HistogramDataPoint) CopyTo(dest HistogramDataPoint) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetCount(ms.Count())
	dest.SetSum(ms.Sum())
	ms.Buckets().CopyTo(dest.Buckets())
	dest.SetExplicitBounds(ms.ExplicitBounds())
}

// HistogramBucketSlice logically represents a slice of HistogramBucket.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogramBucketSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramBucketSlice struct {
	// orig points to the slice otlpmetrics.HistogramDataPoint_Bucket field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.HistogramDataPoint_Bucket
}

func newHistogramBucketSlice(orig *[]*otlpmetrics.HistogramDataPoint_Bucket) HistogramBucketSlice {
	return HistogramBucketSlice{orig}
}

// NewHistogramBucketSlice creates a HistogramBucketSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewHistogramBucketSlice() HistogramBucketSlice {
	orig := []*otlpmetrics.HistogramDataPoint_Bucket(nil)
	return HistogramBucketSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewHistogramBucketSlice()".
func (es HistogramBucketSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es HistogramBucketSlice) At(ix int) HistogramBucket {
	return newHistogramBucket(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es HistogramBucketSlice) MoveAndAppendTo(dest HistogramBucketSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es HistogramBucketSlice) CopyTo(dest HistogramBucketSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.HistogramDataPoint_Bucket(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newHistogramBucket(&el).CopyTo(newHistogramBucket(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.HistogramDataPoint_Bucket, newLen)
	wrappers := make([]*otlpmetrics.HistogramDataPoint_Bucket, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newHistogramBucket(&el).CopyTo(newHistogramBucket(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new HistogramBucketSlice can be initialized:
// es := NewHistogramBucketSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es HistogramBucketSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.HistogramDataPoint_Bucket(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.HistogramDataPoint_Bucket, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// HistogramBucket contains values for a histogram bucket.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogramBucket function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramBucket struct {
	// orig points to the pointer otlpmetrics.HistogramDataPoint_Bucket field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.HistogramDataPoint_Bucket
}

func newHistogramBucket(orig **otlpmetrics.HistogramDataPoint_Bucket) HistogramBucket {
	return HistogramBucket{orig}
}

// NewHistogramBucket creates a new "nil" HistogramBucket.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewHistogramBucket() HistogramBucket {
	orig := (*otlpmetrics.HistogramDataPoint_Bucket)(nil)
	return newHistogramBucket(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms HistogramBucket) InitEmpty() {
	*ms.orig = &otlpmetrics.HistogramDataPoint_Bucket{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms HistogramBucket) IsNil() bool {
	return *ms.orig == nil
}

// Count returns the count associated with this HistogramBucket.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramBucket) Count() uint64 {
	return (*ms.orig).Count
}

// SetCount replaces the count associated with this HistogramBucket.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramBucket) SetCount(v uint64) {
	(*ms.orig).Count = v
}

// Exemplar returns the exemplar associated with this HistogramBucket.
// If no exemplar available, it creates an empty message and associates it with this HistogramBucket.
//
//  Empty initialized HistogramBucket will return "nil" HistogramBucketExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramBucket) Exemplar() HistogramBucketExemplar {
	return newHistogramBucketExemplar(&(*ms.orig).Exemplar)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms HistogramBucket) CopyTo(dest HistogramBucket) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	dest.SetCount(ms.Count())
	ms.Exemplar().CopyTo(dest.Exemplar())
}

// HistogramBucketExemplar are example points that may be used to annotate aggregated Histogram values.
// They are metadata that gives information about a particular value added to a Histogram bucket.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogramBucketExemplar function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramBucketExemplar struct {
	// orig points to the pointer otlpmetrics.HistogramDataPoint_Bucket_Exemplar field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.HistogramDataPoint_Bucket_Exemplar
}

func newHistogramBucketExemplar(orig **otlpmetrics.HistogramDataPoint_Bucket_Exemplar) HistogramBucketExemplar {
	return HistogramBucketExemplar{orig}
}

// NewHistogramBucketExemplar creates a new "nil" HistogramBucketExemplar.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewHistogramBucketExemplar() HistogramBucketExemplar {
	orig := (*otlpmetrics.HistogramDataPoint_Bucket_Exemplar)(nil)
	return newHistogramBucketExemplar(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms HistogramBucketExemplar) InitEmpty() {
	*ms.orig = &otlpmetrics.HistogramDataPoint_Bucket_Exemplar{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms HistogramBucketExemplar) IsNil() bool {
	return *ms.orig == nil
}

// Timestamp returns the timestamp associated with this HistogramBucketExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramBucketExemplar) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this HistogramBucketExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramBucketExemplar) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Value returns the value associated with this HistogramBucketExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramBucketExemplar) Value() float64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this HistogramBucketExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramBucketExemplar) SetValue(v float64) {
	(*ms.orig).Value = v
}

// Attachments returns the Attachments associated with this HistogramBucketExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms HistogramBucketExemplar) Attachments() StringMap {
	return newStringMap(&(*ms.orig).Attachments)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms HistogramBucketExemplar) CopyTo(dest HistogramBucketExemplar) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	dest.SetTimestamp(ms.Timestamp())
	dest.SetValue(ms.Value())
	ms.Attachments().CopyTo(dest.Attachments())
}

// SummaryDataPointSlice logically represents a slice of SummaryDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSummaryDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type SummaryDataPointSlice struct {
	// orig points to the slice otlpmetrics.SummaryDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.SummaryDataPoint
}

func newSummaryDataPointSlice(orig *[]*otlpmetrics.SummaryDataPoint) SummaryDataPointSlice {
	return SummaryDataPointSlice{orig}
}

// NewSummaryDataPointSlice creates a SummaryDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewSummaryDataPointSlice() SummaryDataPointSlice {
	orig := []*otlpmetrics.SummaryDataPoint(nil)
	return SummaryDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewSummaryDataPointSlice()".
func (es SummaryDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es SummaryDataPointSlice) At(ix int) SummaryDataPoint {
	return newSummaryDataPoint(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es SummaryDataPointSlice) MoveAndAppendTo(dest SummaryDataPointSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es SummaryDataPointSlice) CopyTo(dest SummaryDataPointSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.SummaryDataPoint(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newSummaryDataPoint(&el).CopyTo(newSummaryDataPoint(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.SummaryDataPoint, newLen)
	wrappers := make([]*otlpmetrics.SummaryDataPoint, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newSummaryDataPoint(&el).CopyTo(newSummaryDataPoint(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new SummaryDataPointSlice can be initialized:
// es := NewSummaryDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es SummaryDataPointSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.SummaryDataPoint(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.SummaryDataPoint, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// SummaryDataPoint is a single data point in a timeseries that describes the time-varying values of a Summary metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSummaryDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type SummaryDataPoint struct {
	// orig points to the pointer otlpmetrics.SummaryDataPoint field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.SummaryDataPoint
}

func newSummaryDataPoint(orig **otlpmetrics.SummaryDataPoint) SummaryDataPoint {
	return SummaryDataPoint{orig}
}

// NewSummaryDataPoint creates a new "nil" SummaryDataPoint.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewSummaryDataPoint() SummaryDataPoint {
	orig := (*otlpmetrics.SummaryDataPoint)(nil)
	return newSummaryDataPoint(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms SummaryDataPoint) InitEmpty() {
	*ms.orig = &otlpmetrics.SummaryDataPoint{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms SummaryDataPoint) IsNil() bool {
	return *ms.orig == nil
}

// LabelsMap returns the Labels associated with this SummaryDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this SummaryDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this SummaryDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this SummaryDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this SummaryDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Count returns the count associated with this SummaryDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryDataPoint) Count() uint64 {
	return (*ms.orig).Count
}

// SetCount replaces the count associated with this SummaryDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryDataPoint) SetCount(v uint64) {
	(*ms.orig).Count = v
}

// Sum returns the sum associated with this SummaryDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryDataPoint) Sum() float64 {
	return (*ms.orig).Sum
}

// SetSum replaces the sum associated with this SummaryDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryDataPoint) SetSum(v float64) {
	(*ms.orig).Sum = v
}

// ValueAtPercentiles returns the PercentileValues associated with this SummaryDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryDataPoint) ValueAtPercentiles() SummaryValueAtPercentileSlice {
	return newSummaryValueAtPercentileSlice(&(*ms.orig).PercentileValues)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms SummaryDataPoint) CopyTo(dest SummaryDataPoint) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetCount(ms.Count())
	dest.SetSum(ms.Sum())
	ms.ValueAtPercentiles().CopyTo(dest.ValueAtPercentiles())
}

// SummaryValueAtPercentileSlice logically represents a slice of SummaryValueAtPercentile.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSummaryValueAtPercentileSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type SummaryValueAtPercentileSlice struct {
	// orig points to the slice otlpmetrics.SummaryDataPoint_ValueAtPercentile field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.SummaryDataPoint_ValueAtPercentile
}

func newSummaryValueAtPercentileSlice(orig *[]*otlpmetrics.SummaryDataPoint_ValueAtPercentile) SummaryValueAtPercentileSlice {
	return SummaryValueAtPercentileSlice{orig}
}

// NewSummaryValueAtPercentileSlice creates a SummaryValueAtPercentileSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewSummaryValueAtPercentileSlice() SummaryValueAtPercentileSlice {
	orig := []*otlpmetrics.SummaryDataPoint_ValueAtPercentile(nil)
	return SummaryValueAtPercentileSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewSummaryValueAtPercentileSlice()".
func (es SummaryValueAtPercentileSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es SummaryValueAtPercentileSlice) At(ix int) SummaryValueAtPercentile {
	return newSummaryValueAtPercentile(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es SummaryValueAtPercentileSlice) MoveAndAppendTo(dest SummaryValueAtPercentileSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es SummaryValueAtPercentileSlice) CopyTo(dest SummaryValueAtPercentileSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.SummaryDataPoint_ValueAtPercentile(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newSummaryValueAtPercentile(&el).CopyTo(newSummaryValueAtPercentile(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.SummaryDataPoint_ValueAtPercentile, newLen)
	wrappers := make([]*otlpmetrics.SummaryDataPoint_ValueAtPercentile, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newSummaryValueAtPercentile(&el).CopyTo(newSummaryValueAtPercentile(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new SummaryValueAtPercentileSlice can be initialized:
// es := NewSummaryValueAtPercentileSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es SummaryValueAtPercentileSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.SummaryDataPoint_ValueAtPercentile(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.SummaryDataPoint_ValueAtPercentile, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// SummaryValueAtPercentile represents the value at a given percentile of a distribution.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSummaryValueAtPercentile function to create new instances.
// Important: zero-initialized instance is not valid for use.
type SummaryValueAtPercentile struct {
	// orig points to the pointer otlpmetrics.SummaryDataPoint_ValueAtPercentile field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.SummaryDataPoint_ValueAtPercentile
}

func newSummaryValueAtPercentile(orig **otlpmetrics.SummaryDataPoint_ValueAtPercentile) SummaryValueAtPercentile {
	return SummaryValueAtPercentile{orig}
}

// NewSummaryValueAtPercentile creates a new "nil" SummaryValueAtPercentile.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewSummaryValueAtPercentile() SummaryValueAtPercentile {
	orig := (*otlpmetrics.SummaryDataPoint_ValueAtPercentile)(nil)
	return newSummaryValueAtPercentile(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms SummaryValueAtPercentile) InitEmpty() {
	*ms.orig = &otlpmetrics.SummaryDataPoint_ValueAtPercentile{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms SummaryValueAtPercentile) IsNil() bool {
	return *ms.orig == nil
}

// Percentile returns the percentile associated with this SummaryValueAtPercentile.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryValueAtPercentile) Percentile() float64 {
	return (*ms.orig).Percentile
}

// SetPercentile replaces the percentile associated with this SummaryValueAtPercentile.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryValueAtPercentile) SetPercentile(v float64) {
	(*ms.orig).Percentile = v
}

// Value returns the value associated with this SummaryValueAtPercentile.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryValueAtPercentile) Value() float64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this SummaryValueAtPercentile.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms SummaryValueAtPercentile) SetValue(v float64) {
	(*ms.orig).Value = v
}

// CopyTo copies all properties from the current struct to the dest.
func (ms SummaryValueAtPercentile) CopyTo(dest SummaryValueAtPercentile) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	dest.SetPercentile(ms.Percentile())
	dest.SetValue(ms.Value())
}
