/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.CellUsage;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.NccUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CompareList {
    private final List cellContexts = new ArrayList();
    private boolean safeToCheckSizes;

    private boolean hasSkipAnnotation(List cellCtxts) {
        Iterator it = cellCtxts.iterator();
        while (it.hasNext()) {
            String reason;
            Cell c = ((CellContext)it.next()).cell;
            NccCellAnnotations ann = NccCellAnnotations.getAnnotations(c);
            if (ann == null || (reason = ann.getSkipReason()) == null) continue;
            System.out.println("Skip NCC of " + NccUtils.fullName(c) + " because " + reason);
            return true;
        }
        return false;
    }

    private void purgeUnnecessaryDuplicateCells(List compareList) {
        HashSet<Cell> cells = new HashSet<Cell>();
        Iterator it = compareList.iterator();
        while (it.hasNext() && compareList.size() > 2) {
            Cell c = ((CellContext)it.next()).cell;
            if (cells.contains(c)) {
                it.remove();
                continue;
            }
            cells.add(c);
        }
    }

    private boolean safeToCompareSizes(List cellContexts, CellUsage use1, CellUsage use2) {
        Iterator it = cellContexts.iterator();
        while (it.hasNext()) {
            Cell c = ((CellContext)it.next()).cell;
            if (!c.isSchematic()) continue;
            if (use1.cellIsUsed(c) && !use1.cellIsUsedOnce(c)) {
                return false;
            }
            if (!use2.cellIsUsed(c) || use2.cellIsUsedOnce(c)) continue;
            return false;
        }
        return true;
    }

    public CompareList(Cell cell, CellUsage use1, CellUsage use2) {
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(cell);
        Cell.CellGroup group = cell.getCellGroup();
        if (ann != null && ann.getGroupToJoin() != null && ann.getGroupToJoin() != group) {
            return;
        }
        boolean used1 = false;
        boolean used2 = false;
        HashSet<CellContext> compareSet = new HashSet<CellContext>();
        Set additions = use1.getGroupAdditions(group);
        if (!additions.isEmpty()) {
            used1 = true;
            compareSet.addAll(additions);
        }
        if (!(additions = use2.getGroupAdditions(group)).isEmpty()) {
            used2 = true;
            compareSet.addAll(additions);
        }
        Iterator gi = group.getCells();
        while (gi.hasNext()) {
            Cell c = (Cell)gi.next();
            if (use1.cellIsUsed(c)) {
                used1 = true;
                compareSet.add(use1.getCellContext(c));
            }
            if (!use2.cellIsUsed(c)) continue;
            used2 = true;
            compareSet.add(use2.getCellContext(c));
        }
        if (cell == use1.getRoot()) {
            used2 = true;
            used1 = true;
            compareSet.add(use2.getCellContext(use2.getRoot()));
        }
        if (cell == use2.getRoot()) {
            used2 = true;
            used1 = true;
            compareSet.add(use1.getCellContext(use1.getRoot()));
        }
        LayoutLib.error(compareSet.size() == 0, "Cell not in its own group?");
        if (!used1 || !used2) {
            return;
        }
        this.cellContexts.addAll(compareSet);
        this.purgeUnnecessaryDuplicateCells(this.cellContexts);
        if (this.hasSkipAnnotation(this.cellContexts)) {
            this.cellContexts.clear();
        }
        this.safeToCheckSizes = this.safeToCompareSizes(this.cellContexts, use1, use2);
        LayoutLib.error(compareSet.size() < 2, "nothing to compare?");
    }

    public Iterator iterator() {
        return this.cellContexts.iterator();
    }

    public boolean empty() {
        return this.cellContexts.size() == 0;
    }

    public boolean isSafeToCheckSizes() {
        return this.safeToCheckSizes;
    }
}

