/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ColorPatternPanel;
import com.sun.electric.tool.user.dialogs.options.LayersTab;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JColorChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorsTab
extends PreferencePanel {
    private JList colorLayerList;
    private DefaultListModel colorLayerModel;
    private HashMap transAndSpecialMap;
    private JColorChooser colorChooser;
    private JScrollPane colorLayerPane;
    private JPanel colors;

    public ColorsTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.colors;
    }

    public String getName() {
        return "Colors";
    }

    public void init() {
        this.transAndSpecialMap = new HashMap();
        this.colorLayerModel = new DefaultListModel();
        this.colorLayerList = new JList(this.colorLayerModel);
        this.colorLayerList.setSelectionMode(0);
        this.colorLayerPane.setViewportView(this.colorLayerList);
        this.colorLayerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ColorsTab.this.colorClickedLayer();
            }
        });
        HashMap<Integer, StringBuffer> transparentLayers = new HashMap<Integer, StringBuffer>();
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            EGraphics graphics;
            int transparentLayer;
            Layer layer = (Layer)it.next();
            if ((layer.getFunctionExtras() & 0x1000) != 0 || (transparentLayer = (graphics = layer.getGraphics()).getTransparentLayer()) == 0) continue;
            StringBuffer layers = (StringBuffer)transparentLayers.get(new Integer(transparentLayer));
            if (layers == null) {
                layers = new StringBuffer();
                layers.append(layer.getName());
                transparentLayers.put(new Integer(transparentLayer), layers);
                continue;
            }
            layers.append(", " + layer.getName());
        }
        Color[] currentMap = this.curTech.getColorMap();
        ArrayList transparentSet = new ArrayList();
        Iterator<Object> it2 = transparentLayers.keySet().iterator();
        while (it2.hasNext()) {
            transparentSet.add(it2.next());
        }
        Collections.sort(transparentSet, new TransparentSort());
        it2 = transparentSet.iterator();
        while (it2.hasNext()) {
            Integer layerNumber = (Integer)it2.next();
            StringBuffer layerNames = (StringBuffer)transparentLayers.get(layerNumber);
            this.colorLayerModel.addElement("Transparent " + layerNumber + ": " + layerNames.toString());
            int color = currentMap[1 << layerNumber - 1].getRGB();
            this.transAndSpecialMap.put(layerNumber, new GenMath.MutableInteger(color));
        }
        it2 = this.curTech.getLayers();
        while (it2.hasNext()) {
            EGraphics graphics;
            Layer layer = (Layer)it2.next();
            if ((layer.getFunctionExtras() & 0x1000) != 0 || (graphics = layer.getGraphics()).getTransparentLayer() > 0) continue;
            this.colorLayerModel.addElement(layer.getName());
        }
        int color = User.getColorBackground();
        String name = "Special: BACKGROUND";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorGrid();
        name = "Special: GRID";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorHighlight();
        name = "Special: HIGHLIGHT";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorMouseOverHighlight();
        name = "Special: MOUSE-OVER HIGHLIGHT";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorPortHighlight();
        name = "Special: PORT HIGHLIGHT";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorText();
        name = "Special: TEXT";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorInstanceOutline();
        name = "Special: INSTANCE OUTLINES";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorWaveformBackground();
        name = "Special: WAVEFORM BACKGROUND";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorWaveformForeground();
        name = "Special: WAVEFORM FOREGROUND";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorWaveformStimuli();
        name = "Special: WAVEFORM STIMULI";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorWaveformStrengthOff();
        name = "Special: WAVEFORM OFF STRENGTH";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorWaveformStrengthNode();
        name = "Special: WAVEFORM NODE (WEAK) STRENGTH";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorWaveformStrengthGate();
        name = "Special: WAVEFORM GATE STRENGTH";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorWaveformStrengthPower();
        name = "Special: WAVEFORM POWER STRENGTH";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorWaveformCrossProbeLow();
        name = "Special: WAVEFORM CROSSPROBE LOW";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorWaveformCrossProbeHigh();
        name = "Special: WAVEFORM CROSSPROBE HIGH";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorWaveformCrossProbeX();
        name = "Special: WAVEFORM CROSSPROBE UNDEFINED";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        color = User.getColorWaveformCrossProbeZ();
        name = "Special: WAVEFORM CROSSPROBE FLOATING";
        this.colorLayerModel.addElement(name);
        this.transAndSpecialMap.put(name, new GenMath.MutableInteger(color));
        try {
            Class j3DUtilsClass = Resources.get3DClass("utils.J3DUtils");
            Method setMethod = j3DUtilsClass.getDeclaredMethod("get3DColorsInTab", DefaultListModel.class, HashMap.class);
            setMethod.invoke((Object)j3DUtilsClass, this.colorLayerModel, this.transAndSpecialMap);
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method get3DColorsInTab: " + e.getMessage());
            e.printStackTrace();
        }
        this.colorLayerList.setSelectedIndex(0);
        this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ColorsTab.this.colorChanged();
            }
        });
        this.colorClickedLayer();
    }

    private Object colorGetCurrent() {
        String layerName = (String)this.colorLayerList.getSelectedValue();
        if (layerName.startsWith("Transparent ")) {
            int layerNumber = TextUtils.atoi(layerName.substring(12));
            return (GenMath.MutableInteger)this.transAndSpecialMap.get(new Integer(layerNumber));
        }
        if (layerName.startsWith("Special: ")) {
            return (GenMath.MutableInteger)this.transAndSpecialMap.get(layerName);
        }
        Layer layer = this.curTech.findLayer(layerName);
        if (layer == null) {
            return null;
        }
        ColorPatternPanel.Info li = (ColorPatternPanel.Info)LayersTab.layerMap.get(layer);
        return li;
    }

    private void colorChanged() {
        Object colorObj = this.colorGetCurrent();
        if (colorObj == null) {
            return;
        }
        if (colorObj instanceof GenMath.MutableInteger) {
            ((GenMath.MutableInteger)colorObj).setValue(this.colorChooser.getColor().getRGB());
        } else if (colorObj instanceof ColorPatternPanel.Info) {
            ColorPatternPanel.Info ci = (ColorPatternPanel.Info)colorObj;
            ci.red = this.colorChooser.getColor().getRed();
            ci.green = this.colorChooser.getColor().getGreen();
            ci.blue = this.colorChooser.getColor().getBlue();
        }
    }

    private void colorClickedLayer() {
        Object colorObj = this.colorGetCurrent();
        if (colorObj == null) {
            return;
        }
        if (colorObj instanceof GenMath.MutableInteger) {
            this.colorChooser.setColor(new Color(((GenMath.MutableInteger)colorObj).intValue()));
        } else if (colorObj instanceof ColorPatternPanel.Info) {
            ColorPatternPanel.Info ci = (ColorPatternPanel.Info)colorObj;
            this.colorChooser.setColor(new Color(ci.red, ci.green, ci.blue));
        }
    }

    public void term() {
        Color[] currentMap = this.curTech.getColorMap();
        boolean colorChanged = false;
        boolean mapChanged = false;
        Color[] transparentLayerColors = new Color[this.curTech.getNumTransparentLayers()];
        for (int i = 0; i < this.colorLayerModel.getSize(); ++i) {
            String layerName = (String)this.colorLayerModel.get(i);
            if (layerName.startsWith("Transparent ")) {
                int layerNumber = TextUtils.atoi(layerName.substring(12));
                GenMath.MutableInteger color = (GenMath.MutableInteger)this.transAndSpecialMap.get(new Integer(layerNumber));
                transparentLayerColors[layerNumber - 1] = new Color(color.intValue());
                int mapIndex = 1 << layerNumber - 1;
                int origColor = currentMap[mapIndex].getRGB();
                if (color.intValue() == origColor) continue;
                currentMap[mapIndex] = new Color(color.intValue());
                colorChanged = true;
                mapChanged = true;
                continue;
            }
            if (!layerName.startsWith("Special: ")) continue;
            GenMath.MutableInteger color = (GenMath.MutableInteger)this.transAndSpecialMap.get(layerName);
            if (layerName.equals("Special: BACKGROUND")) {
                if (color.intValue() == User.getColorBackground()) continue;
                User.setColorBackground(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: GRID")) {
                if (color.intValue() == User.getColorGrid()) continue;
                User.setColorGrid(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: HIGHLIGHT")) {
                if (color.intValue() == User.getColorHighlight()) continue;
                User.setColorHighlight(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: MOUSE-OVER HIGHLIGHT")) {
                if (color.intValue() == User.getColorHighlight()) continue;
                User.setColorMouseOverHighlight(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: PORT HIGHLIGHT")) {
                if (color.intValue() == User.getColorPortHighlight()) continue;
                User.setColorPortHighlight(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: TEXT")) {
                if (color.intValue() == User.getColorText()) continue;
                User.setColorText(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: INSTANCE OUTLINES")) {
                if (color.intValue() == User.getColorInstanceOutline()) continue;
                User.setColorInstanceOutline(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: WAVEFORM BACKGROUND")) {
                if (color.intValue() == User.getColorWaveformBackground()) continue;
                User.setColorWaveformBackground(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: WAVEFORM FOREGROUND")) {
                if (color.intValue() == User.getColorWaveformForeground()) continue;
                User.setColorWaveformForeground(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: WAVEFORM STIMULI")) {
                if (color.intValue() == User.getColorWaveformStimuli()) continue;
                User.setColorWaveformStimuli(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: WAVEFORM OFF STRENGTH")) {
                if (color.intValue() == User.getColorWaveformStrengthOff()) continue;
                User.setColorWaveformStrengthOff(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: WAVEFORM NODE (WEAK) STRENGTH")) {
                if (color.intValue() == User.getColorWaveformStrengthNode()) continue;
                User.setColorWaveformStrengthNode(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: WAVEFORM GATE STRENGTH")) {
                if (color.intValue() == User.getColorWaveformStrengthGate()) continue;
                User.setColorWaveformStrengthGate(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: WAVEFORM POWER STRENGTH")) {
                if (color.intValue() == User.getColorWaveformStrengthPower()) continue;
                User.setColorWaveformStrengthPower(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: WAVEFORM CROSSPROBE LOW")) {
                if (color.intValue() == User.getColorWaveformCrossProbeLow()) continue;
                User.setColorWaveformCrossProbeLow(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: WAVEFORM CROSSPROBE HIGH")) {
                if (color.intValue() == User.getColorWaveformCrossProbeHigh()) continue;
                User.setColorWaveformCrossProbeHigh(color.intValue());
                colorChanged = true;
                continue;
            }
            if (layerName.equals("Special: WAVEFORM CROSSPROBE UNDEFINED")) {
                if (color.intValue() == User.getColorWaveformCrossProbeX()) continue;
                User.setColorWaveformCrossProbeX(color.intValue());
                colorChanged = true;
                continue;
            }
            if (!layerName.equals("Special: WAVEFORM CROSSPROBE FLOATING") || color.intValue() == User.getColorWaveformCrossProbeZ()) continue;
            User.setColorWaveformCrossProbeZ(color.intValue());
            colorChanged = true;
        }
        try {
            Class j3DUtilsClass = Resources.get3DClass("utils.J3DUtils");
            Method setMethod = j3DUtilsClass.getDeclaredMethod("set3DColorsInTab", DefaultListModel.class, HashMap.class);
            Object color3DChanged = setMethod.invoke((Object)j3DUtilsClass, this.colorLayerModel, this.transAndSpecialMap);
            if (!colorChanged && color3DChanged != null) {
                colorChanged = (Boolean)color3DChanged;
            }
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method set3DColorsInTab: " + e.getMessage());
            e.printStackTrace();
        }
        if (mapChanged) {
            this.curTech.setColorMapFromLayers(transparentLayerColors);
        }
        if (colorChanged) {
            EditWindow.repaintAllContents();
            WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
            if (wf != null) {
                wf.loadComponentMenuForTechnology();
            }
        }
    }

    private void initComponents() {
        this.colors = new JPanel();
        this.colorChooser = new JColorChooser();
        this.colorLayerPane = new JScrollPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ColorsTab.this.closeDialog(evt);
            }
        });
        this.colors.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.colors.add((Component)this.colorChooser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.colors.add((Component)this.colorLayerPane, gridBagConstraints);
        this.getContentPane().add((Component)this.colors, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class TransparentSort
    implements Comparator {
        private TransparentSort() {
        }

        public int compare(Object o1, Object o2) {
            Integer i1 = (Integer)o1;
            Integer i2 = (Integer)o2;
            return i1 - i2;
        }
    }
}

