/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextTab
extends PreferencePanel {
    private MutableTextDescriptor initialTextNodeDescriptor;
    private MutableTextDescriptor currentTextNodeDescriptor;
    private MutableTextDescriptor initialTextArcDescriptor;
    private MutableTextDescriptor currentTextArcDescriptor;
    private MutableTextDescriptor initialTextExportDescriptor;
    private MutableTextDescriptor currentTextExportDescriptor;
    private MutableTextDescriptor initialTextAnnotationDescriptor;
    private MutableTextDescriptor currentTextAnnotationDescriptor;
    private MutableTextDescriptor initialTextInstanceDescriptor;
    private MutableTextDescriptor currentTextInstanceDescriptor;
    private MutableTextDescriptor initialTextCellDescriptor;
    private MutableTextDescriptor currentTextCellDescriptor;
    private MutableTextDescriptor currentTextDescriptor;
    private boolean textValuesChanging = false;
    private JPanel bottom;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel56;
    private JLabel jLabel57;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JPanel middle;
    private JPanel text;
    private JComboBox textAnchor;
    private JRadioButton textAnnotation;
    private JRadioButton textArcs;
    private JCheckBox textBold;
    private JRadioButton textCellText;
    private JComboBox textDefaultFont;
    private JComboBox textFace;
    private JTextField textGlobalScale;
    private ButtonGroup textHorizontalGroup;
    private JRadioButton textInstances;
    private JCheckBox textItalic;
    private JCheckBox textNewVisibleInsideCell;
    private JRadioButton textNodes;
    private JTextField textPointSize;
    private JRadioButton textPoints;
    private JRadioButton textPorts;
    private ButtonGroup textSizeGroup;
    private JRadioButton textSmartHorizontalInside;
    private JRadioButton textSmartHorizontalOff;
    private JRadioButton textSmartHorizontalOutside;
    private JRadioButton textSmartVerticalInside;
    private JRadioButton textSmartVerticalOff;
    private JRadioButton textSmartVerticalOutside;
    private ButtonGroup textTypeGroup;
    private JCheckBox textUnderline;
    private JTextField textUnitSize;
    private JRadioButton textUnits;
    private ButtonGroup textVerticalGroup;
    private JPanel top;

    public TextTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.text;
    }

    public String getName() {
        return "Text";
    }

    public void init() {
        Iterator it = TextDescriptor.Position.getPositions();
        while (it.hasNext()) {
            TextDescriptor.Position pos = (TextDescriptor.Position)it.next();
            this.textAnchor.addItem(pos);
        }
        this.initialTextNodeDescriptor = MutableTextDescriptor.getNodeTextDescriptor();
        this.initialTextArcDescriptor = MutableTextDescriptor.getArcTextDescriptor();
        this.initialTextExportDescriptor = MutableTextDescriptor.getExportTextDescriptor();
        this.initialTextAnnotationDescriptor = MutableTextDescriptor.getAnnotationTextDescriptor();
        this.initialTextInstanceDescriptor = MutableTextDescriptor.getInstanceTextDescriptor();
        this.initialTextCellDescriptor = MutableTextDescriptor.getCellTextDescriptor();
        this.currentTextNodeDescriptor = MutableTextDescriptor.getNodeTextDescriptor();
        this.currentTextArcDescriptor = MutableTextDescriptor.getArcTextDescriptor();
        this.currentTextExportDescriptor = MutableTextDescriptor.getExportTextDescriptor();
        this.currentTextAnnotationDescriptor = MutableTextDescriptor.getAnnotationTextDescriptor();
        this.currentTextInstanceDescriptor = MutableTextDescriptor.getInstanceTextDescriptor();
        this.currentTextCellDescriptor = MutableTextDescriptor.getCellTextDescriptor();
        switch (User.getSmartVerticalPlacement()) {
            case 0: {
                this.textSmartVerticalOff.setSelected(true);
                break;
            }
            case 1: {
                this.textSmartVerticalInside.setSelected(true);
                break;
            }
            case 2: {
                this.textSmartVerticalOutside.setSelected(true);
            }
        }
        switch (User.getSmartHorizontalPlacement()) {
            case 0: {
                this.textSmartHorizontalOff.setSelected(true);
                break;
            }
            case 1: {
                this.textSmartHorizontalInside.setSelected(true);
                break;
            }
            case 2: {
                this.textSmartHorizontalOutside.setSelected(true);
            }
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.textFace.addItem("DEFAULT FONT");
        for (int i = 0; i < fontNames.length; ++i) {
            this.textDefaultFont.addItem(fontNames[i]);
            this.textFace.addItem(fontNames[i]);
        }
        this.textDefaultFont.setSelectedItem(User.getDefaultFont());
        this.textGlobalScale.setText(TextUtils.formatDouble(User.getGlobalTextScale() * 100.0));
        this.textNodes.setSelected(true);
        this.textButtonChanged();
        this.textNodes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textArcs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textPorts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textAnnotation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textInstances.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textCellText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textPoints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textUnits.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textItalic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textBold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textUnderline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textFace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textAnchor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textNewVisibleInsideCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textPointSize.getDocument().addDocumentListener(new TextSizeDocumentListener(this));
        this.textUnitSize.getDocument().addDocumentListener(new TextSizeDocumentListener(this));
    }

    private void textValuesChanged() {
        TextDescriptor.ActiveFont af;
        if (this.textValuesChanging) {
            return;
        }
        if (this.textPoints.isSelected()) {
            int size = TextUtils.atoi(this.textPointSize.getText());
            this.currentTextDescriptor.setAbsSize(size);
        } else {
            double size = TextUtils.atof(this.textUnitSize.getText());
            this.currentTextDescriptor.setRelSize(size);
        }
        this.currentTextDescriptor.setItalic(this.textItalic.isSelected());
        this.currentTextDescriptor.setBold(this.textBold.isSelected());
        this.currentTextDescriptor.setUnderline(this.textUnderline.isSelected());
        this.currentTextDescriptor.setPos((TextDescriptor.Position)this.textAnchor.getSelectedItem());
        this.currentTextDescriptor.setInterior(this.textNewVisibleInsideCell.isSelected());
        int face = 0;
        if (this.textFace.getSelectedIndex() != 0 && (af = TextDescriptor.ActiveFont.findActiveFont((String)this.textFace.getSelectedItem())) != null) {
            face = af.getIndex();
        }
        this.currentTextDescriptor.setFace(face);
    }

    private void textButtonChanged() {
        this.currentTextDescriptor = null;
        if (this.textNodes.isSelected()) {
            this.currentTextDescriptor = this.currentTextNodeDescriptor;
        } else if (this.textArcs.isSelected()) {
            this.currentTextDescriptor = this.currentTextArcDescriptor;
        } else if (this.textPorts.isSelected()) {
            this.currentTextDescriptor = this.currentTextExportDescriptor;
        } else if (this.textAnnotation.isSelected()) {
            this.currentTextDescriptor = this.currentTextAnnotationDescriptor;
        } else if (this.textInstances.isSelected()) {
            this.currentTextDescriptor = this.currentTextInstanceDescriptor;
        } else if (this.textCellText.isSelected()) {
            this.currentTextDescriptor = this.currentTextCellDescriptor;
        }
        this.loadCurrentDescriptorInfo();
    }

    private void loadCurrentDescriptorInfo() {
        this.textValuesChanging = true;
        TextDescriptor.Size size = this.currentTextDescriptor.getSize();
        if (size.isAbsolute()) {
            this.textPoints.setSelected(true);
            this.textPointSize.setText(Integer.toString((int)size.getSize()));
            this.textUnitSize.setText("");
        } else {
            this.textUnits.setSelected(true);
            this.textUnitSize.setText(TextUtils.formatDouble(size.getSize()));
            this.textPointSize.setText("");
        }
        this.textItalic.setSelected(this.currentTextDescriptor.isItalic());
        this.textBold.setSelected(this.currentTextDescriptor.isBold());
        this.textUnderline.setSelected(this.currentTextDescriptor.isUnderline());
        this.textAnchor.setSelectedItem(this.currentTextDescriptor.getPos());
        this.textValuesChanging = false;
        this.textNewVisibleInsideCell.setSelected(this.currentTextDescriptor.isInterior());
        int face = this.currentTextDescriptor.getFace();
        if (face == 0) {
            this.textFace.setSelectedIndex(0);
        } else {
            String fontName = TextDescriptor.ActiveFont.findActiveFont(face).getName();
            this.textFace.setSelectedItem(fontName);
        }
    }

    public void term() {
        double currentGlobalScale;
        String currentFontName = (String)this.textDefaultFont.getSelectedItem();
        if (!currentFontName.equalsIgnoreCase(User.getDefaultFont())) {
            User.setDefaultFont(currentFontName);
        }
        if (!this.currentTextNodeDescriptor.equals(this.initialTextNodeDescriptor)) {
            TextDescriptor.setNodeTextDescriptor(this.currentTextNodeDescriptor);
        }
        if (!this.currentTextArcDescriptor.equals(this.initialTextArcDescriptor)) {
            TextDescriptor.setArcTextDescriptor(this.currentTextArcDescriptor);
        }
        if (!this.currentTextExportDescriptor.equals(this.initialTextExportDescriptor)) {
            TextDescriptor.setExportTextDescriptor(this.currentTextExportDescriptor);
        }
        if (!this.currentTextAnnotationDescriptor.equals(this.initialTextAnnotationDescriptor)) {
            TextDescriptor.setAnnotationTextDescriptor(this.currentTextAnnotationDescriptor);
        }
        if (!this.currentTextInstanceDescriptor.equals(this.initialTextInstanceDescriptor)) {
            TextDescriptor.setInstanceTextDescriptor(this.currentTextInstanceDescriptor);
        }
        if (!this.currentTextCellDescriptor.equals(this.initialTextCellDescriptor)) {
            TextDescriptor.setCellTextDescriptor(this.currentTextCellDescriptor);
        }
        int currInt = 0;
        if (this.textSmartVerticalInside.isSelected()) {
            currInt = 1;
        } else if (this.textSmartVerticalOutside.isSelected()) {
            currInt = 2;
        }
        if (currInt != User.getSmartVerticalPlacement()) {
            User.setSmartVerticalPlacement(currInt);
        }
        currInt = 0;
        if (this.textSmartHorizontalInside.isSelected()) {
            currInt = 1;
        } else if (this.textSmartHorizontalOutside.isSelected()) {
            currInt = 2;
        }
        if (currInt != User.getSmartHorizontalPlacement()) {
            User.setSmartHorizontalPlacement(currInt);
        }
        if ((currentGlobalScale = TextUtils.atof(this.textGlobalScale.getText()) / 100.0) != User.getGlobalTextScale()) {
            User.setGlobalTextScale(currentGlobalScale);
        }
    }

    private void initComponents() {
        this.textSizeGroup = new ButtonGroup();
        this.textTypeGroup = new ButtonGroup();
        this.textVerticalGroup = new ButtonGroup();
        this.textHorizontalGroup = new ButtonGroup();
        this.text = new JPanel();
        this.top = new JPanel();
        this.jLabel41 = new JLabel();
        this.textNodes = new JRadioButton();
        this.textArcs = new JRadioButton();
        this.textPorts = new JRadioButton();
        this.textAnnotation = new JRadioButton();
        this.textInstances = new JRadioButton();
        this.textCellText = new JRadioButton();
        this.jLabel42 = new JLabel();
        this.textPointSize = new JTextField();
        this.textUnitSize = new JTextField();
        this.jLabel43 = new JLabel();
        this.textFace = new JComboBox();
        this.textItalic = new JCheckBox();
        this.textBold = new JCheckBox();
        this.textUnderline = new JCheckBox();
        this.textPoints = new JRadioButton();
        this.textUnits = new JRadioButton();
        this.jSeparator3 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.textAnchor = new JComboBox();
        this.textNewVisibleInsideCell = new JCheckBox();
        this.middle = new JPanel();
        this.jLabel44 = new JLabel();
        this.textDefaultFont = new JComboBox();
        this.jLabel1 = new JLabel();
        this.textGlobalScale = new JTextField();
        this.jLabel2 = new JLabel();
        this.bottom = new JPanel();
        this.jLabel56 = new JLabel();
        this.textSmartVerticalOff = new JRadioButton();
        this.textSmartVerticalInside = new JRadioButton();
        this.textSmartVerticalOutside = new JRadioButton();
        this.jLabel57 = new JLabel();
        this.textSmartHorizontalOff = new JRadioButton();
        this.textSmartHorizontalInside = new JRadioButton();
        this.textSmartHorizontalOutside = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TextTab.this.closeDialog(evt);
            }
        });
        this.text.setLayout(new GridBagLayout());
        this.top.setLayout(new GridBagLayout());
        this.top.setBorder(new TitledBorder("Default Text Style"));
        this.jLabel41.setText("Which type of text:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.top.add((Component)this.jLabel41, gridBagConstraints);
        this.textNodes.setText("Nodes");
        this.textTypeGroup.add(this.textNodes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textNodes, gridBagConstraints);
        this.textArcs.setText("Arcs");
        this.textTypeGroup.add(this.textArcs);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textArcs, gridBagConstraints);
        this.textPorts.setText("Exports/Ports");
        this.textTypeGroup.add(this.textPorts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textPorts, gridBagConstraints);
        this.textAnnotation.setText("Annotation text");
        this.textTypeGroup.add(this.textAnnotation);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textAnnotation, gridBagConstraints);
        this.textInstances.setText("Instance names");
        this.textTypeGroup.add(this.textInstances);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textInstances, gridBagConstraints);
        this.textCellText.setText("Cell text");
        this.textTypeGroup.add(this.textCellText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textCellText, gridBagConstraints);
        this.jLabel42.setText("Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel42, gridBagConstraints);
        this.textPointSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textPointSize, gridBagConstraints);
        this.textUnitSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textUnitSize, gridBagConstraints);
        this.jLabel43.setText("Font::");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel43, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textFace, gridBagConstraints);
        this.textItalic.setText("Italic");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textItalic, gridBagConstraints);
        this.textBold.setText("Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textBold, gridBagConstraints);
        this.textUnderline.setText("Underline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textUnderline, gridBagConstraints);
        this.textPoints.setText("Points (max 63)");
        this.textSizeGroup.add(this.textPoints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textPoints, gridBagConstraints);
        this.textUnits.setText("Units (max 127.75)");
        this.textSizeGroup.add(this.textUnits);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textUnits, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jSeparator3, gridBagConstraints);
        this.jLabel4.setText("Default style:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel6.setText("Anchor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textAnchor, gridBagConstraints);
        this.textNewVisibleInsideCell.setText("Invisible outside cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textNewVisibleInsideCell, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.text.add((Component)this.top, gridBagConstraints);
        this.middle.setLayout(new GridBagLayout());
        this.jLabel44.setText("Default font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.middle.add((Component)this.jLabel44, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.middle.add((Component)this.textDefaultFont, gridBagConstraints);
        this.jLabel1.setText("Global text scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.middle.add((Component)this.jLabel1, gridBagConstraints);
        this.textGlobalScale.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.middle.add((Component)this.textGlobalScale, gridBagConstraints);
        this.jLabel2.setText("percent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.middle.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.text.add((Component)this.middle, gridBagConstraints);
        this.bottom.setLayout(new GridBagLayout());
        this.bottom.setBorder(new TitledBorder("Smart Placement of Export Text"));
        this.jLabel56.setText("Vertical");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.bottom.add((Component)this.jLabel56, gridBagConstraints);
        this.textSmartVerticalOff.setText("Off");
        this.textVerticalGroup.add(this.textSmartVerticalOff);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom.add((Component)this.textSmartVerticalOff, gridBagConstraints);
        this.textSmartVerticalInside.setText("Inside");
        this.textVerticalGroup.add(this.textSmartVerticalInside);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom.add((Component)this.textSmartVerticalInside, gridBagConstraints);
        this.textSmartVerticalOutside.setText("Outside");
        this.textVerticalGroup.add(this.textSmartVerticalOutside);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.bottom.add((Component)this.textSmartVerticalOutside, gridBagConstraints);
        this.jLabel57.setText("Horizontal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.bottom.add((Component)this.jLabel57, gridBagConstraints);
        this.textSmartHorizontalOff.setText("Off");
        this.textHorizontalGroup.add(this.textSmartHorizontalOff);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom.add((Component)this.textSmartHorizontalOff, gridBagConstraints);
        this.textSmartHorizontalInside.setText("Inside");
        this.textHorizontalGroup.add(this.textSmartHorizontalInside);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom.add((Component)this.textSmartHorizontalInside, gridBagConstraints);
        this.textSmartHorizontalOutside.setText("Outside");
        this.textHorizontalGroup.add(this.textSmartHorizontalOutside);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.bottom.add((Component)this.textSmartHorizontalOutside, gridBagConstraints);
        this.jSeparator1.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.bottom.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.text.add((Component)this.bottom, gridBagConstraints);
        this.getContentPane().add((Component)this.text, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class TextSizeDocumentListener
    implements DocumentListener {
        TextTab dialog;

        TextSizeDocumentListener(TextTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.textValuesChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.textValuesChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.textValuesChanged();
        }
    }
}

